/*
 * Toy operator table
 */
#include <stdio.h>
#include "interf.h"

#define OPERATORS 80

typedef struct {
   int prefixpriority;
   int infixpriority;
   int postfixpriority;
   int specifier;
   char *operator;
} operatortype;

operatortype operatortable[OPERATORS];

void initoperators()
{
  int i;
  for (i=0; i<OPERATORS; i++) {
    operatortable[i].specifier = 0;
    operatortable[i].prefixpriority = operatortable[i].infixpriority = operatortable[i].postfixpriority = 0;
    operatortable[i].operator = (char *)NULL;
  }
}

int addoperator(pri, spec, op)
int pri;
int spec;
char *op;
{
  int i;
  for (i=0; i<OPERATORS && operatortable[i].operator && strcmp(operatortable[i].operator,op); i++) ;
  if (i<OPERATORS) {
    if (isprefix(spec) && isprefix(operatortable[i].specifier)) 
      {printf("Operator clash (%s)\n", op); return 0;}
    if (isinfix(spec) && (isinfix(operatortable[i].specifier) || ispostfix(operatortable[i].specifier))) 
      {printf("Operator clash (%s)\n", op); return 0;}
    if (ispostfix(spec) && (ispostfix(operatortable[i].specifier) || isinfix(operatortable[i].specifier))) 
      {printf("Operator clash (%s)\n", op); return 0;}
    operatortable[i].specifier |= spec;
    if (isprefix(spec))
      operatortable[i].prefixpriority = pri;
    else if (isinfix(spec)) 
      operatortable[i].infixpriority = pri;
    else 
      operatortable[i].postfixpriority = pri;
    if (!operatortable[i].operator) {
      operatortable[i].operator = (char *)malloc(strlen(op)+1);
       strcpy(operatortable[i].operator,op);
    }
    return 1;
  } else {
    printf("Operator table full\n");
    return 0; 
  }
}

int findoperator(op, prepri, inpri, postpri, spec)
char *op;
int *prepri, *inpri, *postpri, *spec;
{
  int i;
  for (i=0; i<OPERATORS && operatortable[i].operator && strcmp(operatortable[i].operator,op); i++) ;
  if (operatortable[i].operator && !strcmp(operatortable[i].operator,op)) {
    *prepri = operatortable[i].prefixpriority;
    *inpri = operatortable[i].infixpriority;
    *postpri = operatortable[i].postfixpriority;
    *spec = operatortable[i].specifier;
    return 1;
  } else {
    *prepri = 0;
    *inpri = 0;
    *postpri = 0;
    *spec = 0;
    return 0;
  }
}

int isoperator(op)
char *op;
{
  int prepri, inpri, postpri, spec;
  return operator(op, &prepri, &inpri, &postpri, &spec);
}

void predefinedoperators()
{
  addoperator(1200, XFX, ":-");
  addoperator(1200, XFX, "-->");
  addoperator(1200,  FX, ":-");
  addoperator(1200,  FX, "?-");
  addoperator(1100, XFY, ";");
  addoperator(1050, XFY, "->");
  addoperator(1000, XFY, ",");
  addoperator( 900,  FY, "\\+");  /* binprolog */
  addoperator( 700, XFX, "=");
  addoperator( 700, XFX, "\\=");
  addoperator( 700, XFX, "==");
  addoperator( 700, XFX, "\\==");
  addoperator( 700, XFX, "@<");
  addoperator( 700, XFX, "@=<");
  addoperator( 700, XFX, "@>");
  addoperator( 700, XFX, "@>=");
  addoperator( 700, XFX, "=..");
  addoperator( 700, XFX, "is");
  addoperator( 700, XFX, "=:=");
  addoperator( 700, XFX, "=\\=");
  addoperator( 700, XFX, "<");
  addoperator( 700, XFX, "=<");
  addoperator( 700, XFX, ">");
  addoperator( 700, XFX, ">=");
  addoperator( 500, YFX, "+");
  addoperator( 500, YFX, "-");
  addoperator( 500, YFX, "/\\");
  addoperator( 500, YFX, "\\/");
  addoperator( 500, YFX, "#");  /* binprolog */
  addoperator( 400, YFX, "*");
  addoperator( 400, YFX, "/");
  addoperator( 400, YFX, "//");
  addoperator( 400, YFX, "rem");
  addoperator( 400, YFX, "mod");
  addoperator( 400, YFX, "<<");
  addoperator( 400, YFX, ">>");
  addoperator( 200, XFX, "**");
  addoperator( 200, XFY, "^");
  addoperator( 200,  FY, "-");
  addoperator( 200,  FY, "\\");
  addoperator( 100, XFY, "@");
  addoperator(  50, XFY, ":");

  addoperator(950, YF, "&");
  addoperator(950, FY, "?");
/*  addoperator(950, FY, "!"); */

  addoperator(200, FY, "++");
  addoperator(200, YF, "--");

  addoperator(945, XF, "xf");
  addoperator(945, YF, "yf");
  addoperator(945, FX, "fx");
  addoperator(945, FY, "fy");
  addoperator(945,XFX,"xfx");
  addoperator(945,XFY,"xfy");
  addoperator(945,YFX,"yfx");
}
   
void showoperators()
{
  int i;
  for (i=0; i<OPERATORS; i++) {
    printf("%2d) %4d %4d %4d: ", i, 
         operatortable[i].prefixpriority, 
         operatortable[i].infixpriority, 
         operatortable[i].postfixpriority);

    if (operatortable[i].specifier & FX) printf("fx ");
    else if (operatortable[i].specifier & FY) printf("fy "); else printf("   ");

    if (operatortable[i].specifier & XFX) printf("xfx ");
    else if (operatortable[i].specifier & XFY) printf("xfy ");
    else if (operatortable[i].specifier & YFX) printf("yfx ");
    else if (operatortable[i].specifier & XF ) printf("xf  ");
    else if (operatortable[i].specifier & YF ) printf("yf  ");
    printf(" %s\n", operatortable[i].operator);
  }
}
