/* 
This program performs symbolic differentiation. 

Sample forms to differentiate:

  ?-d(x+1,x,X).
  ?-d(x*x-2,x,X).

See C & M for more on this. 
*/


?-op( 9, fx, '%' ).

d(X,X,1) :- !.
d(C,X,0) :- atomic(C).
d(%U, X, %A) :- d( U, X, A ).
d( U+V, X, A+B) :- d(U,X,A), d(V,X,B).
d( U-V, X, A-B ) :- d(U,X,A), d(V,X,B).
d(C*U,X,C*A) :- atomic(C), C \= X, d(U,X,A), !.
d(U*V,X,B*U+A*V) :- d(U,X,A), d(V,X,B).
d(U/V,X,A) :- d(U*V**(%1),X,A).
d(U**V,X,V*W*U**(V-1)) :- atomic(V), c \= X, d(U,X,W).
d(log(U),X,A*U**(%1)) :- d(U,X,A).
