/*  EDIT version 1.02 (VMS)  */


/*
 *    Prolog Clause Editor (PROTED: Standalone with protected names)
 *    by W F Clocksin for Expert Systems, Ltd.
 *    Copyright (c) 1981,  All Rights Reserved.
 *    Modified by Jocelyn N Paine, 1982.
 */
 
 
/*  .$edit_version( Atom ):
      Atom is the version number, in N.NN format.
*/
'.$edit_version'( '1.01 (VMS)' ).


/*  edit:
      Invoke the editor.
 
    edit(P):
      P is a predicate name.
      edit(P) is equivalent to
        '$prepare'(P), edit.
*/
edit(P) :- '$prepare'(P), edit.
 
edit :- 
	( 
	  '$preds_are'( _ )
	;
	  assert( '$preds_are'([]) )
	), !,
	edit1.


edit1 :- repeat, write('ed> '), get(C), trimcore, '$do_edit_command'(C).
 
 
/*  '$do_edit_command'( C ):
      C is an integer denoting an edit command character.
 
      '$do_edit_command' checks that C is a valid command, and
      calls the appropriate part of the editor.
*/
 
/* l */
'$do_edit_command'(108) :-  !, skip(13), '$consider'(F), '$functors_clauses_are'(F,L), '$show_clauses_numbered'(L), !, fail.
 
/* a */
'$do_edit_command'(97) :-
        !, skip(13), seeing(I), see(user),
        repeat, write(': '), read(T,V), '$do_new_statement'(T,V),
        seen, see(I), nl, !, fail.
 
/* g */
'$do_edit_command'(103) :-
	!, '$read_first_word'( F ), '$check_file'( F ),
	seeing( I ), see( F ), repeat,
	read( T, V ),
        '$do_new_statement'(T,V), seen, see(I), !, fail.
 
/* q */
'$do_edit_command'( 113 ) :-
	skip( 13 ),
	retract( '$is_current_pred'(_) ),
	! .
'$do_edit_command'(113) :- !.
 
/* c */
'$do_edit_command'(99) :- !, '$read_first_word'(P), '$prepare'(P), '$functors_clauses_are'(P,L), !, fail.
 
/* w */
'$do_edit_command'( 119 ) :-
	!, skip(13), '$map_preds'('$list_one'), !, fail.
 
/* s */
'$do_edit_command'(115) :-
	!,
	( '$consider'(P) ; !, skip(13), fail ),
	'$read_first_word'( F ),
	!, '$check_file'( F ),
	telling( T ),
	tell( F ),
        '$functors_clauses_are'(P,L), '$show_clauses_unnumbered'(L), told, tell(T), !, fail.
 
/* S */
'$do_edit_command'(83) :-
	!, '$read_first_word'( F ),
	'$check_file'( F ),
	telling( T ), tell( F ), 
	assert( '$file'(F) ),
	'$map_preds'( '$save_one' ),
	retract( '$file'(F) ), 
	told, tell( T ), !, fail.
 
/* d */
'$do_edit_command'( 100 ) :-
	!, skip( 13 ),
	'$consider'( F ),
	'$functors_clauses_are'( F, L ),
	'$delete_clauses'( L ),
	retract( '$is_current_pred'(F) ),
	retract( '$functors_clauses_are'(F,_) ),
	'$no_pred'( F ),
	write(F), write(' has been deleted and is no longer the current predicate.'), nl,
	!, fail.

/* D */
'$do_edit_command'( 68 ) :-
	!, skip( 13 ),
	'$map_preds'( '$delete_one' ),
	retract( '$is_current_pred'(_) ), 
	!, fail.

/* number */
'$do_edit_command'(C) :-  47<C, C<58, !, X is C-48, '$read_number'(X,N,Y), '$do_numeric_command'(N,Y), !, fail.
 
/* other character - invalid command */
'$do_edit_command'(C) :-
        write('command ('), put(C), write(') not recognised.'),
        skip(13), nl, !, fail.
 
 
/*  '$delete_clauses'( L ):
      Remove all clauses in L from the database.
*/
'$delete_clauses'( [] ).

'$delete_clauses'( [ text_for_clause(_,C,_) | T ] ) :-
	'$split_clause'( C, F, _, N ),
	functor( Hd, F, N ), retractall( Hd ),
	'$delete_clauses'( T ), !.


/*
    Delete a predicate: used by D.
*/
'$delete_one'( F ) :-
	'$functors_clauses_are'( F, L ),
	'$delete_clauses'( L ),
	retract( '$functors_clauses_are'(F,_) ),
	'$no_pred'( F ),
	write(F), write(' deleted.'), nl.


/*
    Save a predicate: used by S.
*/
'$save_one'( P ) :-
	'$file'( F ),
        '$functors_clauses_are'(P,L), L = [_|_], '$show_clauses_unnumbered'(L),
        nl, tell(user), write(P), write(' saved.'), nl, tell(F).
 
 
/*  '$do_new_statement'( T, V ):
      T: a term.
      V: a structure containing its variables.
      T and V are defined as if generated by "read(T,V)".
 
      If T is end_of_file, succeeds.
      If T is a question, calls T and fails.
 
      Otherwise, converts T and V into an internal representation
      for the term, and adds them to the list of clauses for
      T's principal functor.
*/
'$do_new_statement'(end_of_file,_) :- !.
'$do_new_statement'(?-L,_) :- !, call(L), trimcore, !, fail.
'$do_new_statement'(L,V) :- '$split_clause'(L,F,_,_), '$add_clause'(F,L,V), !, fail.
 
 
/*  '$add_clause'( F, C, V ):
      F: the main functor of a term.
      C: the term itself.
      V: the term's variables, as given by "'$do_new_statement'"
 
      Adds the definition C of F to the list of
      definitions already known for F, and to the database.
*/
'$add_clause'(F,C,V) :-
	(
	  retract( '$functors_clauses_are'( F, L ) )
	;
	  L = [],
	  '$new_pred'( F )
	),
	!,
        '$append_clause_to_list'(text_for_clause(_,C,V),L,L1),
	assertz( C ),
        asserta('$functors_clauses_are'(F,L1)),
        !.
 
 
/*
    List a predicate: used by w.
*/
'$list_one'( P ) :-
	'$functors_clauses_are'( P, _ ), write(P), nl.
 
 
/*  '$do_numeric_command'( N, C ):
      N: integer
      C: character following it.
 
      N and C are as given by an edit command which starts
      with a clause number.
 
      If C is full stop, delete clause number N
      from the definitions of the current predicate;
      if that predicate is left with no clauses, delete it
      altogether.
 
      If C is space, read a clause and add it as number N
      to that list.
*/
'$do_numeric_command'(N,46) :-
	!, ( '$consider'(P) ; skip(13), fail ),
	!,
	retract( '$functors_clauses_are'(P,L) ),
	( '$remove_numbered_clause'(N,L,L1)
	; L1=L, write('there is no clause with this number.'), nl
	), !,
        ( L1 = [],
	  retract( '$is_current_pred'(P) ),
	  '$no_pred'( P ),
	  write(P), write(' has been deleted and is no longer the current predicate.'),nl
        ;
          L1 \= [],
	  asserta( '$functors_clauses_are'(P,L1) )
        ),
	skip(13),
	!.
 
'$do_numeric_command'(N,32) :-
	!, ( '$consider'(P) ; skip(13), fail ),
	!,
        read(X,Y),
	'$split_clause'( X, Main, _ , Arity ),
        ( P = Main,
          retract('$functors_clauses_are'(P,L)),
	  ( '$remove_numbered_clause'( N, L, Ld ) ; Ld = L ), !,
          '$insert_clause_to_list'(text_for_clause(N,X,Y),Ld,L1),
	  '$remove_from_database'( Arity, Main, L ),
	  '$add_to_database'( Arity, Main, L1 ),
          asserta('$functors_clauses_are'(P,L1))
        ;
          P \= Main,
	  write('you may only insert clauses for the current predicate ('),
	  write(P), write('), not for '), write(Main), write('.'),nl
        ),
        ! .
 
'$do_numeric_command'(_,C) :-
	write('number must be followed by space or dot.'),
	( C = 13 ; skip(13) ),
	nl, !.
 
 
/*  '$consider'( P ):
      P: a predicate name.
 
      If there is a current predicate, unify its name
      with P, else fail.
*/
'$consider'(P) :- '$is_current_pred'(P), !.
'$consider'(_) :- write('you must first consider a procedure.'), nl, !, fail.
 
 
/*  '$remove_numbered_clause'( N, L, L1 ):
      N: integer
      L: list of clauses for a predicate
 
      Remove clause number N from L giving L1,
      and update the database to correspond with L1.
      Fail if no such clause is in L.
*/
'$remove_numbered_clause'( N, L, L1 ) :-
	'$remove_clause_from_list'( N, L, L1, C ),
	'$split_clause'( C, P, _, Arity ),
	'$remove_from_database'( Arity, P, L ),
	'$add_to_database'( Arity, P, L1 ).
 
 
/*  '$remove_clause_from_list'( N, L, L1, C ):
      Remove clause numbered N from list L giving L1.
      Set C to the clause.
      Fail if there is no such clause in L.
*/
'$remove_clause_from_list'( N, [text_for_clause(N,C,_)|L], L, C ) :- !.
'$remove_clause_from_list'( N, [E|L], [E|L1], C ) :- '$remove_clause_from_list'( N, L, L1, C ).
 
 
/*  '$insert_clause_to_list'( E, L, L1 ):
      E : text_for_clause( N, C, V ) where
	  N  : clause number.
	  C  : clause.
          V  : clause variables.
      Insert E into L at position specified by N, giving L1.
*/
'$insert_clause_to_list'(E,[],[E]) :- !.
'$insert_clause_to_list'(text_for_clause(N,C,V),[text_for_clause(N,_,_)|L],[text_for_clause(N,C,V)|L]) :- !.
'$insert_clause_to_list'(text_for_clause(N,C,V),[text_for_clause(N1,C1,V1)|L],Z) :-
        N < N1, Z = [text_for_clause(N,C,V),text_for_clause(N1,C1,V1)|L], !.
'$insert_clause_to_list'(E,[E1|L],[E1|L1]) :- '$insert_clause_to_list'(E,L,L1).
 
 
/*  '$append_clause_to_list'( E, L, L1 ):
      E : text_for_clause( N, C, V ), 
          where N is uninstantiated.
          C : the clause.
          V  : the variables.
      L : list of definitions for the predicate.
      L1: will be instantiated to a new list of definitions,
          with E at its end.

          N will be instantiated to a clause number for the clause.
*/
'$append_clause_to_list'( E, L, L1 ) :-
	/*  When L has only one element, find next clause number from it, and put clause on end  */
	L = [ T ],
	T = text_for_clause( Final, _, _ ),
	E = text_for_clause( Next, C, V ),
	Next is ( (Final+10) // 10 ) * 10,
	L1 = [ T | [ E ] ], !.

'$append_clause_to_list'( E, [ H | Tl ], [ H | Tl1 ] ) :-
	/*  if L has more than one element, recurse  */
	'$append_clause_to_list'( E, Tl, Tl1 ), !.

'$append_clause_to_list'( 
			  text_for_clause( Next, C, V ),
			  [],
			  [ text_for_clause( Next, C, V ) ]
			) :-
	/*  If L is empty, make new list whose clause number is 10  */
	Next = 10, !.


/*  '$prepare'( P ):
      P: predicate name
 
      If P is known to the editor, make it the current predicate.
 
      Otherwise, error and fail.
*/
'$prepare'(P) :-
        '$functors_clauses_are'(P,L), !,
        (retract('$is_current_pred'(_)) ; true), asserta('$is_current_pred'(P)), !.
'$prepare'(P) :-
        write(P), write(' does not exist in editable form.'), nl, !, fail.
 
 
/*  '$remove_from_database'( N, P, L ):
      remove all definitions in L for clauses with predicate P and N arguments from the database
*/
'$remove_from_database'( N, P, _ ) :-
	functor( Hd, P, N ), retractall( Hd ), !.
 
 
/*  '$show_term'( A ):
       A: a term.
 
       Write A neatly. 
       Uses the predicate '.$edpr' which is exported as a system
       predicate, and used mainly for 'listing'.

       ''$show_term'' acts like '.$edpr', but converts a clause
       which is just a fact into a rule.
*/
'$show_term'( A:-B ) :- !, '.$edpr'( A:-B ), !.
'$show_term'( A ) :- '.$edpr'( A:-true ), !.
 
 
/*  '$show_clauses_numbered'( L ):
      write the clauses in list L, with clause numbers.
*/
'$show_clauses_numbered'([]) :- !.
'$show_clauses_numbered'([text_for_clause(N,C,V)|L]) :-
         '$set_variable_names'(V,C), write(N), tab(2), '$show_term'(C), '$show_clauses_numbered'(L).
 
 
/*  '$show_clauses_unnumbered'( L ):
      write the clauses in list L without clause numbers.
*/
'$show_clauses_unnumbered'([]) :- !.
'$show_clauses_unnumbered'([text_for_clause(N,C,V)|L]) :- '$set_variable_names'(V,C), '$show_term'(C), '$show_clauses_unnumbered'(L).
 
 
/*  '$set_variable_names'( V, C ):
      V is a structure containing variables and their
      names, as given by the 2nd argument to "read".
      C is a clause.
 
      Instantiate each variable to its name, so that
      when it is written (e.g. by "write" from "'$show_term'")
      its name will be written.
 
      Uses the system operator '.$' which
      creates a structure to be written specially:
      '.$'(L) is written as the (unquoted) string formed
      by the characters of list L.
*/
'$set_variable_names'( V, C ) :-
	'$name_known_vars'( V ), !.


/*  '$name_known_vars'( S ):
      Instantiate each variable in S to its name.
*/
'$name_known_vars'( [] ).
'$name_known_vars'(.(V,L,T)) :- (nonvar(V) ; V = '.$'(L)), '$name_known_vars'(T).
 
 
/*  '$add_to_database'( N, P, L ):
      assert all clauses in L which have predicate P and
      N arguments into the database.
*/
'$add_to_database'( N, P, [] ) :- !.
'$add_to_database'( N, P, [text_for_clause(_,C,_)|T] ) :-
	( '$split_clause'(C,P,_,N), assertz(C) ; true ),
	!, 
	'$add_to_database'( N, P, T ).
 
 
/*  '$split_clause'( C, F, Cn, N ):
      C : a clause, e.g. a(1) or x(Y,Z) :- true.
      F : uninstantiated or an atom.
      Cn: uninstantiated.
      N : uninstantiated, or a number.

      If C is of the form Hd:-Tl, sets Cn to C, 
      else sets Cn to C:-true  -
      i.e. it '$append's a :- true to facts.
      
      Unifies N with the number of arguments in Cn's head, and
      F with its principal functor.
*/
'$split_clause'( (A:-B), F, (A:-B), N ) :- functor( A, F, N ).
'$split_clause'( A, F, (A:-true), N ) :- functor( A, F, N ).


/*  '$check_file'( F ):
      Fail if F (a filename) has bad syntax.
      In this case, checks to see that F contains
      something other than non_printing characters.
*/
'$check_file'( F ) :-
	retractall( '$char_ok' ),
	name( F, L ),
	'$map'( L, '$good_char' ),
	(
	  '$char_ok', retract('$char_ok')
	;
	  write('bad filename.'), nl, !, fail
	), !.


/*  '$good_char'( C ):
      If C is printing, assert('$char_ok').
      Used in '$check_file'.
      Must not fail, or ''$map'' will fail too soon.
*/
'$good_char'( C ) :-
	C > 32, C < 127, assert('$char_ok').
'$good_char'(_).


/*  '$read_number'( C, N, Cn ):
      C:  character.
      N:  uninstantiated.
      Cn: uninstantiated.
 
      Read a number whose first character is C; return number
      in N; return terminator of number in Cn.
*/
'$read_number'(C,N,Cn) :-
        get0(C1),
          (
          (47<C1, C1<58, !, C2 is 10*C+(C1-48), '$read_number'(C2,N,Cn))
          ;
          (Cn = C1, N = C)
          ).
 
 
/*  '$read_first_word'( X ):
      instantiate X to an atom which is the first word
      (thing terminated by space, newline or dot; or quoted string) read.
*/
'$read_first_word'(X) :-
        '$get_non_space'(C),
	( C = 39, '$read_quoted'(Y) ; C \= 39, '$read_word_list'(Y,C) ),
        name(X,Y), !.
 
 
/*  '$read_quoted'( Y ):
      Read characters up to the next quote, and unify Y with
      the list of them.
*/
'$read_quoted'( Y ) :-
	get0( C ),
	( C = 39, Y = []
	;
	  C \= 39, Y = [C|T], '$read_quoted'(T)
        ), !.


/*  '$get_non_space'( C ):
      instantiate C to the first character after a
      (possibly null) sequence of spaces.
*/
'$get_non_space'(C) :-
        repeat,
        get0(C),
        (C\=32 ; C = 13 ),
        !.
 
 
/*  '$read_word_list'( L, C ):
      L : uninstantiated.
      C : character.

      Instantiates L to a list of characters making the
      word read by ''$read_first_word''.
*/
'$read_word_list'([],32) :-
        repeat,
        get0(13),
        !.
'$read_word_list'([],46) :-
        repeat,
        get0(13),
        !.
'$read_word_list'([],13) :- !.
'$read_word_list'([A|B],A) :-
        get0(C),
        '$read_word_list'(B,C).
 
 
/*  '$append'( L, P, L1 ):
      Result of '$append'ing element P to list L is L1.
*/
'$append'( [], P, [P] ) :- !.
'$append'( [H|T], P, [H|T1] ) :- '$append'( T, P, T1 ), !.


/*  '$delete'( L, P, L1 ):
      Result of deleting first element P from list L
      is L1: if P not found, L1 = L.
*/
'$delete'( [P|T], P, T ) :- !.
'$delete'( [], P, [] ) :- !.
'$delete'( [H|T], P, [H|T1] ) :- '$delete'( T, P, T1 ), !.


/*  '$map'( L, P ):
      Apply unary predicate P to each element of list L.
*/
'$map'( [], _ ) :- !.
'$map'( [H|T], P ) :-
	Qn =.. [ P , H ],
	call( Qn ),
	'$map'( T, P ), !.


/*  '$new_pred'( P ):
      Add P to end of list of known predicates.
*/
'$new_pred'( P ) :-
	retract( '$preds_are'(L) ),
	'$append'( L, P, L1 ),
	assert( '$preds_are'(L1) ), !.


/*  '$no_pred'( P ):
      Remove P from list of known predicates.
      Undefined if P not in the list.
*/
'$no_pred'( P ) :-
	retract( '$preds_are'(L) ),
	'$delete'( L, P, L1 ),
	assert( '$preds_are'(L1) ), !.


/*  '$map_preds'( P ):
      Apply unary predicate P to each predicate name
      in list of known predicates.
*/
'$map_preds'( P ) :-
	'$preds_are'( L ), '$map'( L, P ), !.


/*  Initial list of known predicates  */
