/*  MEAN_TIME.PL  */


/*
This predicate runs cpu_time a number of times and outputs the time
for each run, thus giving an idea of the scatter between successive
runs.

I have had to use an ugly version which calls assert/retract to
preserve information. This is because of a bug in Poplog whereby
    not( (A->B;C) )
binds some of the variables in its argument! The original code, which
should work on other systems, or on Poplog version 14 or over, is
commented out.
*/


/*
mean_time( M, N, Goal, D ) :-
    mean_time( M, N, Goal, 0.0, Total ),
    D is Total / M.


mean_time( 0, _, _, Total, Total ) :- !.

mean_time( M, N, Goal, SoFar, Total ) :-
    cpu_time( N, Goal, D ),
    M_less_1 is M-1,
    SoFar_and_D is Sofar + D,
    mean_time( M_less_1, N, Goal, Sofar_and_D, Total ).
*/


/*  mean_time( M+, N+, Goal+, D- ):
        Call cpu_time(N,Goal,Time) M times. Write out the value
        of Time for each call, and return the average total time/M in
        D.
*/
mean_time( M, N, Goal, D ) :-
    retractall( g(_,_,_,_) ),
    mean_time( M, N, Goal, 0.0, Total ),
    D is Total / M.


mean_time( 0, _, _, Total, Total ) :-
    !,
    nl.

mean_time( M, N, Goal, SoFar, Total ) :-
    cpu_time( N, Goal, D ),
    write( D ), write(' '),
    M_less_1 is M-1,
    SoFar_and_D is SoFar + D,
    asserta( g(M_less_1,N,Goal,SoFar_and_D) ),
    fail.

mean_time( M, N, Goal, SoFar, Total ) :-
    g(M_less_1,N,Goal,SoFar_and_D),
    retractall( g(_,_,_,_) ),
    mean_time( M_less_1, N, Goal, SoFar_and_D, Total ).
