/*  LINT.PL  */


/*
This is the top-level file for my simple Lint program.
It does several things:


1) Undefine various Poplop macros that clash with atoms used in the
Tutor. Remove this code if not using Poplog.

You will find a few other references to Poplog throughout the source. If
you are running a different system, you can remove or replace them; I've
had to leave them in so that I can test the version that I'm about to
distribute. All such references are commented.
*/
:- library(macro).
:- killmac("prolog").
:- killmac("teach").
:- killmac("ref").
:- killmac("help").
:- killmac("lib").


/*
2) Turn on 'quietspy' so that calling spy doesn't give all those
irritating messages. Also define a version of spy that doesn't spy on
the term- and goal- expansion predicates. Remove this if not using
Poplog.
*/
:- quietspy(on).
sp :- (spy), (nospy prolog_expand_term),
    (nospy prolog_user_goal),
    (nospy prolog_expand_goal).


/*
3) Load module 'lib'. You will need this, and should read it NOW.
*/
:- reconsult( 'logic$src:lib.pl' ).


/*
5) Load the other files needed.
*/
:- lib(
        [ bug
        , lib
        , chars
        , control
        , useful
        , output
        , lint
        ]
).
