;; Eulisp Module
;; Author: pab
;; File: streams2.em
;; Date: Sun Jul 11 22:26:25 1993
;;
;; Project:
;; Description: 
;;

(defmodule streams2
  (standard0
   list-fns
   )
  ()
  
  (defgeneric stream-class ()
    ((protocol initform nil
	       reader stream-class-protocol))
    direct-initargs (direct-stream-fns)
    )

  (defclass <protocol-obj> ()
    ((computer initarg computer reader protocol-compute-function)
     (getter initarg getter reader protocol-getter-function))
    constructor (protocol-object computer getter)
    )

  (defmethod initialize ((cl stream-class) lst)
    (let ((new-cl (call-next-method))
	  (new-fns (scan-args 'direct-stream-fns lst null-argument)))
      (let ((stream-fns (compute-stream-protocol-functions 
			 new-cl new-fns )))
	((setter stream-class-protocol) new-cl stream-fns)
	new-cl)))

  (defgeneric inputter (stream))
  (defgeneric outputter (stream c))
  (defgeneric flusher  (stream))
  (defgeneric uninput (stream c))
  (defgeneric positioner (stream))
  (defgeneric (setter positioner) (stream n))
  
  (defun input (stream)
    ((inputter stream)))

  (defun output (stream x)
    ((outputter stream) x))

  (defmethod initialize ((x <stream>) lst)
    (let ((next (scan-args 'next lst required-argument))
	  (self (call-next-method)))
      (push self next)))

  (defun push (new next inits)
    (map (lambda (protocol)
	   ((protocol-set-function protocol) new
	    (protocol-compute-function next inits)))
	 (stream-class-protocol (class-of new))))
  
(defclass <stream> ()
  ()
  metaclass <stream-class>
  metaclass-initargs 
  (direct-stream-fns
   (list (protocol-object compute-input-function inputter (setter inputter))
	 (protocol-object compute-output-function outputter (setter outputter))))
  )

(defmethod compute-input-function ((obj <stream>))
  (lambda (next inits)
    (inputter next)))

(defmethod compute-output-function ((obj <stream>))
  (lambda (next inits)
    (inputter next)))

  ;; end module
  )
 
(defclass <line-counting-stream> (<stream>)
  ((count initform 0 accessor stream-line-count))
  )

(defmethod compute-output-function ((x <line-counting-stream>) next args)
  (let ((next (outputter next)))
    (generic-lambda (c)
		    method (((c <character>))
			    (when (eq c #\newline)
			      (inc-posn x))
			    (next c))
		    method (((s <string>))
			    (do (lambda (c)
				  (when (eq c #\newline)
				    (inc-posn x))
				  (next c))
				s)))))

(defmethod compute-position-function ((x <line-counting-stream>) next args)
  (lambda ()
    (error "can't change position" <stream-error>)))

(defmethod compute-position-setter-function 
 ((x <line-counting-stream>) next args)
  (lambda (pos)
    (error "can't change position" <stream-error>)))

NB: should have some predicates: 
  stream-object-type
  input-stream-p
  output-stream-p
  positionable-stream-p
  

	