/**************************************************************************/
/* matrices.c                                                   /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: A. Jansen                                         _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         ajansen@fwi.uva.nl                               | | \/\/ | |  */
/*                                                          | \______/ |  */
/*                                                           \________/   */
/*                                                                        */
/*                                                              /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#include "config.h"

#include <stdio.h>
#include <stdlib.h>

#include "matrices.h"
#include "vector.h"





REAL *alloc_vector(void)
{
  REAL *vp;

  if (!(vp = (REAL *) calloc(HOMO_DEG,sizeof(REAL)))) {
	fprintf(stderr,"can't allocate vector; function: alloc_vector()\n");
	exit(0);
  }

  return vp;
}

REAL **alloc_matrix(void)
{
  REAL **mp;
  short i;

  if (!(mp = (REAL **) calloc(HOMO_DEG,sizeof(REAL *)))) {
	fprintf(stderr,"can't allocate matrix1, function: alloc_matrix()\n");
	exit(0);
  }

  if (!(*mp = (REAL *) calloc(HOMO_DEG * HOMO_DEG,sizeof(REAL)))) {
	fprintf(stderr,"can't allocate matrix2, function: alloc_matrix()\n");
	exit(0);
  }

  /* first pointer already set by previous calloc call */
  for (i = 1; i < HOMO_DEG; i++)
	mp[i] = mp[0] + i * HOMO_DEG;

  return mp;
}

void delete_vector(REAL *vp)
{
	free((char *)vp);
}

void delete_matrix(REAL **mp)
{
	free((char *)*mp);
	free((char *)mp);
}

void mm_prod(REAL **m1, REAL **m2, REAL **m)
{
  short i, j, k;
  REAL *m1_p, *m2_p, *m_p;

  m_p = m[0];
  for (k = 0; k < HOMO_DEG; k++)
	for (j = 0; j < HOMO_DEG; j++, m_p++) {

		m1_p = m1[k];
		m2_p = m2[0] + j;

		*m_p = 0.0;
		for (i = 0; i < HOMO_DEG; i++, m1_p++, m2_p += HOMO_DEG)
			*m_p += *m1_p * *m2_p;
	}
}

void mv_prod(REAL **m, REAL *v1, REAL *v)
{
  short i, j;
  REAL *m_p, *v1_p;

  for (j = 0; j < HOMO_DEG; j++, v++) {
	m_p = m[j];
	v1_p = v1;

	*v = 0.0;

	for (i = 0; i < HOMO_DEG; i++, m_p++, v1_p++)
		*v += *m_p * *v1_p;
  }
}

void cp_matrix(REAL **m, REAL **cm)
{
  short i, j;
  REAL *cm_p, *m_p;

  for (i = 0; i < HOMO_DEG; i++) {
	cm_p = cm[i];
	m_p = m[i];
	for (j = 0; j < HOMO_DEG; j++, cm_p++, m_p++)
		*cm_p = *m_p;
  }
}


void invert_h_matrix(REAL **m, REAL **im)
{
  short i, j;

  for (i = 0; i < HOMO_DEG - 1; i++)
        for (j = 0; j < HOMO_DEG - 1; j++)
		im[j][i] = m[i][j];

  for (i = 0; i < HOMO_DEG - 1; i++) {
	im[i][HOMO_DEG-1] = 0.0;
        for (j = 0; j < HOMO_DEG - 1; j++)
		im[i][HOMO_DEG-1] -= im[i][j] * m[j][HOMO_DEG-1];
  }

  for (i = 0; i < HOMO_DEG - 1; i++)
	im[HOMO_DEG-1][i] = m[HOMO_DEG-1][i];
}
