/**************************************************************************/
/* xgraphics.h                                                  /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/


#ifndef _xgraphics_h
#define _xgraphics_h

#include "config.h"

#include <X11/Xlib.h>		/* Xlibrary include file */
#include <X11/Xutil.h>		/* Xutilities include file */



#ifndef XGRAPHICS_EXTERN
#	define XGRAPHICS_EXTERN extern
#endif
#define TITLE		"Bemmel"
#define BORDER_WIDTH	5       	/* Default border width */
#define DEFAULT_GEOMETRY "600x600+50+50" /* Default geometry */


XGRAPHICS_EXTERN unsigned int width, height;  	/* Size of the window */
XGRAPHICS_EXTERN int x, y;			/* Origin of Winow */
XGRAPHICS_EXTERN unsigned int border;		/* Size border of window */
XGRAPHICS_EXTERN unsigned int depth;		/* Bits per pixel of window */

XGRAPHICS_EXTERN int origx, origy;		/* Origin for drawing */
XGRAPHICS_EXTERN int i_origx, i_origy;		/* Origin for drawing */

XGRAPHICS_EXTERN int new_drawing;		/* Indicates new picture */

XGRAPHICS_EXTERN Display    *display;		/* X server connection */
XGRAPHICS_EXTERN int         screen;		/* Screen ID */
XGRAPHICS_EXTERN Window      root;		/* Root window ID */
XGRAPHICS_EXTERN Window      window;		/* Window ID */
XGRAPHICS_EXTERN Pixmap      pixmap;		/* Pixmap ID */
XGRAPHICS_EXTERN GC          gc_draw;		/* Graphics context for draw */
XGRAPHICS_EXTERN GC          gc_clear;		/* Graphics context for clear */

XGRAPHICS_EXTERN int graphics_setup;		/* indicates window present */

#define EVENT_MASK	(ExposureMask | StructureNotifyMask | KeyPressMask |\
	 		KeyReleaseMask | EnterWindowMask | LeaveWindowMask |\
			ButtonPressMask | ButtonReleaseMask | PointerMotionMask)

/* 
 * Inform the window managers of the requested properties
 * of the window by first storing values in a so-called
 * window manager hints structure that will be communicated
 * to the window managers.
 */

XGRAPHICS_EXTERN XWMHints wmhints;

void init_graphics(int argc,char *argv[]);
void exit_graphics(void);
void redraw_wire_frame(void);
void draw_next_wire_frame(void);
void resize_drawing(int new_width, int new_height);
void handle_next_window_event(void);
void rotate_drawing(REAL dx, REAL dy, REAL df, REAL dt, REAL da, REAL dd);


#endif
