/**************************************************************************/
/* ieee.c                                                       /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
/*
 * Extra for non-SunOS.  These functions are defined in SunOS.
 */

#include "config.h"

#if !HAVE_IEEE_INCLUDES
/*
 * Additions for Linux, suggested by
 * sdh@falstaff.MAE.cwru.edu (Scott Heavner)
 */

#define SMALL_POS 1.0E-012	/* define to whatever you like */
#define SMALL_NEG -SMALL_POS	/* these don't have to be equal */

int l_iszero(double x)
{
  return ((x > SMALL_NEG)&&(x < SMALL_POS));
}

int l_signbit(double x)
{
  return (x < 0.0);
}


#else


#include "ieee.h"
#if !HAVE_SIGNBIT

int l_iszero(double x)
{
  int class;
  class = fp_class_d(x);
  return (class == FP_POS_ZERO || class == FP_NEG_ZERO);
}


int l_signbit(double x)
{
  return fp_class_d(x) == FP_NEG_NORM;
}


#endif /* !HAVE_SIGNBIT */
#endif /* !HAVE_IEEE_INCLUDES */
