/**************************************************************************/
/* data_code.h                                                  /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _data_code_h
#define _data_code_h

#ifndef CHAR_BIT
#	define CHAR_BIT		8
#	define UCHAR_MAX	0xFFU
#	define SCHAR_MAX	0x7F
#endif

#if CHAR_BIT != 8
#	if !HP700
	/* 
	 * HP cc does not know #error, apparently...
	 */
#		error Char is expected to be one byte long!  Consult guru.
#	endif
#endif


#include "config.h"


#define ss_encode(val, buf)	us_encode(val, buf)
#define ss_decode(buf)		(short int) us_decode(buf)
#define sl_encode(val, buf)	ul_encode(val, buf)
#define sl_decode(buf)		(long int) ul_decode(buf)

/* Maximum and minimum exponent.  May not exceed 16383 and -16384
 * without increasing the size of the buffer.  The routines expect
 * that |DBL_EXP_MIN| >= DBL_EXP_MAX.  Used in f_encode() et al.
 */
#define DBL_EXP_MAX	16383
#define DBL_EXP_MIN	(-16384)

void panic(char *fmt, ...);
void us_encode(unsigned short val, char *buf);
unsigned short int us_decode(char *buf);
void ul_encode(unsigned long val, char *buf);
unsigned long int ul_decode(char *buf);
void f_encode(double x, char *buf, int precision);
double f_decode(char *buf, int precision);
unsigned short encode(char *buf, ...);
int decode(char *buf, ...);

#endif
