/**************************************************************************/
/* communication.h                                              /\/\      */
/* Version x.x.x --  August  1991                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
/* Defines for communication between HOST and OSCAR */

#define __USED		"\0\1&?-123CEHNOPRWcfhopqrstwx[]"

/*
 * PANIC sent by client to host to tell it can't continue.
 */
#define PANIC		'?'
#define PANIC_OK	'&'

/*
 * START switches on OSCAR
 */
#define START		's'
#define START_OK	0
#define START_ERROR	1

/*
 * STOP switches off OSCAR
 */
#define STOP		'q'
#define STOP_OK		0
#define STOP_ERROR	1

/*
 * HALT stops the current movement, i.e., the interpolation routine is
 * interrupted and the robot halts.
 */
#define HALT		'h'
#define HALT_OK		0
#define HALT_ERROR	1


/*
 * RESET stops movement and resets internal parameters.
 */
#define RESET		't'
#define RESET_OK	0
#define RESET_ERROR	1


/*
 * WAIT makes the robot move REAL slow (note that this is an
 * understatement).  It is used to make the simulator behave
 * more ideal and less realistic.
 */
#define WAIT		'w'
#define CONTINUE	'x'


/*
 * ROBOT specific messages.
 */
#define NEWPOS		'P'
#define NEWPOS_OK	'p'
#define NEWPOS_BAD	'-'

/*
 * Indicates whether the receiving side should check
 * on validness of the sent joints.
 */
#define CHECK_REACH	'\0'
#define NO_CHECK_REACH	'\1'

/*
 * SEND_JOINTS is sent by SUN to request the current value of all joints,
 * as well as the number of interpolation which still has to be performed for
 * this move.  This latter number is preceded by the following define.
 */

#define SEND_JOINTS	'r'
#define SENT_JOINTS	'R'


/*
 * CAMERA specific messages.
 */

#define CAMERA_1	'1'
#define CAMERA_2	'2'
#define HAND_CAMERA	'3'
#define NO_OBJECT	'N'
#define END_EFFECTOR	'f'
#define OBJECT_POSITION	'o'
#define OBJECT_RECEIVED	'O'


#define HOMO		'H'
