/**************************************************************************/
/* input.c --- almost identical to a version by F. J. Jungen    /\/\      */
/* Version 2.2.1 --  January 1992                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/

#define INPUT_EXTERN


#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include "input.h"
#include "matrix.h"
#include "datastruct.h"

#include "setup.h"



void exception(char *s)
{
  fprintf(stderr, "On line %d: ", lineno);
  fprintf(stderr, s);
  exit(1);
}



void skip_spaces(FILE *fp)
{
  int c;

  do
  {
	c = fgetc(fp);
	if (c == '\n') lineno++;
  } while (isspace(c));
  ungetc(c, fp);
}



void skip_rest(FILE *fp)
{
  int c;

  while ((c = fgetc(fp)) != '\n' && c != EOF);
  lineno++;
}



void read_line(FILE *fp, char *line)
{
  int state, i;
  int c;

  state = START;
  i = 0;
  while (state != READY)
	switch(state)
	{
		case START:
			skip_spaces(fp);
			if ((c = fgetc(fp)) == COMMENT_CHAR)
				state = COMMENT;
			else if (c == EOF)
			{
				line[0] = '\0';
				state = READY;
			}
			else
				state = READING;
			ungetc(c, fp);
			break;
		case COMMENT:
			skip_rest(fp);
			state = START;
			break;
		case READING:
			while ((c = fgetc(fp)) != '\n' &&
			       c != COMMENT_CHAR && i < LINE_SIZE - 1)
				line[i++] = c;
			if (i == LINE_SIZE - 1 && c != COMMENT_CHAR &&
			    c != '\n')
				exception("line too long.\n");
			ungetc(c, fp);
			while (isspace(line[--i]));
			line[++i] = '\0';
			state = READY;
			break;
	}
}



void read_edges(FILE *fp, int nr)
{
  char *where;
  int n1, n2;

  while (1)
  {
	read_line(fp, line);
	if (line[0] == '\0')
		return;
	if ((where = index(line, ':')) == NULL)
		where = line;
	else
	{
		if (!strcmp(line, "points:")) return;
		where++;
	}
	
	if (sscanf(where, "%d %d", &n1, &n2) != 2)
		exception("two points expected\n");
		
	if (n1 > nr || n2 > nr || n1 <= 0 || n2 <= 0)
		exception("point out of range\n");
	add_line(n1, n2);
  }
}



void read_points(FILE *fp, int *nr)
{
  char *where;
  double f1, f2, f3;

  *nr = 0;
  while (1)
  {
	read_line(fp, line);
	if (line[0] == '\0')
		exception("end of file while reading points\n");
	if ((where = index(line, ':')) == NULL)
		where = line;
	else
	{
		if (!strcmp(line, "edges:"))
			return;
		where ++;
	}
	
	(*nr)++;
	if (sscanf(where, "%lf %lf %lf", &f1, &f2, &f3) != 3)
		exception("three floats expected\n");

	add_point((REAL) f1, (REAL) f2, (REAL) f3);
  }
}







void read_robotfile(FILE *robot)
{
  int c, nr;

  if ((c = fgetc(robot)) == EOF) exception("File is empty.\n");
  ungetc(c, robot);
  read_line(robot, line);
  if (strcmp(line, "points:")) exception("\"points:\" expected\n");
  while (1)
  {
	if ((c = fgetc(robot)) == EOF) break;
	ungetc(c, robot);
	add_link();
	read_points(robot, &nr);
	if (strcmp(line, "edges:")) exception("\"edges:\" expected\n");
	read_edges(robot, nr);
  }
  convert();
}
