/******************************************************************************\
********************************************************************************
********                                                                ********
******      Visual robot simulator                                        ******
****                                                                        ****
**          Author: Craig Dillon, Andrew Conway                               **
**                                                                            **
**          SCHEMATIC.C                                                       **
****                                                                        ****
******                                                                    ******
********                                                                ********
********************************************************************************
\******************************************************************************/

#include<stdio.h>
#ifdef R_SGI
#include<gl/gl.h>
#include<gl/device.h>
#endif
#include<math.h>
#include<string.h>
#include<stdlib.h>
#include<malloc.h>
#include"windowlib.h"
#include"schematic.h"
#include"rob.h"

long schematic_x,schematic_y;		/* start x,y for screen */
long schematic_step;
#define SCHEMATIC_STEP	32

ENTITY *entity[MAX_ENTITIES];
int numentities;

#define ENTITY_COLOUR	0x00000000
#define DIAG_TRANSFORMATION	0

void do_schematic_menu(val)
long val;
{
    switch(val) {
        case SCHEMATIC_SAVE:
			save_schematic();
            break;

		case SCHEMATIC_PRINT:
			print_schematic();
			break;

        default:
            break;
    }
}

void make_schematic_menu()
{
    char men_string[256];

    sprintf(men_string,"Save Schematic|Print Schematic");
#ifdef R_SGI
    schematic_menu=defpup(men_string);
#endif
}

void draw_inputnode(eptr)
ENTITY *eptr;
{
#if(0)
	iptr=(INPUTNODE *)(eptr->entity);
	cpack(ENTITY_COLOUR);
	arci(eptr->x,eptr->y,iptr->radius,900,2700);
	arci(eptr->x+iptr->length,eptr->y,iptr->radius,2700,900);
	v[0]=eptr->x;
	v[1]=eptr->y+iptr->radius;
	bgnline();
	v2i(v);
	v[0]+=iptr->length;
	v2i(v);
	endline();
	v[1]-=2*iptr->radius;
	bgnline();
	v2i(v);
	v[0]-=iptr->length;
	v2i(v);
	cmov2i(eptr->x,eptr->y-3);
	charstr(eptr->name);
#else
#ifdef R_SGI
    lrectwrite(-schematic_x+eptr->x,-schematic_y+eptr->y,-schematic_x+eptr->x+eptr->width-1,-schematic_y+eptr->y+eptr->height-1,eptr->a);
    cpack(ENTITY_COLOUR);
    cmov2i(eptr->x+10,eptr->y+7);
    charstr(eptr->name);
#endif
#endif
}

void draw_outputnode(eptr)
ENTITY *eptr;
{
#if(0)
    optr=(OUTPUTNODE *)(eptr->entity);
    cpack(ENTITY_COLOUR);
	arci(eptr->x,eptr->y,optr->radius,900,2700);
    arci(eptr->x+optr->length,eptr->y,optr->radius,2700,900);
    v[0]=eptr->x;
    v[1]=eptr->y+optr->radius;
    bgnline();
    v2i(v);
    v[0]+=optr->length;
    v2i(v);
    endline();
    v[1]-=2*optr->radius;
    bgnline();
    v2i(v);
    v[0]-=optr->length;
    v2i(v);
    cmov2i(eptr->x,eptr->y-3);
    charstr(eptr->name);
#else
#ifdef R_SGI
    lrectwrite(-schematic_x+eptr->x,-schematic_y+eptr->y,-schematic_x+eptr->x+eptr->width-1,-schematic_y+eptr->y+eptr->height-1,eptr->a);
    cpack(ENTITY_COLOUR);
    cmov2i(eptr->x+10,eptr->y+7);
    charstr(eptr->name);
#endif
#endif
}

void draw_transformation(eptr)
ENTITY *eptr;
{
    TRANSFORMATION *tptr;
	long v[2];

#if(0)
    tptr=(TRANSFORMATION *)(eptr->entity);
    cpack(ENTITY_COLOUR);
    recti(eptr->x,eptr->y,eptr->x+tptr->width,eptr->y+tptr->height);
	v[0]=eptr->x+tptr->lx;
	v[1]=eptr->y+tptr->ly;
	bgnline();
	v2i(v);
	v[0]+=tptr->ll;
	v2i(v);
	endline();
	cmov2i(eptr->x+tptr->tx,eptr->y+tptr->ty);
	charstr(tptr->top);
	cmov2i(eptr->x+tptr->bx,eptr->y+tptr->by);
	charstr(tptr->bot);
#else
#ifdef R_SGI
	tptr=(TRANSFORMATION *)(eptr->entity);
    lrectwrite(-schematic_x+eptr->x,-schematic_y+eptr->y,-schematic_x+eptr->x+eptr->width-1,-schematic_y+eptr->y+eptr->height-1,eptr->a);
    cpack(ENTITY_COLOUR);
    v[0]=eptr->x+tptr->lx;
    v[1]=eptr->y+tptr->ly;
    bgnline();
    v2i(v);
    v[0]+=tptr->ll;
    v2i(v);
    endline();
    cmov2i(eptr->x+tptr->tx,eptr->y+tptr->ty);
    charstr(tptr->top);
    cmov2i(eptr->x+tptr->bx,eptr->y+tptr->by);
    charstr(tptr->bot);
#endif
#endif
}

void draw_summation(eptr)
ENTITY *eptr;
{
#if(0)
    sptr=(SUMMATION *)(eptr->entity);
    cpack(ENTITY_COLOUR);
    circi(eptr->x,eptr->y,sptr->radius);
#else
#ifdef R_SGI
    lrectwrite(-schematic_x+eptr->x,-schematic_y+eptr->y,-schematic_x+eptr->x+eptr->width-1,-schematic_y+eptr->y+eptr->width-1,eptr->a);
    cpack(ENTITY_COLOUR);
    cmov2i(eptr->x+5,eptr->y+5);
    charstr("+");
#endif
#endif
}

void draw_difference(eptr)
ENTITY *eptr;
{
#if(0)
    dptr=(DIFFERENCE *)(eptr->entity);
    cpack(ENTITY_COLOUR);
    circi(eptr->x,eptr->y,dptr->radius);
#else
#ifdef R_SGI
    lrectwrite(-schematic_x+eptr->x,-schematic_y+eptr->y,-schematic_x+eptr->x+eptr->width-1,-schematic_y+eptr->y+eptr->width-1,eptr->a);
    cpack(ENTITY_COLOUR);
    cmov2i(eptr->x+5,eptr->y+5);
    charstr("-");
#endif
#endif
}

void draw_bias(eptr)
ENTITY *eptr;
{
    BIAS *bptr;

#ifdef R_SGI
    bptr=(BIAS *)(eptr->entity);
    lrectwrite(-schematic_x+eptr->x,-schematic_y+eptr->y,-schematic_x+eptr->x+eptr->width-1,-schematic_y+eptr->y+eptr->height-1,eptr->a);
    cpack(ENTITY_COLOUR);
    cmov2i(eptr->x+10,eptr->y+7);
    charstr(bptr->str);
#endif
}

#define PORT_LENGTH 10
#define PORT_ARROW 5

int schematic_blocked(ax,ay,bx,by) /* check blockage from a to b */
int ax,ay,bx,by;
{
	int i;
	ENTITY *eptr;
	int temp,lx,sx,ly,sy;

	for(i=0;i<numentities;i++) {
		eptr=entity[i];
		lx=eptr->x+eptr->dx[POS_RIGHT];
		sx=eptr->x+eptr->dx[POS_LEFT];
		ly=eptr->y+eptr->dy[POS_UP];
		sy=eptr->y+eptr->dy[POS_DOWN];
		if(ax==bx) {
			if(ay<by) {
				temp=ay;
				ay=by;
				by=temp;
			}
			if((sx<=ax)&&(ax<=lx)&&
			   (((by<=sy)&&(sy<=ay))||((by<=ly)&&(ly<=ay)))) return(1);
		} else {
			if(ax<bx) {
				temp=ax;
				ax=bx;
				bx=temp;
			}
			if((sy<=ay)&&(ay<=ly)&&
			   (((bx<=sx)&&(sx<=ax))||((bx<=lx)&&(lx<=ax)))) return(1);
		}
	}
	return(0);
}

void draw_connections()	/* draws schematic connections */
{
	int i,j,sp,dp;
	ENTITY *septr,*deptr;
	long v[2];
	int ex,ey,sx,sy,mx,my,sd,dd;
	static int dx[]={0,1,0,-1};
	static int dy[]={1,0,-1,0};

#ifdef R_SGI
	for(i=0;i<numentities;i++) {
		septr=entity[i];
		for(j=0;j<septr->numports;j++) {
			if(septr->mode[j]==PORT_INPUT) {
				sp=j;
				deptr=entity[septr->c_entity[j]];
				dp=septr->c_port[j];
				sd=septr->position[sp];
				dd=deptr->position[dp];
	
	
				/* draw arrow head */
				sx=septr->x+septr->dx[sd];
				sy=septr->y+septr->dy[sd];
				v[0]=sx;
				v[1]=sy;
				bgnline();
				v2i(v);
				v[0]+=dx[sd]*PORT_ARROW;
				v[1]+=dy[sd]*PORT_ARROW;
				v[0]+=dx[(sd+5)%4]*PORT_ARROW;
				v[1]+=dy[(sd+5)%4]*PORT_ARROW;
				v2i(v);
				endline();
				
				v[0]=sx;
                v[1]=sy;
                bgnline();
                v2i(v);
                v[0]+=dx[sd]*PORT_ARROW;
                v[1]+=dy[sd]*PORT_ARROW;
                v[0]+=dx[(sd+3)%4]*PORT_ARROW;
                v[1]+=dy[(sd+3)%4]*PORT_ARROW;
                v2i(v);
                endline();

				/* draw from septr,sp to deptr,dp */
				sx=septr->x+septr->dx[sd];
                sy=septr->y+septr->dy[sd];
				ex=deptr->x+deptr->dx[dd];
				ey=deptr->y+deptr->dy[dd];

				v[0]=sx;
				v[1]=sy;
				bgnline();
				v2i(v);
				sx+=dx[sd]*PORT_LENGTH;	
				sy+=dy[sd]*PORT_LENGTH;
				v[0]=sx;
                v[1]=sy;
				v2i(v);
				endline();

				v[0]=ex;
                v[1]=ey;
                bgnline();
                v2i(v);
                ex+=dx[dd]*PORT_LENGTH;     
                ey+=dy[dd]*PORT_LENGTH;
                v[0]=ex;
                v[1]=ey;
                v2i(v);
                endline();
				
				mx=sx;
				my=ey;		/* swap these to go other way */
				if(schematic_blocked(sx,sy,mx,my)||
				   schematic_blocked(mx,my,ex,ey)) {
					mx=ex;
					my=sy;
				}
				v[0]=sx;
				v[1]=sy;
				bgnline();
				v2i(v);
				v[0]=mx;
				v[1]=my;
				v2i(v);
				v[0]=ex;
				v[1]=ey;
				v2i(v);
				endline();
			}
		}
	}
#endif
}

void redraw_schematic()
{
    long ow;
	int i;
	long xs,ys;
	ENTITY *eptr;
	char s[80];

#ifdef R_SGI
    ow=winget();
    winset(wid_schematic);

	if(!getbutton(LEFTMOUSE)) {
		sprintf(s,"Schematic: (%ld,%ld) Jump:%ld",schematic_x,schematic_y,schematic_step);
		wintitle(s);
	}
	getsize(&xs,&ys);
	ortho2((float)schematic_x-0.5,(float)(xs+schematic_x)+0.5,(float)schematic_y-0.5,(float)(ys+schematic_y)+0.5);	
	reshapeviewport();
    cpack(0x00804040);
    clear();

	for(i=0;i<numentities;i++) {
		eptr=entity[i];
		switch(eptr->type) {
			case ENTITY_INPUTNODE:
				draw_inputnode(eptr);
				break;

			case ENTITY_OUTPUTNODE:
				draw_outputnode(eptr);
				break;

			case ENTITY_TRANSFORMATION:
				draw_transformation(eptr);
				break;

			case ENTITY_SUMMATION:
				draw_summation(eptr);
				break;

			case ENTITY_DIFFERENCE:
				draw_difference(eptr);
				break;

			case ENTITY_BIAS:
				draw_bias(eptr);
				break;

			default:
				printf("Unknown entity type: %d\n",eptr->type);
				exit(0);
		}
	}
	draw_connections();
	swapbuffers();
    winset(ow);
#endif
}

void schematic_up()
{
	schematic_y+=schematic_step;
	redraw_schematic();
}

void schematic_down()
{
    schematic_y-=schematic_step;
    redraw_schematic();
}

void schematic_right()
{
    schematic_x+=schematic_step;
    redraw_schematic();
}

void schematic_left()
{
    schematic_x-=schematic_step;
    redraw_schematic();
}

void schematic_home()
{
	schematic_x=0;
	schematic_y=0;
	redraw_schematic();
}

void schematic_jump()
{
	if(schematic_step==SCHEMATIC_STEP) {
		schematic_step=8*SCHEMATIC_STEP;
	} else {
		schematic_step=SCHEMATIC_STEP;
	}
	redraw_schematic();
}

void create_schematic()
{
	schematic_x=0;
	schematic_y=0;
	schematic_step=SCHEMATIC_STEP;

#ifdef R_SGI
	prefposition(10,400,10,450);
	wid_schematic=winopen("schematic");
    RGBmode();
    doublebuffer();
    concave(FALSE);
    gconfig();
    zbuffer(FALSE);
	winconstraints();
	make_schematic_menu();
	redraw_schematic();
#endif
}

void process_schematic(event,val)
int event;
short val;
{
	long x,y;
	long mx,my,sx,sy,dx,dy;
	int i,num;
	ENTITY *eptr;

#ifdef R_SGI
	switch(event) {
	    case LEFTMOUSE:
			if(!getbutton(LEFTMOUSE)) break;
        	getorigin(&x,&y);
			mx=getvaluator(MOUSEX);
			my=getvaluator(MOUSEY);
			sx=schematic_x+mx-x;
			sy=schematic_y+my-y;
			num= -1;
			for(i=0;i<numentities;i++) {
				eptr=entity[i];
				if( (eptr->x<sx)&&(sx<eptr->x+eptr->width)&&
				    (eptr->y<sy)&&(sy<eptr->y+eptr->height) ) {
					num=i;
				}
			}
			if(num!= -1) {	/* an entity */
				eptr=entity[num];
				dx=sx-eptr->x;
				dy=sy-eptr->y;
				while(getbutton(LEFTMOUSE)) {
					mx=getvaluator(MOUSEX);
		            my=getvaluator(MOUSEY);
   		         	sx=schematic_x+mx-x-dx;
   		         	sy=schematic_y+my-y-dy;		
					eptr->x=sx;
					eptr->y=sy;
					redraw_schematic();
				}
			} else {	/* move screen around */
				while(getbutton(LEFTMOUSE)) {
					mx=getvaluator(MOUSEX);
                    my=getvaluator(MOUSEY);
					schematic_x=sx+x-mx;
					schematic_y=sy+y-my;
					redraw_schematic();
				}
				redraw_schematic();
			}
			break;

		default:
			break;
	}
#endif
}

void update_inputnode(eptr)
ENTITY *eptr;
{
	INPUTNODE *iptr;
	double nv;

	iptr=(INPUTNODE *)(eptr->entity);
	eptr->output=(*(iptr->value));
	if(iptr->noise==NOISE_ON) {
		nv=1.0-(double)(random()%65536)/32768.0;
		nv*=(iptr->noise_scale);
		eptr->output+=nv;
	}
}

void update_outputnode(eptr)
ENTITY *eptr;
{
	double v;

	v=entity[eptr->c_entity[OUTPUTNODE_IN]]->output;
	*(((OUTPUTNODE *)(eptr->entity))->value)=v;
}

void update_transformation(eptr)
ENTITY *eptr;
{
	TRANSFORMATION *tptr;
	POLYNOMIAL *ptr;
	double val,g0;
	int i;

	tptr=(TRANSFORMATION *)(eptr->entity);
	
	/* move storage values down */

	for(i=(tptr->lha-1);i>=1;i--) tptr->ha[i]=tptr->ha[i-1];
	for(i=(tptr->lhb-1);i>=1;i--) tptr->hb[i]=tptr->hb[i-1];
	
	/* update input (ie. b[0]) */

	tptr->hb[0]=entity[eptr->c_entity[TRANSFORMATION_IN]]->output;

	/* compute new output value */
	val=0.0;
	g0=0.0;
	ptr=tptr->ptop;
	for(i=0;i<ptr->numterms;i++) {
		val+=tptr->hb[ptr->zpower[i]]*ptr->coefficient[i];
#if(DIAG_TRANSFORMATION)
		printf("B: %d %lf ",ptr->zpower[i],ptr->coefficient[i]);
#endif
	}	
	ptr=tptr->pbot;
	for(i=0;i<ptr->numterms;i++) {
		if(ptr->zpower[i]==0) {
			g0=ptr->coefficient[i];
		} else {
			val-=tptr->ha[ptr->zpower[i]]*ptr->coefficient[i];
#if(DIAG_TRANSFORMATION)
			printf("T: %d %lf ",ptr->zpower[i],ptr->coefficient[i]);
#endif
		}
	}
#if(DIAG_TRANSFORMATION)
	printf("g0: %lf",g0);
#endif
	if(g0==0.0) {
		printf("Trying to predict the future error...\n");
		exit(0);
	}
	eptr->output=val/g0;
#if(DIAG_TRANSFORMATION)
	printf("val: %lf\n",eptr->output);
#endif
	tptr->ha[0]=eptr->output;
}

void update_summation(eptr)
ENTITY *eptr;
{
	eptr->output=entity[eptr->c_entity[SUMMATION_INA]]->output+
				 entity[eptr->c_entity[SUMMATION_INB]]->output;
}

void update_difference(eptr)
ENTITY *eptr;
{
    eptr->output=entity[eptr->c_entity[DIFFERENCE_INA]]->output-
                 entity[eptr->c_entity[DIFFERENCE_INB]]->output;
}

void update_bias(eptr)
ENTITY *eptr;
{	
	/* nothing to do as output value is preset */
}

void update_schematic()	/* updates outputs in each entity */
{
	int i;
	ENTITY *eptr;

	for(i=0;i<numentities;i++) {
		eptr=entity[i];
		switch(eptr->type) {
			case ENTITY_INPUTNODE:
				update_inputnode(eptr);
				break;
				
			case ENTITY_OUTPUTNODE:
                update_outputnode(eptr);
                break;
	
			case ENTITY_TRANSFORMATION:
                update_transformation(eptr);
                break;

			case ENTITY_SUMMATION:
                update_summation(eptr);
                break;

			case ENTITY_DIFFERENCE:
                update_difference(eptr);
                break;

			case ENTITY_BIAS:
				update_bias(eptr);
				break;

			default:
				printf("Unknown entity type\n");
				break;
		}
	}
}

void reset_schematic()	/* this resets schematic transformation delays to 0 */
{
	int i,j;
	ENTITY *eptr;
	TRANSFORMATION *tptr;

	for(i=0;i<numentities;i++) {
		eptr=entity[i];
		if(eptr->type==ENTITY_TRANSFORMATION) {
			tptr=(TRANSFORMATION *)(eptr->entity);
			for(j=0;j<tptr->lha;j++) tptr->ha[j]=0.0;
            for(j=0;j<tptr->lhb;j++) tptr->hb[j]=0.0;
		}
	}
}
