/******************************************************************************\
********************************************************************************
********                                                                ********
******      Visual robot simulator                                        ******
****                                                                        ****
**          Author: Craig Dillon, Andrew Conway                               **
**                                                                            **
**          RUN.C                                                             **
****                                                                        ****
******                                                                    ******
********                                                                ********
********************************************************************************
\******************************************************************************/

#include<stdio.h>
#include<math.h>
#include<malloc.h>
#include<sys/types.h>
#include<stdlib.h>
#include<string.h>
#ifdef R_SGI
#include<gl/gl.h>
#endif
#include"rob.h"

void init_joints()		/* set joint to from_joint */
{
	int i;
	
	for(i=0;i<numjoints;i++) {
		memcpy(joint[i],from_joint[i],sizeof(JOINT));
	}
}

void vdd_to_vd(jptr,pjptr)
JOINT *jptr,*pjptr;
{
	jptr->ad+=time_step*jptr->add;
	jptr->dd+=time_step*jptr->ddd;
	jptr->alphad+=time_step*jptr->alphadd;
	jptr->thetad+=time_step*jptr->thetadd;
}

void vd_to_vdd(jptr,pjptr)
JOINT *jptr,*pjptr;
{
	jptr->add=(jptr->ad-pjptr->ad)/time_step;
	jptr->ddd=(jptr->dd-pjptr->dd)/time_step;
	jptr->alphadd=(jptr->alphad-pjptr->alphad)/time_step;
	jptr->thetadd=(jptr->thetad-pjptr->thetad)/time_step;
}

void vd_to_v(jptr,pjptr)
JOINT *jptr,*pjptr;
{
    jptr->a+=time_step*jptr->ad;
    jptr->d+=time_step*jptr->dd;
    jptr->alpha+=time_step*jptr->alphad;
    jptr->theta+=time_step*jptr->thetad;
}

void v_to_vd(jptr,pjptr)
JOINT *jptr,*pjptr;
{
    jptr->ad=(jptr->a-pjptr->a)/time_step;
    jptr->dd=(jptr->d-pjptr->d)/time_step;
    jptr->alphad=(jptr->alpha-pjptr->alpha)/time_step;
    jptr->thetad=(jptr->theta-pjptr->theta)/time_step;
}

void next_itteration()
{
	int i;
	JOINT *jptr,*pjptr,*njptr;

	/* stage 1 */

	for(i=0;i<numjoints;i++) {
		memcpy(pjoint[i],joint[i],sizeof(JOINT));
	}

	/* stage 2 */

	if((runmode==RMODE_USER)||(runmode==RMODE_USERSCHEMATIC)) {
		user_function();
	}
	if((runmode==RMODE_SCHEMATIC)||(runmode==RMODE_USERSCHEMATIC)) {
		update_schematic();
	}

	/* stage 3.1 */
		
	for(i=0;i<numjoints;i++) {
		jptr=joint[i];
		pjptr=pjoint[i];
		switch(jptr->sim_mode) {
			case SIM_F:
				break;

			case SIM_VDD:
				break;

			case SIM_VD:
				vd_to_vdd(jptr,pjptr);
				break;

			case SIM_V:
				v_to_vd(jptr,pjptr);
				vd_to_vdd(jptr,pjptr);
				break;

			case SIM_NONE:	/* nothing modified */
				break;

			default:
				printf("Error: unknown sim_mode\n");
				exit(0);
		}
	}
	
	/* stage 3.2 */

	forces_and_accelerations();

	/* stage 3.3 */

    for(i=0;i<numjoints;i++) {
        jptr=joint[i];
        pjptr=pjoint[i];
        switch(jptr->sim_mode) {
            case SIM_F:
                vdd_to_vd(jptr,pjptr);
                vd_to_v(jptr,pjptr);
                break;

            case SIM_VDD:
                vdd_to_vd(jptr,pjptr);
                vd_to_v(jptr,pjptr);
                break;

            case SIM_VD:
                vd_to_v(jptr,pjptr);
                break;

            case SIM_V:
                break;

            case SIM_NONE:  /* nothing modified */
                break;

            default:
                printf("Error: unknown sim_mode\n");
                exit(0);
        }
    }

	/* stage 4 */

	joints_to_links();
	calculate_position();

	/* stage 5 */

	for(i=0;i<(numjoints-1);i++) {
		jptr=joint[i];
		njptr=joint[i+1];
		jptr->dx=njptr->x-jptr->x;
		jptr->dy=njptr->y-jptr->y;
		jptr->dz=njptr->z-jptr->z;
	}
	jptr=joint[numjoints-1];		/* last joint */
	jptr->dx=0.0;
	jptr->dy=0.0;
	jptr->dz=0.0;

	/* stage 6 */

	for(i=0;i<numjoints;i++) {
		jptr=joint[i];
		pjptr=pjoint[i];
		
		jptr->xd=(jptr->x-pjptr->x)/time_step;
		jptr->yd=(jptr->y-pjptr->y)/time_step;
		jptr->zd=(jptr->z-pjptr->z)/time_step;

		jptr->dxd=(jptr->dx-pjptr->dx)/time_step;
		jptr->dyd=(jptr->dy-pjptr->dy)/time_step;
		jptr->dzd=(jptr->dz-pjptr->dz)/time_step;
	}
}
