/* demonstrates planning principle */

#include<stdio.h>
#include<math.h>
#include<malloc.h>
#include<sys/types.h>
#include<gl.h>

#define SIZE 256

char *omap;
float *adist,*pdist;
long *dis;
int rsx,rsy,rex,rey;
float arm;

void load_data(fn)
char *fn;
{
	FILE *in;
	int i,j,sx,sy,ex,ey;

	in=fopen(fn,"r");
	if(!in) {
		printf("File could not be opened\n");
		exit(0);
	}
	for(i=0;i<SIZE;i++) for(j=0;j<SIZE;j++) omap[i+SIZE*j]=1;
	for(i=1;i<(SIZE-1);i++) for(j=1;j<(SIZE-1);j++) omap[i+j*SIZE]=0;
	fscanf(in," %f",&arm);
	fscanf(in," %d %d %d %d",&rsx,&rsy,&rex,&rey);
	while(!feof(in)) {
		fscanf(in," %d %d %d %d",&sx,&sy,&ex,&ey);
		for(i=sx;i<=ex;i++) {
			for(j=sy;j<=ey;j++) {
				omap[i+SIZE*j]=1;
			}
		}
	}
	fclose(in);
}
	
void draw_float(fptr)
float *fptr;
{
	int i,j;

	for(i=0;i<SIZE;i++) {
		for(j=0;j<SIZE;j++) {
			if(omap[i+SIZE*j]==1) {
				dis[i+SIZE*j]=1;
			} else {
				if(fptr[i+SIZE*j]>1000.0) {
					dis[i+SIZE*j]=2;
				} else {
					dis[i+SIZE*j]=((long)(fptr[i+SIZE*j]))%128+128;
				}
			}
		}
	}
	dis[rsx+SIZE*rsy]=3;
	dis[rex+SIZE*rey]=4;
	lrectwrite(0,0,SIZE-1,SIZE-1,dis);
}

void draw_path()
/* The path is never actually recorded, but if you follow back from the end  */
/* always moving to the smallest distance, you will get (one of) the path(s) */
{
	int x,y,ii,jj,si,sj;
	int done;
	float smallest;

	x=rex;
	y=rey;
	dis[x+SIZE*y]=5;
	while((x!=rsx)||(y!=rsy)) {
		smallest=1000.0;
		for(ii= -1;ii<=1;ii++) {
			for(jj= -1;jj<=1;jj++) {
				if(pdist[x+ii+SIZE*(y+jj)]<smallest) {
					si=ii;		
					sj=jj;
					smallest=pdist[x+ii+SIZE*(y+jj)];
				}
			}
		}
		x+=si;
		y+=sj;
		dis[x+SIZE*y]=5;
	}
	lrectwrite(0,0,SIZE-1,SIZE-1,dis);
}

void arm_dist_pp(i,j,done)
int i,j,*done;
{
    int x,y,ii,jj,ndiff;
    float smallest,ddist;

    if(omap[i+SIZE*j]==0) {
	    smallest=100000.0;
    	for(ii= -1;ii<=1;ii++) {
    		for(jj= -1;jj<=1;jj++) {
    			if((ii==0)&&(jj==0)) continue;
    			x=i+ii;
    			y=j+jj;
    			ndiff=0;
    			if(ii!=0) ndiff++;
    			if(jj!=0) ndiff++;
    			if(ndiff==0) ddist=0.0;
    			if(ndiff==1) ddist=1.0;
    			if(ndiff==2) ddist=1.41;
    			ddist+=adist[x+SIZE*y];
    			if(ddist<smallest) {
    				smallest=ddist;
    			}
    		}
    	}
    	if(adist[i+SIZE*j]>smallest) {
    		adist[i+SIZE*j]=smallest;
    		*done=0;
		}
    }
}

void arm_dist()
{
	int done,pass;
	int i,j,x,y,ii,jj,ndiff;
	float smallest,ddist;

	done=0;
	pass=0;
	for(i=0;i<SIZE*SIZE;i++) adist[i]=100000.0;
	adist[1+SIZE]=0.0;
	while(!done) {
		done=1;
		for(i=1;i<(SIZE-1);i++) {
			for(j=1;j<(SIZE-1);j++) {
				arm_dist_pp(i,j,&done);
			}
		}
		draw_float(adist);
        for(i=SIZE-1;i>0;i--) {
            for(j=SIZE-1;j>0;j--) {
				arm_dist_pp(i,j,&done);
            }
        }
		printf("Pass: %d\n",pass);
		pass++;
		draw_float(adist);
	}
}

void path_dist_pp(i,j,done)
int i,j,*done;
{
    int x,y,ii,jj,ndiff;
    float smallest,ddist;

    if((omap[i+SIZE*j]==0)||(adist[i+SIZE*j]>arm)) {
        smallest=100000.0;
        for(ii= -1;ii<=1;ii++) {
            for(jj= -1;jj<=1;jj++) {
                if((ii==0)&&(jj==0)) continue;
                x=i+ii;
                y=j+jj;
				if(adist[x+SIZE*y]>arm) continue;	/* reject possibility */
                ndiff=0;
                if(ii!=0) ndiff++;
                if(jj!=0) ndiff++;
                if(ndiff==0) ddist=0.0;
                if(ndiff==1) ddist=1.0;
                if(ndiff==2) ddist=1.41;
                ddist+=pdist[x+SIZE*y];
                if(ddist<smallest) {
                    smallest=ddist;
                }
            }
        }
        if(pdist[i+SIZE*j]>smallest) {
            pdist[i+SIZE*j]=smallest;
            *done=0;
        }
    }
}

void path_dist()
{
    int done,pass;
    int i,j,x,y,ii,jj,ndiff;
    float smallest,ddist;

    done=0;
    pass=0;
    for(i=0;i<SIZE*SIZE;i++) pdist[i]=100000.0;
    pdist[rsx+SIZE*rsy]=0.0;
    while(!done) {
        done=1;
        for(i=1;i<(SIZE-1);i++) {
            for(j=1;j<(SIZE-1);j++) {
                path_dist_pp(i,j,&done);
            }
        }
        draw_float(pdist);
        for(i=SIZE-1;i>0;i--) {
            for(j=SIZE-1;j>0;j--) {
                path_dist_pp(i,j,&done);
            }
        }
        printf("Pass: %d\n",pass);
        pass++;
        draw_float(pdist);
    }
}

void main()
{
	int i;

	/*
	if(dglopen("shredder.vis.citri.edu.au",DGLTSOCKET)<0) {
		printf("Cannot open shredder\n");
		exit(0);
	}
	*/
	prefsize(SIZE,SIZE);
	winopen("planner");
	multimap();
	gconfig();
	setmap(1);
	for(i=128;i<256;i++) {
		mapcolor(i,(i-128)*2,(i-128)*2,(i-128)*2);
	}
	mapcolor(0,0,0,0);
	mapcolor(1,255,0,0);
	mapcolor(2,0,255,0);
	mapcolor(3,0,255,255);
	mapcolor(4,0,0,255);
	mapcolor(5,255,0,255);
	color(0);
	clear();
	omap=(char *)calloc(SIZE*SIZE,sizeof(char));
	adist=(float *)calloc(SIZE*SIZE,sizeof(float));
	pdist=(float *)calloc(SIZE*SIZE,sizeof(float));
	dis=(long *)calloc(SIZE*SIZE,sizeof(long));
	load_data("data");
	if(omap[rsx+SIZE*rsy]==1) {
		printf("Robot cannot be started from within an object\n");
		exit(0);
	}
	if(omap[rex+SIZE*rey]==1) {
		printf("Robot cannot end within an object\n");
		exit(0);
	}
	arm_dist();
	if(adist[rsx+SIZE*rsy]>1000.0) {
		printf("Robot start position is blocked from robot origin\n");
		exit(0);
	}
	if(adist[rex+SIZE*rey]>1000.0) {
		printf("Robot end position is blocked from robot origin\n");
		exit(0);
	}
	if(adist[rsx+SIZE*rsy]>arm) {
		printf("Robot start position is longer than arm length: %f\n",adist[rex+SIZE*rey]);
		exit(0);
	}
	if(adist[rex+SIZE*rey]>arm) {
		printf("Robot end position is longer than arm length :%f\n",adist[rex+SIZE*rey]);
		exit(0);
	}
	printf("Calculated extension distances\n");
	path_dist();
	printf("Results:\n");
	printf("Extension at start: %f\n",adist[rsx+SIZE*rsy]);
	printf("Extension at end: %f\n",adist[rex+SIZE*rey]);
	printf("Path length: %f\n",pdist[rex+SIZE*rey]);
	draw_path();
	while(1);
}
