/*
 *  Window setup functions for Motif version
 *
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <stdarg.h>

#include "X11/Xlib.h"
#include "X11/Xutil.h"
#include "X11/Xos.h"
#include "X11/Intrinsic.h"
#include "X11/IntrinsicP.h"
#include "X11/CoreP.h"
#include "X11/Shell.h"
#include <Xm/Xm.h>
#include <Xm/MainW.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/DrawingA.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/BulletinB.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/SelectioB.h>

#include "display.h"
#include "structures.h"
#include "constants.h"
#include "parameters.h"


/* Create the main application window */

XtAppContext app_context;
Widget toplevel;		/* toplevel shell widget */
Widget main_window;		/* main window widget */
Widget menu_bar;
Widget frame;			/* main drawing window */
Widget messages;		/* message/info window */
Widget connect_box;		/* connect prompt dialog widget */
Widget connect_button;		/* connect button */
Widget step_button;		/* stepping button */
Widget sonar_button;		/* sonar button */
Widget file_box;		/* file selection widget */

void ExitCB();
void ConnectCB();
void ShutdownCB();
void ColorCB();
void WakeCB();
void StepCB();
void GrowCB();
void ParamsCB();
void ClearCB();
void ActiveCB();
void cancel_proc();
void connect_proc();
void process_events();
void resize_proc();
void key_proc();
void mouse_proc();
void file_proc();

float plus = 1.1, minus = 0.9;

Window
create_app(int width,int height,int argc,char **argv)
{ 
  Arg args[10];
  int n;
  Widget button, menu_pane, cascade;
  

  /* create toplevel app */
  toplevel =			
    XtAppInitialize(&app_context,"Flakey", NULL, 0, &argc, argv, NULL, NULL, 0);

  display = XtDisplay(toplevel);

  /* Main window  */
  n = 0;
  main_window = XmCreateMainWindow(toplevel,"Flakey",args,n); 
  XtManageChild(main_window);

  /* Create message/info window */
  n = 0;
  XtSetArg(args[n], XmNlabelString, 
	   XmStringCreateLtoR(" \n   Status:              X pos:          Motor Pacs:\nTranslate:              Y pos:          Sonar Pacs:\n   Rotate:              Theta:          Idle Time:",XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetArg(args[n], XmNalignment, XmALIGNMENT_BEGINNING); n++;
  messages = XmCreateLabel(main_window, "Hey there", args, n);
  XtManageChild(messages);


  /* Create menu bar in main window */
  n = 0;
  menu_bar = XmCreateMenuBar(main_window, "menu_bar", args, n);
  XtManageChild(menu_bar);


  /* Create Connect push button in main window */
  n = 0;
  connect_button = XmCreateCascadeButton(menu_bar, "Connect", args, n);
  XtManageChild(connect_button);
  XtAddCallback(connect_button, XmNactivateCallback, ConnectCB, NULL);

  n = 0;
  XtSetArg(args[n], XmNmenuHelpWidget, connect_button); n++;
  XtSetValues(menu_bar, args, n);


  /* This is the connect dialog widget */
  n = 0;
  connect_box = XmCreatePromptDialog(connect_button, "Connect", args, n);
  XtAddCallback(connect_box, XmNcancelCallback, cancel_proc, NULL);
  XtAddCallback(connect_box, XmNokCallback, connect_proc, NULL);

  /* Create QUIT menu in main window */
  n = 0;
  menu_pane = XmCreatePulldownMenu(menu_bar, "menu_pane", args, n);

  n = 0;
  button = XmCreatePushButtonGadget(menu_pane, "Exit", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, ExitCB, NULL);

  n = 0;
  XtSetArg(args[n], XmNsubMenuId, menu_pane); n++;
  cascade = XmCreateCascadeButtonGadget(menu_bar, "Quit", args, n);
  XtManageChild(cascade);

  /* Create PARAMS push button in main window */
  n = 0;
  button = XmCreateCascadeButton(menu_bar, "Params", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, ParamsCB, NULL);

  /* This is the file selection widget */
  n = 0;
  file_box = XmCreateFileSelectionDialog(button, "Select", args, n);
  XtAddCallback(file_box, XmNcancelCallback, cancel_proc, NULL);
  XtAddCallback(file_box, XmNokCallback, file_proc, NULL);


  /* Create ENLARGE push button in main window */
  n = 0;
  button = XmCreateCascadeButtonGadget(menu_bar, "Grow", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, GrowCB, &plus);

  /* Create SHRINK push button in main window */
  n = 0;
  button = XmCreateCascadeButtonGadget(menu_bar, "Shrink", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, GrowCB, &minus);


  /* Create Change Color push button in main window */
  n = 0;
  button = XmCreateCascadeButtonGadget(menu_bar, "Color", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, ColorCB, NULL);

  /* Create Wake push button in main window */
  n = 0;
  button = XmCreateCascadeButtonGadget(menu_bar, "Wake", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, WakeCB, NULL);

  /* Create Step push button in main window */
  n = 0;
  step_button = XmCreateCascadeButtonGadget(menu_bar, "Do Step", args, n);
  XtManageChild(step_button);
  XtAddCallback(step_button, XmNactivateCallback, StepCB, NULL);

  /* Create SONARS menu in main window */
  n = 0;
  menu_pane = XmCreatePulldownMenu(menu_bar, "menu_pane", args, n);

  n = 0;
  button = XmCreatePushButtonGadget(menu_pane, "Clear buffer", args, n);
  XtManageChild(button);
  XtAddCallback(button, XmNactivateCallback, ClearCB, NULL);

  n = 0;
  sonar_button = XmCreatePushButtonGadget(menu_pane, "Sonars on", args, n);
  XtManageChild(sonar_button);
  XtAddCallback(sonar_button, XmNactivateCallback, ActiveCB, NULL);

  n = 0;
  XtSetArg(args[n], XmNsubMenuId, menu_pane); n++;
  cascade = XmCreateCascadeButtonGadget(menu_bar, "Sonars", args, n);
  XtManageChild(cascade);




  XtManageChild(menu_bar);

  /* Create frame for graphics display */
  n = 0;
  frame = XmCreateDrawingArea(main_window, "drawing", args, n);
  XtManageChild(frame);

/*   XtAddCallback(frame, XmNexposeCallback, expose_proc, NULL); */
  XtAddCallback(frame, XmNresizeCallback, resize_proc, NULL);
  XtAddCallback(frame, XmNinputCallback,  key_proc,  NULL);

  /* Set main window areas and size */
  XmMainWindowSetAreas(main_window, menu_bar, NULL, NULL, NULL, frame);

  n = 0;
  XtSetArg(args[n], XmNmessageWindow, messages); n++;
  XtSetArg(args[n], XmNshowSeparator, True); n++;
  XtSetValues(main_window, args, n);

  n = 0;
  XtSetArg(args[n], XmNheight, height); n++;
  XtSetArg(args[n], XmNwidth, width); n++;
  XtSetValues(toplevel, args, n);

  n = 0;
  XtSetArg(args[n], XmNheight, INFO_HEIGHT); n++;
  XtSetValues(messages, args, n);

  XtRealizeWidget(toplevel);

  n = 0;
  XtSetArg(args[n], XmNheight, INFO_HEIGHT); n++;
  XtSetValues(messages, args, n);

  process_events();

  info_win = XtWindow(messages); /* information window */
  win      = XtWindow(frame);	/* graphics window */

  return(XtWindow(frame));

}


/* 
 * Process pending Xt events
 * 
 */
void
process_events()
{
  XEvent event;
  while (XtAppPending(app_context)) /* any events? */
    {
      XtAppNextEvent(app_context,&event);
      XtDispatchEvent(&event);
    }
}



extern int win_w, win_h;

void
resize_proc(w, cd, s)		/* resizing happened */
     Widget w;
     caddr_t cd;
     XmDrawingAreaCallbackStruct *s;
{
  resize_window();
}


/*
 * ParamsCB -- callback for PARAMS button
 *
 */
void ParamsCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XtManageChild (file_box);
}

/*
 * Load a parameter file
 */
void
file_proc(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XmString file;
  XmStringContext context;
  XmStringCharSet charset;
  XmStringDirection direction;
  Boolean separator;
  Arg args[1];
  char *text;
  XtSetArg(args[0], XmNtextString, &file);
  XtGetValues(w, args, 1);
  XmStringGetLtoR(file, XmSTRING_DEFAULT_CHARSET, &text);
  load_file(text);
  XtFree(text);
  XtUnmanageChild(w);
/*  XtDestroyWidget(w); */
}


/*
 * Mouse buttons: left is position robot, middle is force recenter, 
 *   right is add/delete object
 */
extern void
add_target(int x, int y);

void
mouse_proc(w, cd, s)		/* exposure happened */
     Widget w;
     caddr_t cd;
     XmDrawingAreaCallbackStruct *s;
{
  XEvent *event;
  int x, y, b;
  event = s->event;
  if (event->type == ButtonPress) /* pressed that button... */
    {
      x = event->xbutton.x;
      y = event->xbutton.y;
      b = event->xbutton.button;
      switch(b)
	{
	case 1:			/* left button, add target point */
	  add_target(x,y);
	  break;
	case 2:			/* middle button, scroll */
	  break;
	}
    }
}



void shutdown_flakey_server();
/*
 * ExitCB -- callback for Exit button
 *
 */
void ExitCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  message("Exiting");
  shutdown_flakey_server();
  exit(0);
}


void change_window_color();
/*
 * Callback for Change Color button
 *
 */
void ColorCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  change_window_color();
}

/*
 * Callback for Grow/Shrink buttons
 *
 */
void GrowCB(w, dir, call_data)
     Widget w;
     float *dir;
     caddr_t call_data;
{
  set_window_scale(w_scale * *dir);
}

/*
 * Callback for Wake button
 *
 */
void WakeCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data;
     caddr_t call_data;
{
  if (draw_wake_flag)		/* shut it off */
    { draw_wake_flag = 0; }
  else
    { init_wake();
      draw_wake_flag = 1;
    }
}


int single_step_mode = 0;
/*
 * Callback for Step button
 *
 */
void StepCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data;
     caddr_t call_data;
{
  int n = 0;
  Arg args[1];
  if (connected) {
  if (single_step_mode)
    { command_to_flakey_i(STEP_COM,STEP_STOP_ARG);
      single_step_mode = 0;
      XtSetArg(args[n], XmNlabelString, 
	       XmStringCreateLtoR("Step",XmSTRING_DEFAULT_CHARSET)); n++;
      XtSetValues(step_button, args, n);
    }
  else
    { command_to_flakey_i(STEP_COM,STEP_START_ARG);
      single_step_mode = 1;
      XtSetArg(args[n], XmNlabelString, 
	       XmStringCreateLtoR("Cont",XmSTRING_DEFAULT_CHARSET)); n++;
      XtSetValues(step_button, args, n);
    }
  }
}



/*
 * ConnectCB -- callback for Connect button
 *
 */
void ConnectCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  int n;
  Arg args[1];

  if (connected)		/* already connected */
    {
      shutdown_flakey_server();
      n = 0;
      XtSetArg(args[n], XmNlabelString, 
	       XmStringCreateLtoR("Connect",XmSTRING_DEFAULT_CHARSET)); n++;
      XtSetValues(w, args, n);
    }
  else				/* start up server */
    {
      XtManageChild (connect_box);
    }
}

void
cancel_proc(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XtUnmanageChild(w);
}

extern char *hostname;

void
connect_proc(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  XmString file;
  XmStringContext context;
  XmStringCharSet charset;
  XmStringDirection direction;
  Boolean separator;
  Arg args[1];
  int n;

  XtUnmanageChild(w);
  XtSetArg(args[0], XmNtextString, &file);
  XtGetValues(w, args, 1);
  XmStringGetLtoR(file, XmSTRING_DEFAULT_CHARSET, &hostname);
}


set_disconnect_state()
{
  int n = 0;
  Arg args[1];
  XtSetArg(args[n], XmNlabelString, 
	   XmStringCreateLtoR("Disconnect",XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(connect_button, args, n);
}



/*
 * Keyboard input:  forward velocity and rotation
 */
void
key_proc(w, cd, s)		/* key event happened */
     Widget w;
     caddr_t cd;
     XmDrawingAreaCallbackStruct *s;
{
  XEvent *event;
  int x, y, b;
  event = s->event;
  if (event->type == KeyPress) /* pressed that button... */
    {
      x = event->xkey.keycode;
/*      printf("\nKey: %d",x); */
      process_key(x);
    }
  if (event->type == ButtonPress) /* pressed that button... */
    {
      x = event->xbutton.x;
      y = event->xbutton.y;
      b = event->xbutton.button;
      switch(b)
	{
	case 1:			/* left button, add target point */
	  add_target(x,y);
	  break;
	case 2:			/* middle button, scroll */
	  break;
	}
    }

}


/*
 * ClearCB -- callback for clear sonar buffer button
 *
 */
void ClearCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  int n;
  Arg args[1];
  empty_sbuf(0,0);
  empty_sbuf(1,0);
}


/*
 * ActiveCB -- activates/deactivates sonars
 *
 */
void ActiveCB(w, client_data, call_data)
     Widget w;
     caddr_t client_data, call_data;
{
  int n;
  Arg args[1];
  message("Sonar toggle");
}
