
/*
Handy routines
--------------
*/


/*  bug_xW():
        Bug's x co-ordinate.
*/
define bug_xW();
    $-eden$-world.bw_bug_xW;
enddefine;


/*  bug_yW():
        Bug's y co-ordinate.
*/
define bug_yW();
    $-eden$-world.bw_bug_yW;
enddefine;


/*  object_at_bug():
*/
define object_at_bug();
    $-eden$-world( bug_xW(), bug_yW() );
enddefine;


/*  object_at(xW,yW):
*/
define object_at( xW, yW );
    lvars xW, yW;
    $-eden$-world( xW, yW );
enddefine;


/*  direction():
        Bug's direction, as one of {"north","south","east","west"}.
*/
define direction();
    $-eden$-world.bw_direction;
enddefine;


/*  forwardvector():
        Bug's forwardvector: a unit vector pointing in his current
        forward direction. This is the same as the Y-axis of his local
        co-ordinate system.
*/
define forwardvector();
    $-eden$-world.bw_forwardvector;
enddefine;


/*  rightvector():
        Bug's rightvector: a unit vector pointing in his current
        right direction. This is the same as the X-axis of his local
        co-ordinate system, and is his forwardvector rotated right
        by 90 degrees.
*/
define rightvector();
    $-eden$-world.bw_rightvector;
enddefine;


/*  bearing( x, y ):
*/
define bearing( x, y );
    lvars x, y;
    bw_bearing( $-eden$-world, x, y );
enddefine;


/*  scent( x, y ):
*/
define scent( x, y );
    lvars x, y;
    if x=bug_xW() and y=bug_yW() then
        "here"
    else
        bearing( x, y );
    endif;
enddefine;


/*  one_forward( xW, yW ):
        Returns the co-ordinates of the square one place forward
        from (xW,yW).
*/
define one_forward( xW, yW );
    lvars xW, yW;
    bw_rel_forward( $-eden$-world, xW, yW, 1 );
enddefine;


/*  one_back( xW, yW ):
        Returns the co-ordinates of the square one place back
        from (xW,yW).
*/
define one_back( xW, yW);
    lvars xW, yW;
    bw_rel_forward( $-eden$-world, xW, yW, -1 );
enddefine;


/*  one_left( xW, yW ):
        Returns the co-ordinates of the square one place left
        from (xW,yW).
*/
define one_left( xW, yW );
    lvars xW, yW;
    bw_rel_right( $-eden$-world, xW, yW, -1 );
enddefine;


/*  one_right( xW, yW ):
        Returns the co-ordinates of the square one place right
        from (xW,yW).
*/
define one_right( xW, yW );
    lvars xW, yW;
    bw_rel_right( $-eden$-world, xW, yW, 1 );
enddefine;


/*  object_name(char):
*/
define object_name(char);
    lvars char;
    bw_object_name( $-eden$-world, char );
enddefine;


/*
*/
define destroy( id_or_loc );
    lvars id_or_loc;
    bw_destroy_object( $-eden$-world, id_or_loc );
enddefine;


define new(type_or_char);
    lvars type_or_char;
    bw_new_object( $-eden$-world, type_or_char );
enddefine;


define place( id, loc );
    lvars id, loc;
    bw_place_object( $-eden$-world, id, loc );
enddefine;


define kill_bug();
    bw_kill_bug( $-eden$-world );
enddefine;


define kill(message);
    lvars message;
    bug_message( message );
    wait(5);
    kill_bug();
    exit_eden();
enddefine;
