	/* set up table sizes for LEX */

%e 5000
%p 15000
%a 7000
%o 7000
%n 1500
%k 3000

	/* define types for construct recognition */

D						[0-9]
E						[DEde][-+]?{D}+
CAPSWD						([A-Z][.]?)+
WORD						[A-Za-z][a-z]*
HYPWORD 					{WORD}\-{WORD}(\-{WORD})*
SPLTWD						{WORD}\-$
APSWORD 					{WORD}\'{WORD}
WSPACE						[ \t\n]+
IGNORE  					[`'\(\)\[\]\{\}]
PUNCTN  					[\,\;\:\.\?\!]
%%

{IGNORE}					;
{WSPACE}					;


{D}+         				   	print_integer(yytext);

{D}{1,3}(","{D}{D}{D})+				print_integer(strip_comma(yytext));



"-"{D}+       				  	print_integer_minus(yytext);

"-"{D}{1,3}(","{D}{D}{D})+			print_integer_minus(strip_comma(yytext));



{D}+"."{D}*{E}?					|
{D}*"."{D}+{E}?					|
{D}+{E}						print_real(yytext);


{D}{1,3}(","{D}{D}{D})+"."{D}*({E})?		|
{D}{1,3}(","{D}{D}{D})+{E}			print_real(strip_comma(yytext));



"-"{D}+"."{D}*{E}?				|
"-"{D}*"."{D}+{E}?				|
"-"{D}+{E}					print_real_minus(yytext);

"-"{D}{1,3}(","{D}{D}{D})+"."{D}*({E})?		|
"-"{D}{1,3}(","{D}{D}{D})+{E}			print_real_minus(strip_comma(yytext));



{D}{D}?[-/.]{D}{D}?[-/.]{D}{D}({D}{D})?		print_date(yytext);



{D}{D}?":"{D}{D}				|
{D}{D}?(":"{D}{D})?(am|pm)			print_time(yytext);



"$"{D}+("."{D}{D})?				|
"$"{D}+("."{D}+)?(K|M|Bn)			print_money(yytext);

"$"{D}{1,3}(","{D}{D}{D})+("."{D}{D})?		|
"$"{D}{1,3}(","{D}{D}{D})+("."{D}+)?(K|M|Bn)	print_money(strip_comma(yytext));



[\001-\026]		printf("CONTROL\n%c\n", yytext[0] + 64);
\"			printf("QUOTE\n");
\#			printf("HASH\n");
\$			printf("DOLLAR\n");
\%			printf("PER\nCENT\n");
\&			printf("AND\n");
\*			printf("TIMES\n");
\+			printf("PLUS\n");
\-			printf("MINUS\n");
\/			printf("SLASH\n");
\<			printf("LESS\nTHAN\n");
\=			printf("EQUALS\n");
\>			printf("GREATER\nTHAN\n");
\\			printf("BACK\nSLASH\n");
\^			printf("CARROT\n");
\_			printf("UNDER\nSCORE\n");
\@			printf("AT\n");
\|			printf("BAR\n");
\~			printf("TILDA\n");
\127			printf("DELETE\n");


"a/c"			printf("ACCOUNT\n");
"B&B"			printf("BED\nAND\nBREAKFAST\n");
"c/o"			printf("CARE\nOF\n");
"c/s"			printf("CYCLES\nPER\nSECOND\n");
"i/c"			printf("IN\nCHARGE\n");
"o/a"			printf("ON\nACCOUNT\nOF\n");

[Aa]bbr[.]?		printf("ABBREVIATED\n");
[Aa]bbrev[.]?		printf("ABBREVIATION\n");
[Aa]bs[.]?		printf("ABSOLUTE\n");
ac			printf("A\nC\n");
[Aa]"d inf"[.]?		printf("AD\nINFINITUM\n");
Adm[.]?			printf("ADMIRAL\n");
[Aa]dmin[.]?		printf("ADMINISTRATION\n");
[Aa]dvt[.]?		printf("ADVERTISMENT\n");
[Aa]gric[.]?		printf("AGRICULTURE\n");
Ah			printf("AMP\nHOUR\n");
Ah{PUNCTN}		printf("AH\n");
[Aa]mt[.]?		printf("AMOUNT\n");
[Aa]nat[.]?		printf("ANATOMY\n");
[Aa]non[.]?		printf("ANONYMOUS\n");
[Aa]ns[.]?		printf("ANSWER\n");
Apr[.]?			printf("APRIL\n");
[Aa]rchit[.]?		printf("ARCHITECTURE\n");
[Aa]ssoc[.]?		printf("ASSOCIATION\n");
[Aa]sst[.]?		printf("ASSISTANT\n");
[Aa]tm[.]?		printf("ATMOSPHERE\n");
Att[.]?			printf("ATTORNEY\n");
Aug[.]?			printf("AUGUST\n");
[Bb]al[.]?		printf("BALANCE\n");
"Bar."			printf("BARRISTER\n");
[Bb]iol[.]?		printf("BIOLOGY\n");
[Bb]ldg[.]?		printf("BUILDING\n");
Blvd[.]?		printf("BOULEVARD\n");
Brig[.]?		printf("BRIGADIER\n");
[Bb]ro[.]?		printf("BROTHER\n");
[Bb]ros[.]?		printf("BROTHERS\n");
[Cc]apt[.]?		printf("CAPTAIN\n");
"Card."			printf("CARDINAL\n");
cd[.]?			printf("CANDELA\n");
[Cc]ertif[.]?		printf("CERTIFICATE\n");
[Cc]hem[.]?		printf("CHEMISTRY\n");
[Cc]hoc[.]?		printf("CHOCOLATE\n"); 
cm			printf("CENTIMETRE\n"); 
[Cc]o[.]?		printf("COMPANY\n"); 
[Cc]"o-ed"[.]?		printf("CO\nEDUCATIONAL\n"); 
Col[.]?			printf("COLONEL\n"); 
[Cc]olloq[.]?		printf("COLLOOQUIAL\n"); 
Comdr[.]?		printf("COMMANDER\n"); 
[Cc]ont[d]?[.]?		printf("CONTINUED\n"); 
[Cc]"o-op"[.]?		printf("CO\nOPERATIVE\n"); 
[Cc]f[.]?		printf("COMPARE\nWITH\n"); 
[Cc]orp[.]?		printf("CORPORATION\n"); 
cp[.]?			printf("CANDLE\nPOWER\n"); 
[Cc]res[.]?		printf("CRESENT\n"); 
cu[.]?			printf("CUBIC\n"); 
[Cc]wt[.]?		printf("HUNDREDWEIGHT\n"); 
dB			printf("DECIBEL\n"); 
[Dd]bl[.]?		printf("DOUBLE\n"); 
Dec[.]?			printf("DECEMBER\n"); 
dec[.]?			printf("DECEASED\n"); 
[Dd]ef[.]?		printf("DEFINITION\n"); 
[Dd]ep[.]?		printf("DEPARTS\n"); 
[Dd]ept[.]?		printf("DEPARTMENT\n"); 
[Dd]iam[.]?		printf("DIAMETER\n"); 
Dr[.]?			printf("DOCTOR\n"); 
Ed[.]?			printf("EDITOR\n"); 
[Ee]sp[.]?		printf("ESPECIALLY\n"); 
Esq[.]?			printf("ESQUIRE\n"); 
[Ee]tc[.]?		printf("ET\nCETERA\n"); 
eV			printf("ELECTRON\nVOLT\n"); 
[Ee]xec[.]?		printf("EXECUTIVE\n"); 
Feb[.]?			printf("FEBRUARY\n"); 
[Ff]ig[.]		printf("FIGURE\n"); 
fl[.]?			printf("FLUID\n"); 
Fri[.]?			printf("FRIDAY\n"); 
ft[.]?			printf("FEET\n"); 
[Gg]dns[.]?		printf("GARDENS\n"); 
[Gg]eog[.]?		printf("GEOGRAPHY\n"); 
[Gg]eol[.]?		printf("GEOLOGY\n"); 
GeV			printf("GIGA\nELECTRON\nVOLT\n");
GJ			printf("GIGA\nJOULE\n"); 
[Gg]ovt[.]?		printf("GOVERNMENT\n"); 
[Hh]ons[.]?		printf("HONOURS\n"); 
Hon[.]?			printf("HONOURABLE\n"); 
hr			printf("HOUR\n"); 
Hz			printf("HERTZ\n"); 
[Ii]mp[.]?		printf("IMPERIAL\n"); 
[Ii]ncorp[.]?		printf("INCORPORATED\n"); 
[Ii]nd[.]?		printf("INDUSTRIAL\n"); 
[Ii]ndiv[.]?		printf("INDIVIDUAL\n"); 
[Ii]nst[.]?		printf("INSTITUTE\n"); 
[Ii]ntro[d]?[.]?	printf("INTRODUCTION\n"); 
IR			printf("INFRA\nRED\n"); 
Jan[.]?			printf("JANUARY\n"); 
J[n]?r[.]?		printf("JUNIOR\n"); 
Jul[.]?			printf("JULY\n"); 
Jun[.]?			printf("JUNE\n"); 
[Jj]unc[.]?		printf("JUNCTION\n"); 
keV			printf("KILO\nELECTRON\nVOLT\n"); 
kg[.]?			printf("KILOGRAMME\n"); 
kJ			printf("KILO\nJOULE\n"); 
km[.]?			printf("KILOMETRE\n"); 
km[/]?h[.]?		printf("KILOMETRES\nPER\nHOUR\n"); 
[Kk]n[.]?		printf("KNOT\n"); 
kW			printf("KILOWATT\n"); 
kWh			printf("KILOWATT\nHOUR\n"); 
[Ll]ang[.]?		printf("LANGUAGE\n"); 
[Ll]bw[.]?		printf("LEG\nBEFORE\nWICKET\n"); 
Lieut[.]?		printf("LIEUTENANT\n"); 
Lt[.]?			printf("LIEUTENANT\n");
[Ll]td[.]?		printf("LIMITED\n"); 
lx			printf("LUX\n"); 
Maj[.]?			printf("MAJOR\n"); 
Mar[.]?			printf("MARCH\n"); 
mb			printf("MILLIBAR\n"); 
[Mm]dm[.]?		printf("MADAM\n"); 
[Mm]ech[.]?		printf("MECHANICAL\n"); 
MeV			printf("MEGA\nELECTRON\nVOLT\n"); 
[Mm]frs[.]?		printf("MANUFACTURERS\n"); 
mg			printf("MILLIGRAMME\n"); 
[Mm]isc[.]?		printf("MISCELLANEOUS\n");
MJ			printf("MEGA\nJOULE\n"); 
ml			printf("MILLILITRE\n"); 
mm			printf("MILLIMETRE\n"); 
Mme[.]?			printf("MADAM\n"); 
[Mm]pg[.]?		printf("MILES\nPER\nGALLON\n"); 
[Mm]ph[.]?		printf("MILES\nPER\nHOUR\n"); 
Mr[.]?			printf("MISTER\n"); 
Mrs[.]?			printf("MISSES\n"); 
Ms[.]?			printf("MIZ\n"); 
ms			printf("MILLISECOND\n"); 
Nat[.]?			printf("NATIONAL\n"); 
[Nn]eg[.]?		printf("NEGATIVE\n"); 
[Nn]os[.]?		printf("NUMBERS\n"); 
Nov[.]?			printf("NOVEMBER\n"); 
ns			printf("NANOSECOND\n"); 
Oct[.]?			printf("OCTOBER\n"); 
[Oo]pp[.]?		printf("OPPOSITE\n"); 
[Oo]rig[.]?		printf("ORIGIN\n"); 
oz[.]?			printf("OUNCE\n"); 
[Pp]ce[.]?		printf("PIECE\n"); 
[Pp]hys[.]?		printf("PHYSICS\n"); 
[Pp]"op."		printf("POPULATION\n"); 
pp[.]?			printf("PAGES\n"); 
Pres[.]?		printf("PRESIDENT\n"); 
[Pp]rob[.]?		printf("PROBABLY\n"); 
Prof[.]?		printf("PROFESSOR\n"); 
[Pp]seud[.]?		printf("PSEUDONYM\n"); 
[Qq]ty[.]?		printf("QUANTITY\n"); 
[Rr]ecd[.]?		printf("RECEIVED\n"); 
[Rr]ecp[.]?		printf("RECEIPT\n"); 
[Rr]ef[.]?		printf("REFERENCE\n"); 
[Rr]etd[.]?		printf("RETIRED\n"); 
[Rr]ly[.]?		printf("RAILWAY\n");
Rt[.]?			printf("RIGHT\n");
Sat[.]?			printf("SATURDAY\n");
[Ss]ec[.]?		printf("SECRETARY\n");
Sept[.]			printf("SEPTEMBER\n");
Sergt[.]?		printf("SERGEANT\n");
S[n]?r[.]?		printf("SENIOR\n");
St[.]?			printf("SAINT\n");
"Sun."			printf("SUNDAY\n");
[Ss]ubj[.]?		printf("SUBJECT\n");
[Ss]yst[.]?		printf("SYSTEM\n");
[Tt]el[.]?		printf("TELEPHONE\n");
[Tt]emp[.]?		printf("TEMPERATURE\n");
Thur[.]?		printf("THURSDAY\n");
[Tt]reas[.]?		printf("TREASURER\n");
Tue[s]?[.]?		printf("TUESDAY\n");
uk			printf("U\nK\n");
[Uu]niv[.]?		printf("UNIVERSITY\n");
UV			printf("ULTRA\nVIOLET\n");
[Vv]al[.]?		printf("VALUE\n");
[Vv]eg[.]?		printf("VEGETABLE\n");
[Vv]el[.]?		printf("VELOCITY\n");
[Vv]ol[.]?		printf("VOLUME\n");
Wed[.]?			printf("WEDNESDAY\n");
[Ww]k[s]?[.]?		printf("WEEKS\n");
[Ww]t[.]?		printf("WEIGHT\n");
Xmas			printf("CHRISTMAS\n");
yd			printf("YARD\n");

[Aa][.]?[Kk][.]?[Aa][.]?		printf("ALSO\nKNOWN\nAS\n");
[Aa][.]?[Mm][.]?[Uu][.]?		printf("ATOMIC\nMASS\nUNIT\n");
[Aa][.]?[Ss][.]?[Aa][.]?[Pp][.]? 	printf("AS\nSOON\nAS\nPOSSIBLE\n");
[Cc][.]?[Oo][.]?[Dd][.]?		printf("CASH\nON\nDELIVERY\n");
[Dd][.]?[Oo][.]?[Bb][.]?		printf("DATE\nOF\nBIRTH\n");
E[.]?N[.]?E[.]?				printf("EAST\nNORTH\nEAST\n");
E[.]?S[.]?E[.]?				printf("EAST\nSOUTH\nEAST\n");
[Ff][.]?[Oo][.]?[Cc][.]?		printf("FREE\nOF\nCHARGE\n");
[Ii][.]?e[.]?				printf("THAT\nIS\n");
[Ll][.]?[Hh][.]?			printf("LEFT\nHAND\n");
[Ll][.]?[Hh][.]?[Dd][.]?		printf("LEFT\nHAND\nDRIVE\n");
[Ll][.]?[Hh][.]?[Ss][.]?		printf("LEFT\nHAND\nSIDE\n");
[Nn][.]?[Bb][.]?[Gg][.]?		printf("NO\nBLOODY\nGOOD\n");
N[.]?E[.]?				printf("NORTH\nEAST\n");
N[.]?N[.]?E[.]?				printf("NORTH\nNORTH\nEAST\n");
N[.]?N[.]?W[.]?				printf("NORTH\nNORTH\nWEST\n");
N[.]?W[.]?				printf("NOTH\nWEST\n");
[Oo][.]?[Ii][.]?[Cc][.]?		printf("OFFICER\nIN\nCHARGE\n");
[Oo][.]?[Nn][.]?[Oo][.]?		printf("OR\nNEAREST\nOFFER\n"); 
[Oo][.]?[Nn][.]?[Rr][.]?[Oo][.]? 	printf("OR\nNEAREST\nREASONABLE\nOFFER\n");
[Pp][.]?[Bb][.]?[Aa][.]?[Bb][.]? 	printf("PLEASE\nBRING\nA\nBOTTLE\n");
[Pp][Pp][Mm][.]?			printf("PARTS\nPER\nMILLION\n");
[Rr][.]?[Hh][.]?			printf("RIGHT\nHAND\n");
[Rr][.]?[Hh][.]?[Dd][.]?		printf("RIGHT\nHAND\nDRIVE\n");
[Rr][.]?[Hh][.]?[Ss][.]?		printf("RIGHT\nHAND\nSIDE\n");
[Rr][Pp][Mm][.]?			printf("REVOLUTIONS\nPER\nMINUTE\n");
[Rr][.]?[Ss][.]?[Vv][.]?[Pp][.]? 	printf("RESPONDAY\nSI\nVOUS\nPLAY\n");
[Ss][Aa][Ee][.]?			printf("STAMPED\nADDRESSED\nENVELOPE\n");
S[.]?E[.]?				printf("SOUTH\nEAST\n");
S[.]?S[.]?E[.]?				printf("SOUTH\nSOUTH\nEAST\n");
S[.]?S[.]?W[.]?				printf("SOUTH\nSOUTH\nWEST\n");
S[.]?W[.]?				printf("SOUTH\nWEST\n");
[Ww][Pp][Mm][.]?			printf("WORDS\nPER\nMINUTE\n");
[Ww][.]?[Rr][.]?[Tt][.]?		printf("WITH\nRESPECT\nTO\n");
W[.]?N[.]?W[.]?				printf("WEST\nNORTH\nWEST\n");
W[.]?S[.]?W[.]?				printf("WEST\nSOUTH\nWEST\n");



{WORD}          print_word(yytext);
{HYPWORD}       print_hypword(yytext);
{SPLTWD}	print_split(yytext);
{APSWORD}       print_apost(yytext);
{CAPSWD}	print_abbrev(yytext);
{PUNCTN}	printf("%s\n", yytext);


%%

# include <ctype.h>
# include <string.h>

char* strip_comma(char*);

/* define all units to be used by following routines. */

static char digit_unit[10][6] = {
  "OH", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"
};

static char digit_teen[10][10] = {
  "TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"
};

static char dig_tens[10][8] = {
  "", "", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"
};

static char digit_triad[4][9] = {
  "THOUSAND", "MILLION", "BILLION", "TRILLION"
};

static char month[12][10] = {
  "JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"
};



/* prints out hyphenated words or phrases letter by letter substituting '-' for newline */
/* loops through string character by character and prints the upper-case version of any letter and for */
/* any '-' it finds it prints a newline character. */

print_hypword(char *string) {

  int i;
  for(i = 0; i < strlen(string); i++) 
    if(string[i] == '-')
      printf("\n");
    else {
      string[i] = toupper(string[i]);
      printf("%c", string[i]);
      }
  printf("\n");
}



/* prints out integer eg 123 is ONE HUNDRED AND TWENTY THREE */

print_integer(char *string) {

  int i, digits, triads, q, flag;

  flag = 0;
  digits = strlen(string);
  triads = (digits / 3);

/* if we find a four digit number beginning with a non-zero and having its first digit */
/* as a one then print it out in year form, not integer form. otherwise continue */

  if((digits == 4) && (string[0] - '0' == 1))
    print_year(string);
  else {

/* only do main part of procedure if the number has less than sixteen digits and does not begin with zero */

    if((digits < 16) && (string[0] - '0' != 0)) {

/* loop through digit by digit from beginning to end */

      for(i = 0; i < digits; i++) {

/* q is the value of the preceding three digits (or 1 if there are less than three previous digits) and is used to */
/* decide whether or not to pronounce triad multiplier. zero implies do not pronounce */

        if(i > 2)
          q = ((string[i] - '0') + (string[(i - 1)] - '0') + (string[(i - 2)] - '0'));
        else
          q = 1;

/* this bit sorts out 'hundreds' digits. if digit is a zero then don't write a number, say 'AND' if either of next two */
/* digits is non-zero. otherwise say number followed by 'HUNDRED', then 'AND' if either of next two digits is non-zero */

        if((digits - i) % 3 == 0) {
          if((string[i] - '0' == 0) && (i > (digits - 4)) && ((string[(i + 1)] - '0' != 0) || (string[(i + 2)] - '0' != 0)))
            printf("AND\n");
          else {
            if(string[i] - '0' > 0) {
              printf("%s\nHUNDRED\n", digit_unit[string[i] - '0']);
              if((string[(i + 1)] - '0' != 0) || (string[(i + 2)] - '0' != 0))
                printf("AND\n");
              }
            }
          }

/* tens digits. prints out relevant tens name unless digit is zero or one. If one then print out relevant teen name by */
/* looking at next digit and set flag to indicate teen. if zero do nothing */

        if((digits - i) % 3 == 2) {
          if((string[i] - '0') == 1) {
            printf("%s\n", digit_teen[string[(i + 1)] - '0']);
            flag = 1;
            }
          else
            if((string[i] - '0') > 1)
              printf("%s\n", dig_tens[string[i] - '0']);
          }

/* units digits. if non-zero prints out number. if not in last triad or if q not zero then prints out relevant triad name */
/* does not print out unit if flag is set by previous digit being a '1' ie 'teen. flag cleared if set. */

        if((digits - i) % 3 == 1) {
          if(flag == 1)
            flag = 0;
          else
            if(string[i]-'0' != 0)
              printf("%s\n", digit_unit[string[i]- '0']);
          if((i < (digits - 2)) && (q > 0))
            printf("%s\n", digit_triad[(((digits - i) / 3) - 1)]);
          }
        }
      } 

/* from earlier, if more than 16 digit or beginning with '0' then print digit by digit */

    else
      print_number(string);
  }
}



/* prints out any integer digit by digit. if string is '0' then say 'ZERO' otherwise all '0's are 'OH's */

print_number(char *string) {

  int i;

  if((strlen(string) == 1) && (string[0] == '0')) 
    printf("ZERO\n");
  else
    for(i = 0; i < strlen(string); i++)
      printf("%s\n", digit_unit[string[i] - '0']);
}


/* prints out real numbers including those with exponents. Uses other routines to print parts in correct format. */

print_real(char *string) {

  int i, j, k, flag;
  char substring[20];

  j = 0;
  k = 0;
  flag = 0;

/* search out first non-numeric char - either '.' or 'e'. Its at string[j] */
/* print out everything up to string[j] as integer part of mantissa if there is anything */

  while(isdigit(string[j])) 
    j = j++;
  if(j > 0) {
    strncpy(substring, string, j);
    substring[j] = 0;
    print_integer(substring);
    }

/* if j isn't last char in string then search along for next non-numeric */
/* call it k + 1. k=0 implies no other non-numerics. */

  if(j < strlen(string)) {
    for(i = j + 1; i < strlen(string); i++)
      if((flag == 0) && (isdigit(string[i])))
        k = i;
      else
        flag = 1;
      }

/* if string[j] is '.' and there is another non-numeric then bit in between */
/* is decimal part of mantissa. */

  if((k > j) && (string[j] == '.')) {
    strncpy(substring, string + j + 1, k - j);
    substring[k - j] = 0;
    printf("POINT\n");
    print_number(substring);
    }

/* if string[j] was '.' and there was another non-numeric, it must be 'e' */
/* everything after it must be exponent part. Separate and process */

  if((k > j) && (string[j] == '.') && (k + 1 < strlen(string))) { 
    strncpy(substring, string + k + 2, strlen(string) - k - 2);
    substring[strlen(string) - k - 2] = 0;
    if(strlen(substring) > 0)
      print_exponent(substring);
    }

/* if string[j] was not '.' it was 'e'. Everything after it must be exponent */
/* pull it off and process */

  if(string[j] != '.') {
    strncpy(substring, string + j + 1, strlen(string) - j - 1);
    substring[strlen(string) - j - 1] = 0;
    if(strlen(substring) > 0) 
      print_exponent(substring);
    }
}



/* prints out exponent part of a real number */

print_exponent(char *string) {

  printf("TIMES\nTEN\nTO\nTHE\nPOWER\n");
  if(string[0] == '-')
    print_integer_minus(string);
  else
    if(string[0] == '+') {
      string = string++;
      print_integer(string);
      }
    else
      print_integer(string);   
}

print_abbrev(char *string) {
  int i;

  for(i = 0; i < strlen(string); i++)
    if(string[i] != '.')
      printf("%c\n", string[i]);

}


/* prints 'MINUS' then increments the string pointer to 'remove' minus sign. then calls print_integer with the new string */

print_integer_minus(char *string) {

  printf("MINUS\n");
  string = string++;
  print_integer(string);

}


/* prints 'MINUS' then increments the string pointer to 'remove' minus sign. then calls print_real with the new string */
 
print_real_minus(char *string) {

  printf("MINUS\n");
  string = string++;
  print_real(string); 

}


/* takes a date and prints it */

print_date(char *string) {

  char substring[10];

/* if the second character is not a digit then the day has only one digit. Strip it off. */
/* else it has two digits. Strip it off. Then print out this substring using print_integer. */
/* in both cases increment the string pointer so that it points to the first character of the month portion. */

  if(string[1] - '0' < 0) {
    strncpy(substring, string, 1);
    substring[1] = 0;
    string = string + 2;
    }
  else {
    if(string[0] == '0') {
      strncpy(substring, string + 1, 1);
      substring[1] = 0;
      string = string + 3;  
      }
    else {
      strncpy(substring, string, 2);
      substring[2] = 0;
      string = string + 3;
      }
    }
  print_integer(substring);

/* if second character is a digit then month has two digits. Print out corresponding month and increment string pointer */
/* to first digit of year portion. else print out one digit month and increment the pointer as before. */

  if((string[1] - '0' >= 0) && (string[0] - '0' == 1)) {
    printf("%s\n", month[string[1] - '0' + 9]);
    string = string + 3;
    }
  if((string[1] - '0' >= 0) && (string[0] - '0' == 0)) {
    printf("%s\n", month[string[1] - '0' - 1]);
    string = string + 3;
    }
  if(string[1] - '0' < 0) {
    printf("%s\n", month[string[0] - '0' - 1]);
    string = string + 2;
    }

/* if year has two digits prefix 'NINETEEN'. If the two digits are both zero then print 'HUNDRED' else use print_integer */
/* to print rest of year. Otherwise year has four digits. Use print_integer to print all four digits. That contains */
/* exception rules so that things like 1066 get printed as TEN SIXTY SIX */

  if(strlen(string) == 2) {
    printf("NINETEEN\n");
    if((string[0] == '0') && (string[1] == '0'))
      printf("HUNDRED\n");
    else
      print_integer(string);
    }
  else
    print_integer(string);
}


/* if print_integer finds something with four digits that could be pronounced in year format it sends it here. This */
/* routine prints wxyz in the forn wx yz so that 1991 becomes NINETEEN  NINETY ONE. If last two digits are zeros then */
/* the word 'HUNDRED' is substituted. */

print_year(char *string) {

  char substring[10];

  strncpy(substring, string, 2);
  substring[2] = 0;
  print_integer(substring);
  string = string + 2;
  if((string[0] - '0' == 0) && (string[1] - '0' == 0))
    printf("HUNDRED\n");
  else 
    print_integer(string);
}


/* if a word followed by a hyphen is found at the end of a line this routine strips it of the hyphen and ensures that */
/* the next word is concatenated with it, thus rejoining long words split across two lines. It converts to upper-case */
/* and 'forgets' to print a newline character after the string so that any following output is put on the same line. */

print_split(char *string) {

  int i;

  for(i = 0; i + 1< strlen(string); i++) {
    string[i] = toupper(string[i]);
    printf("%c", string[i]);
    }
}


/* prints out times including constructs such as 9am, 10:47pm, 9:01, 22:47 etc */

print_time(char *string) {

  int i, j, flag;
  char substring[10];

  flag = 0;
  j = 0;

/* find out how many digits in hour. separate hour and print. */

  for(i = 0; i < strlen(string); i++)
    if((flag == 0) && (isdigit(string[i])))
      j = i + 1;
    else 
      flag = 1;
  if(j > 0) {
    strncpy(substring, string, j);
    substring[j] = 0;
    print_integer(substring);
    }

/* if next char is ':' then pull off minutes and print. */

  if(string[j] == ':') {
    strncpy(substring, string + j + 1, 2);
    substring[2] = 0;
    print_integer(substring);
    }

/* if 'am' or 'pm' there are two possibilities. Could be after hour as in 9am or after minutes 9:01am */
/* this is not elegant but it works! */

  if(string[j] == 'a')
    printf("A\nM\n");
  if(string[j] == 'p')
    printf("P\nM\n");
  if(strlen(string) > 5) {
    if(string[j + 3] == 'a')
      printf("A\nM\n");
    if(string[j + 3] == 'p')
      printf("P\nM\n");
    }
}


/* converts words to upper case. this is just for uniformaty of output rather than necessity */

print_word(char *string) {

  int i;

  for(i = 0; i < strlen(string); i++)
    string[i] = toupper(string[i]);
  printf("%s\n", string);
}


/* routine to cope with money. Supports $2M as well as $2.12 */

print_money(char *string) {

  int i, j, k, flag;
  char substring[15];

  j = 0;
  flag = 0;
  if(isdigit(string[strlen(string) - 1])) {

/* figure does not contain suffix letter therefore read as 'integer dollars and integer cents' */
/* first find the dollars integer part, separate and use print_integer to print. Follow by 'DOLLARS'. */
 
    for(i = 1; i < strlen(string); i++)
      if((flag == 0) && (isdigit(string[i])))
        j = i + 1;
      else 
        flag = 1;
    if(j > 1) {
      strncpy(substring, string + 1, j - 1);
      substring[j - 1] = 0;
      print_integer(substring);
      }
    printf("DOLLARS\n");

/* then strip out two digits which are read by print_integer and followed by 'CENTS' unless both are zero. */

    strncpy(substring, string + j + 1, 2);
    substring[2] = 0;
    if((substring[0] != '0') || (substring[1] != '0')) {
      printf("AND\n");
      print_integer(substring);
      printf("CENTS\n");
      }
    }

/* otherwise we have something of the form integer plus decimal times multiplier dollars eg $2.345M */
/* find integer part as before then follow by 'POINT' if there is decimal part. Decimal part then found and */
/* readby print_number. */

  else {   
    for(i = 1; i < strlen(string); i++)
      if((flag == 0) && (isdigit(string[i])))
        j = i + 1;
      else 
        flag = 1;
    if(j > 1) {
      strncpy(substring, string + 1, j - 1);
      substring[j - 1] = 0;
      print_integer(substring);
      }
    flag = 0;
    k = 0;
    for(i = j + 1; i < strlen(string); i++)
      if((flag == 0) && (isdigit(string[i])))
        k = i + 1;
      else
        flag = 1;
    if(k - j > 1) {
      strncpy(substring, string + j + 1, k - j - 1);
      substring[k - j - 1] = 0;
      printf("POINT\n");
      print_number(substring);
      }

/* now print out correct multiplier followed by 'DOLLARS' */

    if(k == 0)
      k = j;
    if(string[k] == 'K') 
      printf("THOUSAND\n");
    if(string[k] == 'M')
      printf("MILLION\n");
    if(string[k] == 'B')
      printf("BILLION\n");
    printf("DOLLARS\n");
    }
}
    
    
/* strips the commas out of any string and returns the commaless string */

char *strip_comma(char *string) {

  int i, j, k;

  i = 0;
  while(string[i] != 0) { 
    if(string[i] != ',')
      i = i++;
    else {
      k = strlen(string);
      for(j = i; j + 1 < k; j++)
        string[j] = string[j + 1];
      string[k - 1] = 0;
      }
    }
  return string;
}


/* prints out words with apostrophies */

print_apost(char *string) {

  int i;
 
  for(i = 0; i < strlen(string); i++)
    if(string[i] != '\'') {
      string[i] = toupper(string[i]);
      printf("%c", string[i]);
      }
  printf("\n");
}
