/*
 *
 * $Id: speechread.c,v 2.4 1993/06/09 20:58:40 johans Exp $
 *
 */

/* Standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Speech library include file directives */
#include <speech.h>
#include <ad.h>

/* external variable declaration */
extern int errno;
extern int sys_nerr;
extern char *sys_errlist[];

/*
 * int SpeechRead(filename, samples_p, sample_rate_p)
 *
 * This procedure reads in either a speech wave file or adc file
 * and stores the data in a vector of shorts which it allocates
 *
 * filename (in): name of speech file
 * samples_p    (out): pointer to vector of shorts
 * sample_rate_p(out): sampling frequency of file
 *
 * On exit returns (-1) for failure else the number of bytes read
 *
 */

int SpeechRead (char *filename, short **samples_p, float *sample_rate_p)
{
  FILE *fp;
  char buf[64];
  ad_head_t adc_head;
  int numread, rate, i;

  if (strcmp(filename,"-") == 0) 
    fp = stdin;
  else {
    if((fp = fopen(filename,"r")) == NULL) {
      if( errno < sys_nerr ) {
	ErrorString = sys_errlist[errno];
      } else {
	ErrorString = "chmod failed";
      }
      return( -1 );
    }
  }

  if(fread(buf,1,7,fp) != 7) {
    if( errno < sys_nerr ) {
      ErrorString = sys_errlist[errno];
    } else {
      ErrorString = "chmod failed";
    }
    fclose(fp);
    return( -1 );
  }
  buf[7] = '\0';
  if (strcmp(filename,"-") == 0) {
    for (i=6; i>=0; i--) 
      ungetc((int) buf[i], fp); 
  } else
    fclose(fp);

  if(!strcmp(buf,"NIST_1A"))
    {
      numread = WavRead(filename,samples_p, &rate);
      *sample_rate_p = (float) rate;
    }
  else
    {
      if( (numread = AdcRead( filename, samples_p, &rate ) ) < 0)
	return -1;
      *sample_rate_p = (float) rate;
    }
  return numread;
}
