#!/bin/sh
#
# mkdepend.sh
#
#	make Makefile dependicy lines for Speech source code
#
#
# John Pochmara
# Oregon Graduate Institute of Science & Technology
#
#

while :
do
	case $1 in
		 -I*) INC="$INC $1"; shift;;
		-*) shift;;
		*)break;;
	esac
done

MAKEFILE=$1
shift

rm -f Xmakefile

(
	sed -e '/^# DO NOT REMOVE THIS LINE/q' < $MAKEFILE
	echo " "

	for i in $*
	do
		cc -E $INC $i | 
		sed -n -e 's/^#[ 	]*[0-9]*[ 	]*"\(.*\)".*$/\1/p' |
		sed -e 's,^/usr/.*,,' |
		sed -e 's,^\./,,' |
		sort -u |
		awk '
			BEGIN {
				src = "'"$i"'";
				fobj = substr( src, 0, length(src)-2) ".o";
				inx = split( src, A, "/" );
				obj = substr( A[inx], 0, length(A[inx])-2) ".o";
				deps = src;
				len = 0;
				maxlen = 80 - (11 + length(obj));
			}

			{
				len += length( $0 );

				if( len > maxlen ) {
					printf "${OBJ_DIR}/%s: %s\n", fobj, deps;
					len = length( $0 );
					deps = "";
				}

				deps = $0 " " deps;
			}

			END {
				printf "${OBJ_DIR}/%s: %s\n", fobj, deps;
				printf "\t@. ${CONF} ; echo \". ${CONF} ; $$CC $(CFLAGS) $$GCFLAGS -c %s\"\n", src;
				printf "\t@. ${CONF} ; $$CC $(CFLAGS) $$GCFLAGS -c %s\n\n", src;
				printf "\t@. ${CONF} ; echo \". ${CONF} ; $$MV %s ${OBJ_DIR}/%s\"\n", obj, fobj;
				printf "\t@. ${CONF} ; $$MV %s ${OBJ_DIR}/%s\n", obj, fobj;

			}'
	done
) > Xmakefile

mv $MAKEFILE $MAKEFILE.bak
mv Xmakefile $MAKEFILE

