/* 
 * $Id: tdat2ascii.c,v 1.10 1993/06/10 17:26:15 johans Exp $
 */

/* Standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Speech Libary include file directives */
#include <speech.h>

#define COEFF_PER_LINE		(18)

char InFileName[200]="-";                 /* Input file name / stdin      */
char OutFileName[200]="-";                /* Output file name / stdout    */

FILE *infile, *outfile;

/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | tdat2ascii [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:ih")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(InFileName, optarg);
                break;

            case 'o':  /* output file */
		strcpy(OutFileName, optarg);
		break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


static void PrintSpec(short **dft, AsciiHdr *hdr )
{
  char *tmp;
  int  rows;
  int  cols;
  double rate;
  int i, j, k;

  tmp = FindHeaderVal( hdr, "Rows" );
  if( tmp == NULL ) {
    fprintf( stderr, "printspec: could not find Row value\n" );
    exit( 1 );
  }
  rows = atoi( tmp );

  tmp = FindHeaderVal( hdr, "Columns" );
  if( tmp == NULL ) {
    fprintf( stderr, "printspec: could not find Column value\n" );
    exit( 1 );
  }
  cols = atoi( tmp );
  
  tmp = FindHeaderVal( hdr, "SamplesPerSecond" );
  if( tmp == NULL ) {
    fprintf(stderr,"printspec: could not find SamplesPerSecond value\n");
    exit( 1 );
  }
  rate = atof( tmp );

  for( i = 0; i < cols; i += COEFF_PER_LINE ) {
    
    printf( "     " );
    for( k = i; k < i + COEFF_PER_LINE; k++ ) {
      printf( "%4d", k );
    }
    printf( "\n" );

    printf( "     " );
    for( k = i; k < i + COEFF_PER_LINE; k++ ) {
      printf( "----" );
    }
    printf( "\n" );

    for( j = rows - 1; j >= 0; j-- ) {
      printf( "%4d:", (j * (((int)rate)/2) / (rows-1)) );
      for( k = i; k < i + COEFF_PER_LINE && k < cols; k++ ) {
	printf( "%4d", dft[k][j] );
      }

      printf( "\n" );
    }
    
    printf( "\n" );
  }
}


main(int argc, char **argv)
{
  AsciiHdr *header;
  char **data;			/* would char * give correct alignment?  */
  char *tmp, *type;
  int   rows, cols, i, j;

  get_comline(argc, argv);
  if (strcmp(InFileName, "-") == 0)
    infile = stdin;
  else
    if (!(infile = fopen(InFileName, "r"))) {
      fprintf(stderr, "fopen failed: %s\n", InFileName);
      exit(1);
    }

  /* retrieve tdat data structure */
  if(fTdatRead(infile ,&data, &header) < 0)
    {
      fprintf(stderr,"fTdatRead error: %s\n",ErrorString);
      exit(1);
    }
  
  tmp =  FindHeaderVal( header, "Rows" );
  if( tmp == NULL ) {
    fprintf( stderr, "tdat2ascii: could not find Row value\n" );
    exit( 1 );
  }
  rows = atoi( tmp );
  
  tmp = FindHeaderVal( header, "Columns" );
  if( tmp == NULL ) {
    fprintf( stderr, "tdat2ascii: could not find Column value\n" );
    exit( 1 );
  }
  cols = atoi( tmp );
  
  type = FindHeaderVal( header, "Type" );
  if( type == NULL ) {
    fprintf( stderr, "tdat2ascii: could not find Type value\n" );
    exit( 1 );
  }
  fclose(infile);

  /* write to output */
  if (strcmp(OutFileName, "-") == 0) 
    outfile = stdout;
  else
    if (!(outfile = fopen(OutFileName, "w"))) {
      fprintf(stderr, "outfile fopen faild: %s\n", OutFileName);
      exit(1);
    }

  if(!strcmp(type,"float"))
    {
      float **fdata;

      fdata = (float **)data;
      for(i = 0;i < cols;i++)
	for(j = 0;j < rows;j++)
	  {
	    fprintf(outfile, "%g\n",fdata[i][j]);
	  }
    }
  else if(!strcmp(type,"integer"))
    {
      int **idata;

      idata = (int **)data;
      for(i = 0;i < cols;i++)
	for(j = 0;j < rows;j++)
	  {
	    fprintf(outfile, "%d\n",idata[i][j]);
	  }
    }
  else if(!strcmp(type,"short"))
      PrintSpec((short **) data, header);
  else
    {
      fprintf(stderr,"unknown data type: %s\n",type);
      exit(1);
    }

  fclose(outfile);
}

