/*
 *
 * $Id: speech2mu.c,v 1.3 1993/06/10 17:22:29 johans Exp $
 *
 * wav2mu.c
 *
 */

/* Standard C libary include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

/* Speech library include file directives */
#include <speech.h>

/* external procedure header declarations */
unsigned char linear2ulaw(int sample);

/* global variable declarations */
char file[200]="-";                       /* Input file name / stdin      */
char mufile[200]="-";                     /* Output file name / stdout    */
int  dogain = 0;                         /* adjust gain on file          */

FILE *outfile;


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | speech2mu [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-g adjust gain before output\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:gh")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(file, optarg);
                break;

            case 'o':  /* output file */
		strcpy(mufile, optarg);
		break;

            case 'g': /* adjust gain of speech signal */
		dogain = 1;
		break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


main (int argc, char *argv[])
{
  unsigned char   ulaw;
  short  *wav_tmp;
  short  *wav;
  short  *a;
  short  maxwav = 0;
  char   *buf;
  FILE   *mup;
  int    i, c, shift;
  int    arg;
  int    len;
  float  rate;

  
  /* process args */
  get_comline(argc, argv);

  if (strcmp(mufile, "-") == 0)
    mup = stdout;
  else {
    if ((mup = fopen (mufile, "w")) == NULL) {
      fprintf (stderr, "speech2mu: %s: ", mufile);
      perror (NULL);
      exit (1);
    }
  }

  if( ( len = SpeechRead( file, &wav, &rate ) ) < 0) {
    fprintf (stderr, "speech2mu: %s: %s\n", file, ErrorString);
    exit (1);
  }

  /* 
   * If waveform file is 16kHz down-sample to 8kHz
   */
  if ( rate == 16000.0 ) {

    if (FiltByName ("0-25", wav, len, &wav_tmp ) < 0) {
      fprintf (stderr, "speech2mu: %s\n", ErrorString);
      exit (1);
    }

    len /= 2;
    
    for (i = 0; i < len; i++) {
      *(wav + i) = *(wav_tmp + i * 2);
    }
  }
  a = wav;
  for (i = 0; i < len; i++, a++) {
    if (abs (*a) > maxwav) {
      maxwav = abs (*a);
    }
  }
  
  if (dogain) {
    for (shift = 0; (maxwav << shift) < (1 << 12); shift++);
    for (; ((shift > 0) ? (maxwav << shift) : 
	    (maxwav >> -shift)) > (1 << 12); shift--);
    
    a = wav;
    
    if (shift > 0)
      for (i = 0; i < len; i++, a++)
	*a = *a << shift;
    else
      if (shift < 0)
	for (i = 0; i < len; i++, a++)
	  *a = *a >> -shift;
  }
  /* 
   * try to up stdio buffer
   */
  if ((buf = malloc (8 * 1024)) != NULL) {
    setbuf (mup, buf);
  }
  
  for (i = 0; i < len; i++) {
    ulaw = linear2ulaw ((int) (*(wav + i)));
    c = fwrite (&ulaw, sizeof (ulaw), 1, mup);
    
    if (c != 1) {
      perror ("wav2mu");
      fclose (mup);
      exit (1);
    }
  }
  
  fclose (mup);
}

