/* standard C include file directives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

/* Speech Libary include file directives */
#include <speech.h>


/* global variable declarations */
char InFileName[200]="-";                 /* Input file name / stdin      */
char OutFileName[200]="-";                /* Output file name / stdout    */


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | halfrate [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:h")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(InFileName, optarg);
                break;

            case 'o':  /* output file */
		strcpy(OutFileName, optarg);
		break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}


main(int argc, char *argv[] )
{
	short *wav_tmp;
	short *wav;
	int len;
	float rate;
	int i;

	get_comline(argc, argv);

	if( ( len = SpeechRead(InFileName, &wav, &rate ) ) < 0 ) {
		fprintf( stderr, "%s: %s: %s\n", argv[0], 
						argv[1], ErrorString );
		exit( 1 );
	}

	FiltByName( "0-25", wav, len, &wav_tmp );

	len /= 2;
	rate /= 2.0;

	for( i = 0; i < len; i++ ) {
		*(wav+i) = *(wav_tmp + i*2);
	}

	if( WavWrite(OutFileName, wav, len, (int)rate, 0 ) < 0 ) {
		fprintf( stderr, "%s: %s: %s\n", argv[0], 
						argv[1], ErrorString );
		exit( 1 );
	}
}

