/*
 * $Id: filter.c,v 1.12 1993/09/11 19:23:48 johans Exp $
 *
 *
 * filter.c
 *
 */

/* Standard C library include file dirctives */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Speech include file directives */
#include <speech.h>

/* global variable declarations */
char InFileName[200]="-";                 /* Input file name / stdin      */
char OutFileName[200]="-";                /* Output file name / stdout    */
char FilterName[200]="0-075";             /* speech filter name           */
int  start=0;                             /* starting location            */
int  stop=0;                              /* end point in display         */
int  infoflag=0;                         /* print information as well    */

FILE *outfile;


/*
 * usage()
 *
 * display usage paramters on screen
 *
 */

void usage() 
{
  fprintf(stderr, "Usage: <stdin> | filter [options] | <stdout>\n");
  fprintf(stderr, "\n");
  fprintf(stderr, "Where options can be any of the following:\n");
  fprintf(stderr, "-f input file name [stdin]\n");
  fprintf(stderr, "-o output file name [stdout]\n");
  fprintf(stderr, "-n filtername [0-075]\n");
  fprintf(stderr, "-h This help message\n");
  exit(1);
}


/*
 * get_comline(int argc, char **argv)
 *
 * read and interpret command line
 *
 */

void get_comline(int argc, char **argv)
{
  int c;
  extern int optind;
  extern char *optarg;

  while( (c = getopt( argc, argv, "f:o:n:h")) != -1 )
    {
        switch( c )
        {
            case 'f':  /* input file */
                strcpy(InFileName, optarg);
                break;

            case 'o':  /* output file */
		strcpy(OutFileName, optarg);
		break;

            case 'n': /* filter name */
		strcpy(FilterName, optarg);
		break;

            case 'i':/* infomation request */
                infoflag = 1;
                break;

	    case 'h': /* help */
            default:
		usage();
                break;
        }
    }
}

main(int argc, char **argv)
{
  int len;
  float rate;
  short *wavfilt;
  short *wav;

  get_comline(argc, argv);

  if( (len = SpeechRead(InFileName, &wav, &rate ) ) < 0 ) {
    fprintf( stderr, "filter: %s: %s\n", argv[1], ErrorString );
    exit(1);
  }

  if( FiltByName(FilterName, wav, len, &wavfilt ) < 0 ) {
    fprintf( stderr, "filter: %s\n", ErrorString );
    exit(1);
  }

  if( WavWrite(OutFileName, wavfilt, len, (int)rate, 0 ) < 0 ) {
    fprintf( stderr, "filter: %s: %s\n", argv[3], ErrorString );
    exit(1);
  }

  exit( 0 );
}
