/*
 * $Id: autogain.c,v 1.7 92/04/07 15:07:41 pochmara Exp Locker: fanty $
 *
 * autogain.c
 *
 */

/* Standard C library include file directives */
#include <stdio.h>
#include <stdlib.h>

/* Speech library include file directives */
#include <speech.h>

static void usage();

main(int argc, char *argv[] )
{
	short *wav, *a;
	int len;
	float rate;
	int maxwav = 0;
	int i, shift;

	if( argc != 3 ) {
		usage();
		exit(1);
	}

	if( ( len = SpeechRead( argv[1], &wav, &rate ) ) < 0 ) {
		fprintf( stderr, "autogain: %s: %s\n", argv[1], ErrorString );
		exit(1);
	}

	a = wav;

	for( i = 0; i < len; i++, a++ ) {
		if( abs( *a ) > maxwav ) {
			maxwav = abs( *a );
		}
	}

	for( shift = 0; ( maxwav << shift ) < ( 1<<12 ); shift++ );
	for( ; ((shift > 0) ? ( maxwav << shift ) : 
		(maxwav >> -shift)) > ( 1<<12 ); shift-- );

	a = wav;

	if(shift > 0)
	  for( i = 0; i < len; i++, a++ ) {
	    *a = *a << shift;
	  }
	else
	  for( i = 0; i < len; i++, a++ ) {
	    *a = *a >> -shift;
	  }
	if( WavWrite( argv[2], wav, len, (int)rate, 1 ) < 0 ) {
		fprintf( stderr, "autogain: %s: %s", argv[2], ErrorString );
		exit(1);
	}

	exit( 0 );
}       

static void usage()
{
	fprintf( stderr, "usage: autogain <file_in> <wavfile_out>\n" );
}

