
/* Standard C library include file directives */
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

/* speech library include file directives */
#include <adata.h>
#include <speech.h>

#define INT	(1)
#define SHORT	(2)
#define FLOAT	(3)


/* private procedure header declaration */
static void FillInt (int **src, float *dst, int col, int row, float *pmin_p, 
		    float *pmax_p, float *nmin_p, float *nmax_p );

static void FillShort ( short **src, float *dst, int col, int row, 
		      float *pmin_p, float *pmax_p, float *nmin_p, 
		      float *nmax_p );

static void FillFloat (float **src, float *dst, int col, int row, 
		      float *pmin_p, float *pmax_p, float *nmin_p, 
		      float *nmax_p );


/*
 * xxx2adata (adata, offsetsP, data, header)
 *
 * adata    (out): Poiner to an adata_t which will be initialized
 * offsetsP (out): Pointer to a Pointer for the offset vector which is
 *                 allocated byt this subroutine
 * data      (in):
 * header    (in):
 */

void xxx2adata (adata_t *adata, int **offsetsP, char **data, 
		AsciiHdr *header)
{
	int i, j;
	float  *sp;
	char   **cp;
	int    *offsets;
	char   *tmp;
	double samps;
	double win, inc;
	int    dtype;
	int    **di;
	short  **ds;
	float  **df;
	

    /*
	offsets = *offsetsP = (int *) malloc (sizeof (int) * nframe);

     * Set ns_per_col to 0 if the file format doesn't tel us the correct value.
     * It will be up to someone else to fill this in.
     */


	offsets = *offsetsP = NULL;

	tmp = FindHeaderVal( header, "Rows" );
	adata->rows = atoi( tmp );

	tmp = FindHeaderVal( header, "Columns" );
	adata->cols = atoi( tmp );

	tmp = FindHeaderVal( header, "Type" );

	if( strcasecmp( tmp, "integer" ) == 0 ) {
		dtype = INT;
	} else if( strcasecmp( tmp, "short" ) == 0 ) {
		dtype = SHORT;
	} else if( strcasecmp( tmp, "float" ) == 0 ) {
		dtype = FLOAT;
	}

	tmp = FindHeaderVal( header, "SamplesPerSecond" );
	if( tmp == NULL ) {
		samps = 8000.0;	/* assume 8kHz sampling rate */
	} else {
		samps = (float) atof( tmp );
	}

	tmp = FindHeaderVal( header, "WindowWidth" );
	if( tmp == NULL ) {
		win = 10.0;
	} else {
		win = (float) atof( tmp );
	}

	tmp = FindHeaderVal( header, "Increment" );
	if( tmp == NULL ) {
		inc = 3.0;
	} else {
		inc = (float) atof( tmp );
	}

	adata->ns_per_col = (int) ( 1.0e6 * inc );

	adata->count = adata->rows * adata->cols;
	adata->col_time = NULL;

	adata->ptr = (float *)malloc( sizeof(float) * adata->count );

	sp = adata->ptr;

	switch( dtype ) {

	case INT:
	  FillInt( (int **)data, sp, adata->cols, adata->rows,
		  &(adata->pos_min_val), &(adata->pos_max_val),
		  &(adata->neg_min_val), &(adata->neg_max_val) );
	  break;

	case SHORT:
	  FillShort((short **)data, sp, adata->cols, adata->rows,
		    &(adata->pos_min_val), &(adata->pos_max_val),
		    &(adata->neg_min_val), &(adata->neg_max_val));
	  break;

	case FLOAT:
	  FillFloat((float **)data, sp, adata->cols, adata->rows,
		    &(adata->pos_min_val), &(adata->pos_max_val),
		    &(adata->neg_min_val), &(adata->neg_max_val));
	  break;
	}

}


/*
 * static void FillInt( src, dst, col, row, pmin_p, pmax_p, nmin_p, nmax_p )
 *
 */

static void FillInt(int **src, float *dst, int col, int row, float *pmin_p, 
		    float *pmax_p, float *nmin_p, float *nmax_p )
{
	int i,j;

	*pmin_p = (float) 0.0;
	*pmax_p = (float) 0.0;
	*nmin_p = (float) 0.0;
	*nmax_p = (float) 0.0;

	for( i = 0; i < col; i++ ) {
		for( j = 0; j < row; j++, dst++ ) {
			*dst = (float) src[i][j];
			if(*dst >= 0)
			  {
			    if(*dst > *pmax_p) *pmax_p = *dst;
			    if(*dst < *pmin_p) *pmin_p = *dst;
			  }
			else
			  {
			    if(*dst > *nmax_p) *nmax_p = *dst;
			    if(*dst < *nmin_p) *nmin_p = *dst;
			  }
		}
	}
}


/*
 * static void FillShort( src, dst, col, row, pmin_p, pmax_p, nmin_p, nmax_p )
 *
 */

static void FillShort( short **src, float *dst, int col, int row, 
		      float *pmin_p, float *pmax_p, float *nmin_p, 
		      float *nmax_p )
{
	int i,j;

	*pmin_p = (float) 0.0;
	*pmax_p = (float) 0.0;
	*nmin_p = (float) 0.0;
	*nmax_p = (float) 0.0;

	for( i = 0; i < col; i++ ) {
		for( j = 0; j < row; j++,dst++ ) {
			*dst = (float) src[i][j];
			if(*dst >= 0)
			  {
			    if(*dst > *pmax_p) *pmax_p = *dst;
			    if(*dst < *pmin_p) *pmin_p = *dst;
			  }
			else
			  {
			    if(*dst > *nmax_p) *nmax_p = *dst;
			    if(*dst < *nmin_p) *nmin_p = *dst;
			  }
		}
	}
}


/*
 * static void FillFloat( src, dst, col, row, pmin_p, pmax_p, nmin_p, nmax_p )
 *
 */

static void FillFloat(float **src, float *dst, int col, int row, 
		      float *pmin_p, float *pmax_p, float *nmin_p, 
		      float *nmax_p )
{
	int i,j;

	*pmin_p = (float) 0.0;
	*pmax_p = (float) 0.0;
	*nmin_p = (float) 0.0;
	*nmax_p = (float) 0.0;

	for( i = 0; i < col; i++ ) {
		for( j = 0; j < row; j++, dst++ ) {
			*dst = (float) src[i][j];
			if(*dst >= 0)
			  {
			    if(*dst > *pmax_p) *pmax_p = *dst;
			    if(*dst < *pmin_p) *pmin_p = *dst;
			  }
			else
			  {
			    if(*dst > *nmax_p) *nmax_p = *dst;
			    if(*dst < *nmin_p) *nmin_p = *dst;
			  }
		}
	}
}
