static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/ascii_ld_rw.c,v 4.2 1993/05/27 21:13:44 johans Exp $";

/*
 * ASCII_LD_RW.C - read/write ascii int decimal
 *------------------------------------------------------------*
 * DESCRIPTION
 * 	Read/Write ascii files of int decimal numbers. Each token
 * is new-line terminated.
 *
 * HISTORY
 *  16-Apr-93 Johan Schalkwyk at Oregon graduate institute changed 
 *  to ANSI style header declarations
 *
 */

/* standard C library include file directives */
#include <sys/file.h>
#include <stdio.h>
#include <string.h>


/*
 * ascii_ld_read (path, file, buf, size, count)
 *
 */

ascii_ld_read (char *path, char *file, int **buf, int *size, int *count)
{
    static char        *rname = "ascii_ld_read";
    FILE               *fs;
    char                line[64];
    register int      *ptr;
    register int        cnt;

    if ( ( fs = fopen( file, "r") ) == NULL ) {
	fprintf (stderr, "%s: Couldn't open %s\n", rname, file);
	return (-1);
    }

    /*
     * Count the number of data points in the file. 
     */
    for (cnt = 0; fgets (line, 64, fs) != NULL;)
	if (line[0] != '#')
	    cnt++;

    /*
     * allocate room the number of lines just counted 
     */
    ptr = (int *) calloc (cnt, sizeof (int));
    if (buf)
	*buf = ptr;

    /*
     * start at beginning of file and get the data 
     */
    rewind (fs);
    for (; fgets (line, 64, fs) != NULL;) {
	if (line[0] != '#') {
	    sscanf (line, "%d", ptr);
	    ptr++;
	}
    }

    fclose (fs);
    if (size)
	*size = 4;
    if (count)
	*count = cnt;
    return (0);
}


/*
 * ascii_ld_write (filename, buf, size, cnt)
 *
 */

ascii_ld_write (char *filename, char *buf, int size, int cnt)
{
    static char *rname = "ascii_ld_write";
    FILE *fs;
    register int i;
    register char *cptr;
    register short *sptr;
    register int *lptr;

    fs = fopen (filename, "w");
    if (fs == NULL) {
	fprintf (stderr, "%s: Couldn't open %s\n", rname, filename);
	return (-1);
    }

    cptr = (char *) buf;
    sptr = (short *) buf;
    lptr = (int *) buf;

    switch (size) {
	case 1:
		for (i = 0; i < cnt; i++) {
		    fprintf (fs, "%d\n", *cptr++);
		}
		break;
	case 2:
		for (i = 0; i < cnt; i++) {
		    fprintf (fs, "%d\n", *sptr++);
		}
		break;
	case 4:
		for (i = 0; i < cnt; i++) {
		    fprintf (fs, "%d\n", *lptr++);
		}
		break;
	default:
		fprintf (stderr, "%s: base token size = %d\n", rname, size);
		return (-1);
    }
    fclose (fs);
    return (0);
}

