/* YokeP.h - Private definitions for Adc tool widget
 *------------------------------------------------------------*
 * Copyright 1989, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 */

#ifndef _XtYoketP_h
#define _XtYoketP_h

#include <Yoke.h>
#include <X11/Xaw/FormP.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>

#include <LScroll.h>

typedef struct _YokeClass 
{
    int makes_compiler_happy;	/* not used */
} YokeClassPart;

typedef struct _YokeClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    FormClassPart       form_class;
    YokeClassPart    yoke_class;
}                   YokeClassRec;

extern YokeClassRec yokeClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

/* New fields for the Yoke widget record */
typedef struct {
    /* resources */
    PanedWidget	        pane;
    LScrollWidget	scroll;
    FormWidget		control;
    Widget		control_bw; /* bottom widget in control */
    XtCallbackList      callbacks;
    WidgetList		widgets;
    int			widget_count;
    Position            lastx;
    Boolean             trackingOn;
    String		config;
    String		base_name;
    float               timeDuration;      /* time Duration of unifing widget, usually
					    * the waveform
					    */
}                   YokePart;


/* Full widget declaration */
typedef struct _YokeRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    FormPart            form;
    YokePart         yoke;
}                   YokeRec;

typedef struct _YokeConstraintsPart
{
    int makes_compiler_happy;	/* not used */
} YokeConstraintsPart;

typedef struct _YokeConstraintsRec {
    FormConstraintsPart		form;    
    YokeConstraintsPart	yoke;
} YokeConstraintsRec, *YokeConstraints;

#endif _XtYokeP_h
