static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/Yoke.c,v 4.7 1993/05/28 21:27:40 johans Exp $";

/*
 * Yoke.c - Yoke widget
 *------------------------------------------------------------*
 * HISTORY
 * Sep 6, 1989 Fil Alleva
 *    Changed Add*Tool to return a pointer to the new widget
 *
 * Mar 8, 1989 Fil Alleva
 *    Added AddCochleagram()
 *
 * 25-March-1993 Johan Schalkwyk at Oregon Graduate Institute
 *         made stylistic changes, added lots and lots of comments
 *         and made the overall code more robust
 *         Changed headers to ANSI style
 *
 */

/* Standard C library include file directives */
#include <stdio.h>
#include <sys/types.h>		/* for stat() */
#include <sys/stat.h>		/* for stat() */
#include <ctype.h>
#include <math.h>

/* X library include file directives */
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xaw/CommandP.h>
#include <X11/Xaw/DialogP.h>
#include <X11/Xaw/Label.h>

/* Lyre include file directives */
#include <Adctool.h>
#include <Gspectool.h>
#include <Lgraph.h>
#include <Lspectool.h>
#include <Lolatool.h>
#include <Tsdtool.h>
#include <LScroll.h>
#include <LyreDisp.h>
#include <LyreDispP.h>
#include <YokeP.h>
#include <c.h>
#include <ad.h>


/*
 * PollStuff - data structure used by PollDataFiles and created by
 *             the Add*Widget Routines
 */

struct {
  int (*PollDataFunc)();
  int (*PollMapFunc)();
  int (*PollUnmapFunc)();
  char suffix[30];
  Widget widget;
  time_t mtime;
} PollStuff[100];

int PollStuffCount = 0;

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* external procedure declarations */
int    AdcUnmap(AdctoolWidget tool);
int    AdcMap (AdctoolWidget tool);
int    AdcPollRead (AdctoolWidget tool, char *file);
int    MarkUnmap (AdctoolWidget tool);
int    MarkMap (AdctoolWidget tool);
int    MarkPollRead (AdctoolWidget tool, char *file);

int GspecPollRead (GspectoolWidget tool, char *file);
int LspecPollRead (LspectoolWidget tool, char *file);
int LolaPollRead (LolatoolWidget tool, char *file);
int LabelPollRead(Widget label, char *file);

int LabelMap(Widget label);
int LabelUnmap(Widget label);
int GspecUnmap( GspectoolWidget tool);
int GspecMap(GspectoolWidget tool);
int LspecUnmap(LspectoolWidget tool);
int LspecMap(LspectoolWidget tool);
int LolaUnmap(LolatoolWidget tool);
int LolaMap(LolatoolWidget tool);

void LScrollSet (Widget sw, float percent);
void LScroll (Widget sw, float percent_change);
Widget AddLineogram ();


/* private procedure header declarations */
Widget AddPollLineogram (YokeWidget yoke, int height, char *suf);
Widget AddPollWaveform (YokeWidget yoke, int height, char *suf,
		       int pitch_flag);
Widget AddWaveform (Widget w, caddr_t client_data, caddr_t call_data);
Widget AddPollSpectrogram (YokeWidget yoke, int height, char *suf);
Widget AddSpectrogram (Widget w, caddr_t client_data, caddr_t call_data);
Widget AddPollLola (YokeWidget yoke, int height, char *suf);
Widget AddLola (Widget w, caddr_t client_data, caddr_t call_data);

void PollDataFiles (caddr_t client_data);

static void Initialize (Widget request_in, Widget new_in, ArgList arglist,
			Cardinal *num_args);
static void YokeAddWidget (YokeWidget yoke, Widget child);
static void YokeDeleteWidget (Widget w, YokeWidget yw);
static void PollDeleteWidget (Widget w, YokeWidget yoke);
static void SetGlobalResolution (Widget w, WidgetList client_data);


Boolean	defFALSE = FALSE;

static float floatZero = 0.0;

#define offset(field) XtOffset(YokeWidget, field)
static XtResource resources[] = { 
   {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t), 
      offset(yoke.callbacks), XtRCallback, (caddr_t)NULL},
   {XtNconfig, XtCParameter, XtRString, sizeof(XtRString),
      offset(yoke.config), XtRString, (caddr_t)NULL},
   {XtNbaseName, XtCParameter, XtRString, sizeof(XtRString),
      offset(yoke.base_name), XtRString, (caddr_t) "test"},
   {XtNtimeDuration, XtCParameter, XtRFloat, sizeof(float),
      offset(yoke.timeDuration), XtRString, (caddr_t) "0.0"},
};
#undef offset

YokeClassRec yokeClassRec = {
  {
    (WidgetClass) &formClassRec,	/* superclass		  */	
    "Yoke",				/* class_name		  */
    sizeof(YokeRec),			/* size			  */
    NULL,				/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,				        /* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    NULL,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,		        	/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL,				/* extension		  */
  },  /* CoreClass fields initialization */
  { /* composite_class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   XtInheritChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
  },
  { /* constraint_class fields */
    /* subresourses       */   NULL,
    /* subresource_count  */   0,
    /* constraint_size    */   sizeof(YokeConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL
  },
  {
    0,
  }, /* FormClass fields */
  {
    0,                                     /* field not used    */
  },  /* YokeClass fields initialization */
};

/* for public consumption */
WidgetClass yokeWidgetClass = (WidgetClass) &yokeClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

#define MyXtSetArg(args,i,arg,val)	{XtSetArg (args[i], arg, val); i++;}


typedef struct _appdata {
  float secsppix;
} AppData,*AppDataPtr;

static XtResource someresources[] = {
    {XtNsecsPpix, XtNsecsPpix, XtRFloat, sizeof(float),
       XtOffset(AppDataPtr,secsppix), XtRString, "0.001"}
  };


/*
 * static void Initialize (request, new)
 *
 * Inilitiaze yoke widget --> graphics drawing widget
 *
 */

static void Initialize (Widget request_in, Widget new_in, ArgList arglist,
			Cardinal *num_args)
{
    YokeWidget (request) = (YokeWidget) request_in;
    YokeWidget (new)     = (YokeWidget) new_in;
    Widget w, control, pane, bw, scroll, tmpw;
    Arg    args[20];
    int    arg_cnt;
    AppData appdata;
    char buf[64];

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNleft, XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright, XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNtop, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
    MyXtSetArg (args, arg_cnt, XtNheight, 200);
    MyXtSetArg (args, arg_cnt, XtNwidth, 500);
    pane = XtCreateManagedWidget ("paned", panedWidgetClass, (Widget) new,
		args, arg_cnt);
    new->yoke.pane = (PanedWidget) pane;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromHoriz, pane);
    MyXtSetArg (args, arg_cnt, XtNleft,   XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNright,  XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNresizable, TRUE);
    MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
    control = XtCreateManagedWidget ("controls", formWidgetClass,
					   (Widget) new, args, arg_cnt);
    new->yoke.control = (FormWidget) control;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
    MyXtSetArg (args, arg_cnt, XtNskipAdjust, TRUE);
    MyXtSetArg (args, arg_cnt, XtNmin, 14);
    MyXtSetArg (args, arg_cnt, XtNmax, 14);
    tmpw = XtCreateManagedWidget ("scrollform", formWidgetClass,
					   pane, args, arg_cnt);
    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNhorizDistance, 130);
    MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright,  XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
    scroll = XtCreateManagedWidget ("scroll", lscrollWidgetClass, tmpw,
			        args, arg_cnt);
    new->yoke.scroll = (LScrollWidget) scroll;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Yoke");
    bw = XtCreateManagedWidget ("title", labelWidgetClass, control, 
				args, arg_cnt);

/*
 * The interactive creation of windows is not integrated with the
 *  config-string creation, so I am commenting out the buttons.  Probably
 *  all that needs to be done is to add the newly created window widget
 *  and a suffix to the Poll list of the Yoke.  mf 9/11/89 
 */

#if 0
    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Waveform");
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, AddWaveform, new);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Spectrogram");
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, AddSpectrogram, new);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Lineogram");
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, AddLineogram, new);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Lola");
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, AddLola, new);
#endif

    /*
     * I don't want this button anymore,  but  when I  take it out, the
     *  answer widget does  not appear ??  For the  demo, I am leaving it
     *  in unmapped. 
     */

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Poll Data");
    MyXtSetArg (args, arg_cnt, XtNmappedWhenManaged, False);
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				(Widget) control, args, arg_cnt);
    XtAddCallback (bw, XtNcallback, (XtCallbackProc) PollDataFiles, new);

    XtGetApplicationResources((Widget) new, &appdata, someresources,
			      XtNumber(someresources),NULL,0);
    sprintf(buf,"%f",appdata.secsppix);

    /* global resolution button */
    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNlabel, "Global\nResolution");
    MyXtSetArg (args, arg_cnt, XtNfromVert, bw);
    bw = XtCreateManagedWidget ("button", commandWidgetClass,
				control, args, arg_cnt);
    MakePopup (new, bw, NULL,
	       "Seconds per pixel:", buf , "Set", "Abort",
	       SetGlobalResolution);

    new->yoke.control_bw = bw;
    new->yoke.widgets = NULL;
    new->yoke.widget_count = 0;
}


/*
 * Widget AddPollWaveform(yoke, height, suf, pitch_flag)
 *
 * Used for auto_lyre, polls the disc for the lates waveform file
 * and updates the polled waveform widget
 *
 */


Widget AddPollWaveform(YokeWidget yoke, int height, char *suf,
		       int pitch_flag)
{
    Widget Waveform;
    Arg    args[10];
    int arg_cnt;
    int	min_height = 128;

    if (height != 0)
	min_height = height;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNmin, min_height);
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    MyXtSetArg (args, arg_cnt, XtNallowResize, TRUE);
    MyXtSetArg (args, arg_cnt, XtNmarkOn, pitch_flag);
    MyXtSetArg (args, arg_cnt, XtNlyreLabel, suf);
    Waveform = XtCreateManagedWidget ("waveform", adctoolWidgetClass,
				  (Widget) yoke->yoke.pane, args, arg_cnt);
    PollStuff[PollStuffCount].widget = Waveform;
    PollStuff[PollStuffCount].mtime = 0;
    strcpy(PollStuff[PollStuffCount].suffix,suf);
    PollStuff[PollStuffCount].PollMapFunc = AdcMap;
    PollStuff[PollStuffCount].PollUnmapFunc = AdcUnmap;
    PollStuff[PollStuffCount++].PollDataFunc = AdcPollRead;

    XtAddCallback (Waveform, XtNdestroyCallback, 
		   (XtCallbackProc) PollDeleteWidget,  yoke);
    /* must poll for pitch marks too; for now, suffix is fixed */
    
    if(pitch_flag == TRUE)
      {
	PollStuff[PollStuffCount].widget = Waveform; /* pass adctool parent */
	strcpy(PollStuff[PollStuffCount].suffix,"pitch");
	PollStuff[PollStuffCount].PollMapFunc = MarkMap;
	PollStuff[PollStuffCount].PollUnmapFunc = MarkUnmap;
	PollStuff[PollStuffCount++].PollDataFunc = MarkPollRead;
      }
    
    {
	Widget              child, mark = 0, scale;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNchild, &child);
	MyXtSetArg (args, arg_cnt, XtNmark, &mark);
	XtGetValues (Waveform, args, arg_cnt);

	XtAddCallback (child, XtNwidthProc, 
		       (XtCallbackProc) LScrollSetWidgetVirtualWidth,
		       yoke->yoke.scroll);
	XtAddCallback (child, XtNdestroyCallback, 
		       (XtCallbackProc) LScrollDeleteWidget,
		       yoke->yoke.scroll);
	XtAddCallback (mark, XtNdestroyCallback, 
		       (XtCallbackProc) LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) child, (LScrollWidget) yoke->yoke.scroll);
	LScrollAddWidget ((Widget) mark, (LScrollWidget) yoke->yoke.scroll);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhscaleWidget, &scale);
	XtGetValues (child, args, arg_cnt);
	if(scale) {
	  XtAddCallback (scale, XtNdestroyCallback, 
			 (XtCallbackProc) LScrollDeleteWidget,
			 yoke->yoke.scroll);
	  LScrollAddWidget ((Widget) scale, (LScrollWidget) yoke->yoke.scroll);
	}

	YokeAddWidget (yoke, child);
    }
    return (Waveform);
}


/*
 * Widget AddWaveform (w, client_data, call_data)
 *
 * Add waveform to yoke widget -> wave file, similar to add poll waveform
 * except that file is not polled but entered in manually via Adc-tool
 *
 */

Widget AddWaveform (Widget w, caddr_t client_data, caddr_t call_data)
{
  /* button callback does not really fit into auto scheme now */
  return AddPollWaveform((YokeWidget) client_data,(int) call_data,
			 NULL,TRUE);
}


/*
 * Widget AddPollSpectrogram (yoke,height,suf)
 *
 *  Add the spectrogram associated with the particular waveform
 * Similar to waveform polls data from disc.
 *
 */

Widget AddPollSpectrogram (YokeWidget yoke, int height, char *suf)
{
    Widget SpecW;
    Arg    args[10];
    int arg_cnt;
    int	min_height = 128;

    if (height != 0)
	min_height = height;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNmin, min_height);
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    MyXtSetArg (args, arg_cnt, XtNallowResize, TRUE);
    MyXtSetArg (args, arg_cnt, XtNlyreLabel, suf);
    SpecW = XtCreateManagedWidget ("tdat", gspectoolWidgetClass,
				  (Widget) yoke->yoke.pane, args, arg_cnt);
    PollStuff[PollStuffCount].widget = SpecW;
    PollStuff[PollStuffCount].mtime = 0;
    strcpy(PollStuff[PollStuffCount].suffix, suf);
    PollStuff[PollStuffCount].PollMapFunc = GspecMap;
    PollStuff[PollStuffCount].PollUnmapFunc = GspecUnmap;
    PollStuff[PollStuffCount++].PollDataFunc = GspecPollRead;

    XtAddCallback (SpecW, XtNdestroyCallback, 
		   (XtCallbackProc) PollDeleteWidget,  yoke);
    {
	Widget              child, scale;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNchild, &child);
	XtGetValues (SpecW, args, arg_cnt);
	XtAddCallback (child, XtNwidthProc, 
		       (XtCallbackProc) LScrollSetWidgetVirtualWidth,
		       yoke->yoke.scroll);
	XtAddCallback (child, XtNdestroyCallback, 
		       (XtCallbackProc) LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) child, (LScrollWidget) yoke->yoke.scroll);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhscaleWidget, &scale);
	XtGetValues (child, args, arg_cnt);
	if (scale) {
	  XtAddCallback (scale, XtNdestroyCallback, 
			 (XtCallbackProc) LScrollDeleteWidget,
			 yoke->yoke.scroll);
	  LScrollAddWidget ((Widget) scale, (LScrollWidget) yoke->yoke.scroll);
	}
	YokeAddWidget (yoke, child);
    }
    return (SpecW);
}


/*
 * Widget AddSpectrogram (w, client_data, call_data)
 *
 * Adds spectrogram to yoke widget, associated with waveform file,
 * but does not poll disc for spectrogram data
 *
 */

Widget AddSpectrogram (Widget w, caddr_t client_data, caddr_t call_data)
{
  return AddPollSpectrogram((YokeWidget) client_data,(int) call_data,"");
}


#if 0

/*
 * Widget AddPollLineogram (yoke,height,suf)
 *
 */

Widget AddPollLineogram (YokeWidget yoke, int height, char *suf)
{
    Widget LspecW;
    Arg    args[10];
    int arg_cnt;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNmin, height);
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    LspecW = XtCreateManagedWidget ("lineogram", lspectoolWidgetClass,
				  yoke->yoke.pane, args, arg_cnt);
    PollStuff[PollStuffCount].widget = LspecW;
    PollStuff[PollStuffCount].mtime = 0;
    strcpy(PollStuff[PollStuffCount].suffix, suf);
    PollStuff[PollStuffCount].PollMapFunc = LspecMap;
    PollStuff[PollStuffCount].PollUnmapFunc = LspecUnmap;
    PollStuff[PollStuffCount++].PollDataFunc = LspecPollRead;
    {
	Widget              scale, child;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNchild, &child);
	XtGetValues (LspecW, args, arg_cnt);
	XtAddCallback (child, XtNwidthProc, LScrollSetWidgetVirtualWidth,
		       yoke->yoke.scroll);
	XtAddCallback (child, XtNdestroyCallback, LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) child, (LScrollWidget) yoke->yoke.scroll);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhscaleWidget, &scale);
	XtGetValues (child, args, arg_cnt);
	XtAddCallback (scale, XtNdestroyCallback, LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) scale, (LScrollWidget) yoke->yoke.scroll);

	YokeAddWidget (yoke, child);
    }
    return (LspecW);
}
#endif


/*
 * Widget AddPollLola (yoke, height, suf)
 *
 * Poll disc for lola file, and add lola widget to yoke, display 
 * lola labels.
 *
 */

Widget AddPollLola (YokeWidget yoke, int height, char *suf)
{
    Widget LolaW;
    Arg    args[10];
    int arg_cnt;
    int	min_height = 64;

    if (height != 0)
	min_height = height;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNmin, min_height);
    MyXtSetArg (args, arg_cnt, XtNdefaultDistance, 0);
    MyXtSetArg (args, arg_cnt, XtNlyreLabel, suf);
    LolaW = XtCreateManagedWidget ("lola", lolatoolWidgetClass,
				  (Widget) yoke->yoke.pane, args, arg_cnt);
    PollStuff[PollStuffCount].widget = LolaW;
    PollStuff[PollStuffCount].mtime = 0;
    strcpy(PollStuff[PollStuffCount].suffix,suf);
    PollStuff[PollStuffCount].PollMapFunc = LolaMap;
    PollStuff[PollStuffCount].PollUnmapFunc = LolaUnmap;
    PollStuff[PollStuffCount++].PollDataFunc = LolaPollRead;

    XtAddCallback (LolaW, XtNdestroyCallback, 
		   (XtCallbackProc) PollDeleteWidget, yoke);
    {
	Widget              scale, child;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNchild, &child);
	XtGetValues (LolaW, args, arg_cnt);
	XtAddCallback (child, XtNwidthProc, 
		       (XtCallbackProc) LScrollSetWidgetVirtualWidth,
		       yoke->yoke.scroll);
	XtAddCallback (child, XtNdestroyCallback, 
		       (XtCallbackProc) LScrollDeleteWidget,
		       yoke->yoke.scroll);
	LScrollAddWidget ((Widget) child, (LScrollWidget) yoke->yoke.scroll);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhscaleWidget, &scale);
	XtGetValues (child, args, arg_cnt);
	if (scale) {
	  XtAddCallback (scale, XtNdestroyCallback, 
			 (XtCallbackProc) LScrollDeleteWidget,
			 yoke->yoke.scroll);
	  LScrollAddWidget ((Widget) scale, (LScrollWidget) yoke->yoke.scroll);
	}
	YokeAddWidget (yoke, child);
    }
    return (LolaW);
}


/*
 * Widget AddLola (w, client_data, call_data)
 *
 * Similar to AddPollLola, but does not poll disc for latest lola label
 * file. Adds a lola widget on request.
 *
 */

Widget AddLola (Widget w, caddr_t client_data, caddr_t call_data)
{
  return AddPollLola((YokeWidget) client_data, (int) call_data, "");
}


/*
 * static void YokeAddWidget (yoke, child)
 *
 */

static void YokeAddWidget (YokeWidget yoke, Widget child)
{
    int                 arg_cnt;
    Arg                 args[10];

    yoke->yoke.widget_count++;
    yoke->yoke.widgets = (WidgetList) XtRealloc ((char *) yoke->yoke.widgets,
				  sizeof (Widget) * yoke->yoke.widget_count);
    yoke->yoke.widgets[yoke->yoke.widget_count - 1] = child;
    XtAddCallback (child, XtNdestroyCallback, 
		   (XtCallbackProc) YokeDeleteWidget, yoke);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNscrollWidget, yoke->yoke.scroll);
    MyXtSetArg (args, arg_cnt, XtNyokeWidget, yoke);
    XtSetValues (child, args, arg_cnt);
}


/*
 * static void YokeDeleteWidget  (w, yw)
 *
 */

static void YokeDeleteWidget  (Widget w, YokeWidget yw)
{
  WidgetList wltmp = (WidgetList) XtMalloc (sizeof(Widget)
					    * yw->yoke.widget_count);
  register int i, j;
  
  for (j = 0, i = 0; i < yw->yoke.widget_count; i++) {
    if (yw->yoke.widgets[i] != w)
      wltmp[j++] = yw->yoke.widgets[i];
  }
  if (j == i)
    fprintf (stderr, "YokeDeleteWidget: Warning widget not found\n");
  XtFree ((char *) yw->yoke.widgets);
  yw->yoke.widgets = wltmp;
  yw->yoke.widget_count--;
  
}


/* 
 * LabelUnmap(label)
 *
 * answer label routines 
 *
 */

int LabelUnmap(Widget label)
{
  XtUnmapWidget(label);
}


/*
 * LabelMap(label)
 *
 */

int LabelMap(Widget label)
{
  XtMapWidget(label);
}


/*
 * int LabelPollRead(label,file)
 *
 */

int LabelPollRead(Widget label, char *file)
{
  FILE *fp;
  char buf[50];
  int arg_cnt = 0;
  Arg args[10];

  if(PollForFile (file, 1 /* Interval secs */, 1 /* Attempts */) == -1)
     return -1;
  strcpy(buf,"?");
  if((fp = fopen(file,"r")) != NULL)
    fscanf(fp,"%s",buf);
  fclose(fp);
  MyXtSetArg (args, arg_cnt, XtNlabel, buf);
  XtSetValues(label,args,arg_cnt);
  return 0;
}


/* 
 * static void PollDeleteWidget(w,yoke)
 *
 * Poll Data Files 
 *
 *     This routine reads a global data structure that is constructed by the 
 * Various Add*Widget routines. This means that you can't ever have more than
 * one Yoke until you change this routine and migrate the data structure
 * into the Yoke instance record.
 *
 */

static void PollDeleteWidget(Widget w, YokeWidget yoke)
{
  int i,j;
  /* remove from Poll list */

  for (i = 0; i < PollStuffCount; i++)
    if(PollStuff[i].widget == w)
      break;

  for(j = i+1;j < PollStuffCount; j++)
    if(PollStuff[j].widget != w) /* widget could appear more than once */
      PollStuff[i++] = PollStuff[j];
  PollStuffCount -= (j - i);
}


/*
 * void PollDataFiles (client_data)
 *
 * DECSRIPTION
 *     Step through the PollStuff Data structure calling the stored subroutine
 * with the stored widget argument to cause the widget to poll for data.
 * The modification time of the first file is recorded.  After reading in
 * all the files in the Poll list, wait for the modification time on the
 * first file to change, then repeat... forever.  It is assumed that the
 * files will not be given read permission until they are completely written.
 */

void PollDataFiles (caddr_t client_data)
{
  char fullname[1024],*basename = 0;
  int arg_cnt;
  Arg args[10];
  struct stat statbuf;
  YokeWidget yoke;
  int j;

  yoke = (YokeWidget) client_data;
  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNbaseName, &basename);
  XtGetValues ((Widget) yoke, args, arg_cnt);

	if(PollStuffCount <= 0) {
		fprintf(stderr,"no files to poll\n");
		return;
	}

	for( j = 0; j < PollStuffCount; j++ ) {

		sprintf( fullname, "%s.%s", basename, PollStuff[j].suffix );

		if( ( lstat( fullname, &statbuf ) < 0 ) ||
		    ( statbuf.st_mtime == PollStuff[j].mtime ) ) {

			/* 
			 * the file is not there, or 
			 * the time has not changed 
			 */
			continue;
		}

		if( PollStuff[j].PollDataFunc( PollStuff[j].widget, 
							fullname ) == -1 ) {
			  continue;
		}

		/* 
		 * new first file. if not first time 
		 * unmap the display so old and 
		 * new data will not be mixed 
		 */
		if( PollStuff[j].mtime != 0 ) {
			PollStuff[j].PollUnmapFunc( PollStuff[j].widget );
/*			LScrollSet(yoke->yoke.scroll,0.0); /* 0.0 in middle */
/*			LScroll(yoke->yoke.scroll,0.5); /* slide it over */
		}
      
		PollStuff[j].PollMapFunc( PollStuff[j].widget );
      
		/* 
		 * now that poll has returned, 
		 * file is complete; take mod time 
		 */
		if( lstat( fullname, &statbuf ) == -1 ) {
			fprintf( stderr, "cannot stat %s\n", fullname );
			PollStuff[j].mtime= 0;	/* so won't try using below */
		} else {
			PollStuff[j].mtime = statbuf.st_mtime;
		}
	}
  
	XtAddTimeOut((int)1000, (XtTimerCallbackProc) PollDataFiles, 
		     client_data);
}


/*
 * static void SetGlobalResolution (w, client_data)
 *
 * Set the global resolution of all graphics widgets
 *
 */

static void SetGlobalResolution (Widget w, WidgetList client_data)
{
    DialogWidget dw = (DialogWidget) client_data[1];
    YokeWidget yw = (YokeWidget) client_data[2];
    Arg    args[10];
    int arg_cnt = 0;
    int	i;
    char *in = XawDialogGetValueString(dw);
    union {
      float f;
      unsigned int l;
    } value;

    value.f = atof(in);

    for (i = 0; i < yw->yoke.widget_count; i++) {
	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNsecsPpix, value.l);
	XtSetValues (yw->yoke.widgets[i], args, arg_cnt);
    }
}
