/* TsdtoolP.h - Private definitions for Adc tool widget
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 * 23-Jun-89  Fil Alleva (faa) at Carnegie-Mellon University
 *	Deleted mark_managed field.
 *
 */

#ifndef _XtTsdtooltP_h
#define _XtTsdtooltP_h

#include <vdata.h>
#include <Tsdtool.h>
#include <X11/Xaw/FormP.h>

typedef struct _TsdtoolClass 
{
    int makes_compiler_happy;	/* not used */
} TsdtoolClassPart;

typedef struct _TsdtoolClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    FormClassPart       form_class;
    TsdtoolClassPart    tsdtool_class;
}                   TsdtoolClassRec;

extern TsdtoolClassRec tsdtoolClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

/* New fields for the Tsdtool widget record */
typedef struct {
    /* resources */
    Widget              child;		/* Graphic part */
    int			channel;	/* which channel */
    int			channel_count;	/* How many channels */
    vdata_t		ac_data;	/* All channel data */
    vdata_t		sc_data;	/* selected channel data */
    Boolean		horiz_scale_on;	/* Horizontal scale on */
    Boolean		vert_scale_on;	/* Vertical scale on */
    Boolean		mark_on;	/* marks on */
    char               *time_series_fn; /* time series file name */
    char               *def_time_series_fn; /* default time series file name */
    char               *def_pitch_fn;   /* default pitch file name */
    char	       *segOutDir;	/* Segment output directory */
    Widget		mark;		/* The (optional) mark widget */
    Widget		hscale;		/* The (optional) hscale widget */
    Widget		vscale;		/* The (optional) vscale widget */
    Widget		scroll;		/* The (optional) scroll widget */
    char               *lyre_label;     /* The label in the tool */
}                   TsdtoolPart;


/* Full widget declaration */
typedef struct _TsdtoolRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    FormPart            form;
    TsdtoolPart         tsdtool;
}                   TsdtoolRec;

typedef struct _TsdtoolConstraintsPart
{
    int makes_compiler_happy;	/* not used */
} TsdtoolConstraintsPart;

typedef struct _TsdtoolConstraintsRec {
    FormConstraintsPart		form;    
    TsdtoolConstraintsPart	tsdtool;
} TsdtoolConstraintsRec, *TsdtoolConstraints;

#endif _XtTsdtoolP_h
