/* TsdP.h - Private Tsd Widget Defs
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 */

#ifndef _XtTsdP_h
#define _XtTsdP_h

#include <Tsd.h>
#include <LyreDispP.h>

#include <sys/types.h>
#include <vdata.h>

/*
 * New fields for the Tsd widget instance record
 */
typedef struct {
    Pixel               foreground_pixel;  /* Foreground Pixel */
    GC                  myGC;		   /* Pointer to Graphics Context */
    Boolean             reverse_video;	   /* Reverse Video Flag */
    int                 nsegments;	   /* Number of segments */
    XSegment           *segments;	   /* The segments that describe the
					    * graph */
    vdata_t            *input_data;	   /* New data is placed here */
    vdata_t            *data;		   /* Data object */
    Boolean		negate_data;	   /* Turn data upside down */

    Widget	        hscale_widget;	   /* Hscale widget (if there is one) */
    Widget	        vscale_widget;	   /* Vscale widget (if there is one) */

    float		data_min;	   /* min data value */
    float		data_max;	   /* max data value */
    int                width;             /* Activation threshold */
    int                threshold;         /* Activation threshold */
}                   TsdPart;

/*
 * Full instance record declaration
 */
typedef struct _TsdRec {
    CorePart core;
    LyreDispPart lyreDisp;
    TsdPart tsd;
}   TsdRec;

/*
 * New fields for the Tsd widget class record
 */
typedef struct {int dummy;} TsdClassPart;

/*
 * Full class record declaration.
 */
typedef struct _TsdClassRec {
    CoreClassPart core_class;
    LyreDispClassPart lyreDisp_class;
    TsdClassPart tsd_class;
}   TsdClassRec;

/*
 * Class pointer.
 */
extern TsdClassRec tsdClassRec;

#endif _XtTsdP_h
