static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/ToolUtil.c,v 4.5 1993/05/28 21:27:40 johans Exp johans $";

/*
 * ToolUtil.c
 *
 * HISTORY
 *   
 * 14-Jun-1989 Fil Alleva at OGC
 *        Added geometry to PopShell initilization to prevent
 *        improper inheritance from the X resource manager.
 *
 * 25-March-1993 Johan Schalkwyk at Oregon Graduate Institute
 *        made stylistic chanes, added lots and lots of comments
 *        and made the overall code more robust
 *        Changed to ANSI style header declarations
 *
 */

/* standard C library include file directives */
#include <fcntl.h>
#include <stdio.h>
#include <math.h>

/* Xlib include file directives */
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xaw/CommandP.h>
#include <X11/Xaw/DialogP.h>
#include <X11/Xaw/Text.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>


/* Lyre Include file directives */
#include <Lyre.h>
#include <LyreDisp.h>
#include <LyreDispP.h>
#include <Scale.h>
#include <ListCtl.h>


/* procedure in this module */
static void ListNext (Widget w, ListCtl *listctl);
static void ListPrev (Widget w, ListCtl *listctl);
static void SetListFile (Widget w, caddr_t *client_data);
static void move_popup (Widget button, caddr_t client, caddr_t call);
static void MakeList (char *file, ListCtl *listctl);


#define MyXtSetArg(args,i,arg,val)	{XtSetArg (args[i], arg, val); i++;}


/* 
 * Widget MakeMenuEntry (GodParent, Menu, CallData, EntryName, Prompt
 *                       Default, GoLabel, AbortLabel, GoAction, Resource)
 *
 * GodParent (in): The Parent widget
 * Menu      (in): menu to add entry to
 * CallData (out): data structure to pass
 * EntryName (in): label name for menu
 * Prompt    (in): Prompt connected to menu entry
 * Default   (in): default entry for prompt, user interface
 * GoLabel   (in): Label for execute action
 * AbortLabel(in): Label for abort action sequence
 * GoAction  (in): Pointer to function for go action
 * Resource  (in): Pointer to resources available
 *
 */

Widget MakeMenuEntry (Widget GodParent, Widget Menu, caddr_t CallData, 
		      char *EntryName, char *Prompt, char *Default, 
		      char *GoLabel, char *AbortLabel, caddr_t GoAction, 
		      char *Resource)
{
    Widget PopupShell;
    Widget Dialog;
    Widget Entry;
    Arg    args[10];
    int    arg_cnt;

    Entry = XtCreateManagedWidget(EntryName, smeBSBObjectClass, Menu, NULL, 0);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNgeometry, "200x100");
/*    PopupShell = XtCreatePopupShell ("Dialog", overrideShellWidgetClass,
				     GodParent, args, arg_cnt);
*/
    PopupShell = XtCreatePopupShell ("Dialog", transientShellWidgetClass,
				     GodParent, args, arg_cnt);
    XtAddCallback (Entry, XtNcallback, (XtCallbackProc) move_popup,PopupShell);
    XtAddCallback (Entry, XtNcallback, XtCallbackExclusive, PopupShell);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNlabel, Prompt);
    MyXtSetArg (args, arg_cnt, XtNvalue, Default);
    Dialog = XtCreateManagedWidget ("dialog", dialogWidgetClass, PopupShell,
				    args, arg_cnt);
    {
	XtPopdownIDRec *pdid = (XtPopdownIDRec *) 
	  XtMalloc (sizeof(XtPopdownIDRec));
	caddr_t *act = (caddr_t *) XtMalloc (sizeof(caddr_t) * 3);
	Widget  tbw;

	act[0] = (caddr_t) CallData;
	act[1] = (caddr_t) Dialog;
 	act[2] = (caddr_t) Resource;

	pdid->shell_widget  = PopupShell;
	pdid->enable_widget = Entry;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, GoLabel);
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, XtCallbackPopdown, pdid);
	XtAddCallback (tbw, XtNcallback, (XtCallbackProc) GoAction, act);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, AbortLabel);
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, XtCallbackPopdown, pdid);
    }
    return (Entry);
}


/*
 * Widget MakeButtonPopup (GodParent, AboveWidget, LeftWidget, CallData,
 *                         ButtonName, Prompt, Default, GoLabel, AbortLabel
 *                         GoAction, Resource)
 *
 * GodParent  (in): The (god) Parent Widget
 * Parent     (in): Parent of the button widget
 * AboveWidget(in): The widget above (in location) of this widget
 * LeftWidget (in): The widget left of this widget
 * CallData  (out): Data Parsed by actions
 * ButtonName (in): Label associated with the button Popup
 * Prompt     (in): Prompt, dialog box label associated
 * Default    (in): Default user entry
 * GoLabel    (in): Label Associated with the go action
 * AbortLabel (in): Label Associated with the abort action
 * Resource   (in): pointer to the resources available
 *
 */

Widget MakeButtonPopup (Widget GodParent, Widget Parent, Widget AboveWidget, 
			Widget LeftWidget, caddr_t CallData,
			char *ButtonName, char *Prompt, char *Default, 
			char *GoLabel, char *AbortLabel, caddr_t GoAction, 
			char *Resource)
{
    Widget PopupShell;
    Widget Dialog;
    Widget Button;
    Arg    args[10];
    int    arg_cnt;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNlabel,     ButtonName);
    MyXtSetArg (args, arg_cnt, XtNfromVert,  AboveWidget);
    MyXtSetArg (args, arg_cnt, XtNfromHoriz, LeftWidget);
    Button = XtCreateManagedWidget ("button", commandWidgetClass,
				Parent, args, arg_cnt);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNgeometry, "200x100");
/*
    PopupShell = XtCreatePopupShell ("Dialog", overrideShellWidgetClass,
				     GodParent, args, arg_cnt);
*/
    PopupShell = XtCreatePopupShell ("Dialog", transientShellWidgetClass,
				     GodParent, args, arg_cnt);

    XtAddCallback(Button,XtNcallback, (XtCallbackProc) move_popup, PopupShell);
    XtAddCallback (Button, XtNcallback, XtCallbackExclusive, PopupShell);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNlabel, Prompt);
    MyXtSetArg (args, arg_cnt, XtNvalue, Default);
    Dialog = XtCreateManagedWidget ("dialog", dialogWidgetClass, PopupShell,
				    args, arg_cnt);
    {
	XtPopdownIDRec *pdid = (XtPopdownIDRec *) 
	  XtMalloc (sizeof(XtPopdownIDRec));
	caddr_t *act = (caddr_t *) XtMalloc (sizeof(caddr_t) * 3);
	Widget tbw;

	act[0] = (caddr_t) CallData;
	act[1] = (caddr_t) Dialog;
 	act[2] = (caddr_t) Resource;

	pdid->shell_widget  = PopupShell;
	pdid->enable_widget = Button;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, GoLabel);
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, XtCallbackPopdown, pdid);
	XtAddCallback (tbw, XtNcallback, (XtCallbackProc) GoAction, act);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, AbortLabel);
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, XtCallbackPopdown, pdid);
    }
    return (Button);
}


/*
 * void MakePopup (GodParent, Button, CallData, Prompt, Default, GoLabel,
 *       	   AbortLabel, GoAction)
 *
 * Makes a popup dialog box, with user input and command buttons
 * Used for file name retrieval, resolution retrieval etc.
 *
 * GodParent (in): The Parent widget (normally new->child)
 * Button    (in): The button that pop's up this dialog box
 * CallData (out): Data Pass between widgets via the widget data struc
 * Prompt    (in): Pointer to string -> label of Popup Window
 * Default   (in): Default setting of user entry
 * GoLabel   (in): Label for action execution
 * AbortLabel(in): Label for action abort sequence
 * GoAction  (in): Pointer to procedure needed to execute action
 *
 * Usage: MakePopup((Widget) new, entry, (caddr_t) mark,
 *                  "Pitch file name:", "test", "Display", "Abort",
 *                  (caddr_t) PitchRead)
 *
 * {This Code seems robust}
 *
 */

void MakePopup (Widget GodParent, Widget Button, caddr_t CallData, 
		char *Prompt, char *Default, char *GoLabel,
		char *AbortLabel, caddr_t GoAction)
{
    Widget PopupShell;
    Widget Dialog;
    Arg    args[10];
    int    arg_cnt;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNallowShellResize, TRUE);
    MyXtSetArg (args, arg_cnt, XtNgeometry, "200x100");
/*
    PopupShell = XtCreatePopupShell ("Dialog", overrideShellWidgetClass,
				     GodParent, args, arg_cnt);
*/
    PopupShell = XtCreatePopupShell ("Dialog", transientShellWidgetClass,
				     GodParent, args, arg_cnt);
    XtAddCallback(Button,XtNcallback, (XtCallbackProc) move_popup, PopupShell);
    XtAddCallback (Button, XtNcallback, XtCallbackNonexclusive, PopupShell);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNlabel, Prompt);
    MyXtSetArg (args, arg_cnt, XtNvalue, Default);
    Dialog = XtCreateManagedWidget ("dialog", dialogWidgetClass, PopupShell,
				    args, arg_cnt);
    {
	XtPopdownIDRec *pdid = (XtPopdownIDRec *) 
	  XtMalloc (sizeof(XtPopdownIDRec));
	caddr_t *act = (caddr_t *) XtMalloc (sizeof(caddr_t) * 3);
	Widget  tbw;

	act[0] = (caddr_t) CallData;
	act[1] = (caddr_t) Dialog;
	act[2] = (caddr_t) GodParent;

	pdid->shell_widget  = PopupShell;
	pdid->enable_widget = Button;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, GoLabel);
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, XtCallbackPopdown, pdid);
	XtAddCallback (tbw, XtNcallback, (XtCallbackProc) GoAction, act);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, AbortLabel);
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, XtCallbackPopdown, pdid);
    }
}


/*
 * void MakePopupL (GodParent, Button, CallData, Prompt, Default, GoLabel,
 *                  AbortLabel, GoAction)
 *
 * (Needs Some Work - Dialog Box enlarges self with New Line characters
 *  Bad Overall. It is however a function of the dialog box widget class. )
 *
 * GodParent (in): The (God) Parent Widget
 * Button    (in): The button that pop's up the dialog box
 * CallData (out): Data transferable by widget calls
 * Prompt    (in): Label for dialog box and user interface
 * Default   (in): Default user entry
 * GoLabel   (in): The label of the go action command button
 * AbortLabel(in): The label of the abort action command button
 * GoAction  (in): The procedure to call for the go action
 *
 */

void MakePopupL (Widget GodParent, Widget Button, caddr_t CallData, 
		 char *Prompt, char *Default, char *GoLabel,
		 char *AbortLabel, caddr_t GoAction)
{
    Widget              PopupShell;
    Widget              Dialog;
    Arg                 args[10];
    int                 arg_cnt;

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNallowShellResize, TRUE);
    MyXtSetArg (args, arg_cnt, XtNgeometry, "250x100");   /* Geometry Set */
/*
    PopupShell = XtCreatePopupShell ("Dialog", overrideShellWidgetClass,
				     GodParent, args, arg_cnt);
*/
    PopupShell = XtCreatePopupShell ("Dialog", transientShellWidgetClass,
				     GodParent, args, arg_cnt);
    XtAddCallback(Button,XtNcallback,(XtCallbackProc) move_popup, PopupShell);
    XtAddCallback (Button, XtNcallback, XtCallbackNonexclusive, PopupShell);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNlabel, Prompt);
    MyXtSetArg (args, arg_cnt, XtNvalue, Default);

    Dialog = XtCreateManagedWidget ("dialog", dialogWidgetClass, PopupShell,
				    args, arg_cnt);
    {
	XtPopdownIDRec *pdid = (XtPopdownIDRec *) 
	                        XtMalloc (sizeof(XtPopdownIDRec));
	caddr_t *act     = (caddr_t *) XtMalloc (sizeof(caddr_t) * 3);
        ListCtl *listctl = (ListCtl *) XtMalloc(sizeof(ListCtl));
	Widget  tbw;

	act[0] = (caddr_t) CallData;
	act[1] = (caddr_t) Dialog;
	act[2] = (caddr_t) GodParent;

	pdid->shell_widget  = PopupShell;
	pdid->enable_widget = Button;

	listctl->dialog  = (Widget) Dialog;
	listctl->list    = 0;
	listctl->count   = 0;
	listctl->current = 0;

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, GoLabel);
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, XtCallbackPopdown, pdid);
	XtAddCallback (tbw, XtNcallback, (XtCallbackProc) GoAction, act);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, AbortLabel);
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, XtCallbackPopdown, pdid);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, "Next");
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, (XtCallbackProc) ListNext, listctl);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, "Prev");
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	XtAddCallback (tbw, XtNcallback, (XtCallbackProc) ListPrev, listctl);

	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNlabel, "List");
	tbw = XtCreateManagedWidget ("button", commandWidgetClass,
				     Dialog, args, arg_cnt);
	MakePopup (GodParent, tbw, (caddr_t) listctl, "List File", 
		   "NoDefault", "Load", "Abort", (caddr_t) SetListFile);
    }
}


/*
 * void SetFloat (w, client_data)
 *
 * Set a floating point widget resource
 *
 */

void SetFloat (Widget w, WidgetList client_data)
{
    Widget       child = client_data[0];
    DialogWidget dw    = (DialogWidget) client_data[1];
    char         *Resource = (char *) client_data[2];
    Arg          args[10];
    int arg_cnt = 0;

    char *in = XawDialogGetValueString((Widget) dw);
    union {
	float f;
	unsigned int i;
    } data;
   
    data.f = (float) atof(in);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, Resource, data.i);
    XtSetValues (child, args, arg_cnt);
}


/*
 * void SetInt (w, client_data)
 *
 * Set an integer widget resource
 *
 */

void SetInt (Widget w, WidgetList client_data)
{
    Widget child = client_data[0];
    DialogWidget dw = (DialogWidget) client_data[1];
    char *Resource = (char *) client_data[2];
    Arg    args[10];
    int arg_cnt = 0;
    char *in = XawDialogGetValueString((Widget) dw);
    union {
	float f;
	unsigned int i;
    } data;
   
    data.i = atoi(in);

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, Resource, data.i);
    XtSetValues (child, args, arg_cnt);
}


/*
 * void SetScale (w, scale)
 *
 * Set the display scale for the graphics widget
 *
 * w (in/out): widget for scaling (graphics window)
 * scale (in): scale for display
 *
 */

void SetScale (LyreDispWidget w, float scale)
{
  if (w) {
    int         arg_cnt = 0;
    Arg 	args[10];
    floatInt_t  unit_per_pix;
    floatInt_t  secs_per_pix;
    
    unit_per_pix.f = scale * 1000.0;
    secs_per_pix.f = scale;

    MyXtSetArg (args, arg_cnt, XtNunitPerPix, unit_per_pix.i);
    MyXtSetArg (args, arg_cnt, XtNsecsPpix, secs_per_pix.i);
    XtSetValues ((Widget) w, args, arg_cnt);
  }
}


/*
 * static void ListPrev(w, listctl)
 *
 * Used in conjunction with MakePopupL - List all previous files
 * in the current list of speech files being looked at.
 *
 * w        (in): parent widget, where this procedure was called from
 * listctl (out): linked list of file names in list file
 *
 */

static void ListPrev(Widget w, ListCtl *listctl)
{
    DialogWidget	parent_dw = (DialogWidget) listctl->dialog;
    char               *src_str;
    XawTextBlock	tb;

    if (listctl->count) {
	if (listctl->current-1 >= 0)
	    listctl->current--;
	src_str = listctl->list[listctl->current];
    }
    else {
        XtAlert("No Entries in list file");
	src_str = "";
      }
/*	src_str = "No Entries in list file"; */
    
    tb.firstPos = 0;
    tb.length   = strlen (src_str);  
    tb.ptr    = src_str;
    tb.format = FMT8BIT;
    if ((int) strlen (src_str) > 0) {
      XawTextReplace (parent_dw->dialog.valueW, 0, tb.length, &tb);
      XawTextSetInsertionPoint (parent_dw->dialog.valueW, tb.length);
      XawTextDisplay (parent_dw->dialog.valueW);
    }
}


/*
 *  static void ListNext(w, listctl)
 *
 * Used in Conjunction with MakePopupL(). List the file next in the 
 * list of speech files currently being looked at.
 *
 */

static void ListNext(Widget w, ListCtl *listctl)
{
    DialogWidget        parent_dw = (DialogWidget) listctl->dialog;
    char               *src_str;
    XawTextBlock         tb;

    if (listctl->count) {
	if (listctl->current+1 < listctl->count)
	    listctl->current++;
	src_str = listctl->list[listctl->current];
    }
    else {
      XtAlert("No Entries in list file");
      src_str = "";
    }

/*    src_str = "No Entries in list file"; */

    tb.firstPos = 0;
    tb.length   = strlen (src_str);
    tb.ptr      = src_str;
    tb.format   = FMT8BIT;
    
    if ((int) strlen(src_str) > 0) {
      XawTextReplace (parent_dw->dialog.valueW, 0, tb.length, &tb);
      XawTextSetInsertionPoint (parent_dw->dialog.valueW, tb.length);
      XawTextDisplay (parent_dw->dialog.valueW);
    }
}


/*
 * static void SetListFile (w, client_data)
 *
 * Set the list file - file containing the list of entries
 * used for speech files.
 *
 * w          (in): parent widget, widget where SetListFile was called from
 * client_dat(out): Data Passing, the listing of file names
 *
 */

static void SetListFile (Widget w, caddr_t *client_data)
{
    ListCtl	  *listctl  = (ListCtl *) client_data[0];
    DialogWidget  dw        = (DialogWidget) client_data[1];
    DialogWidget  parent_dw = (DialogWidget) listctl->dialog;
    char 	  *in       = XawDialogGetValueString((Widget) dw);
    XawTextBlock  tb;

    MakeList (in, listctl);
    if (listctl->count) {
	tb.firstPos = 0;
	tb.length = strlen (listctl->list[0]);
	tb.ptr = listctl->list[0];
	tb.format = FMT8BIT;
	if ((int) strlen(tb.ptr) > 0) {
	  XawTextReplace (parent_dw->dialog.valueW, 0, tb.length, &tb);
	  XawTextSetInsertionPoint (parent_dw->dialog.valueW, tb.length);
	  XawTextDisplay (parent_dw->dialog.valueW);
	}
    }
}


/*
 * static void MakeList (file, listctl)
 *
 */

static void MakeList (char *file, ListCtl *listctl)
{
    char str[1024];
    FILE *fs = fopen (file, "r");
    if (fs == NULL) {
      XtAlert ("Could not open %s\n", file);
      return;
    }
    listctl->count = 0;
    listctl->current = 0;
    listctl->list = (char **) XtMalloc (sizeof(char*) * 64);
    while (fgets (str, sizeof(str), fs)) {
      str[strlen (str)-1] = 0;		/* Nuke the new line from fgest */
      listctl->list[listctl->count++] = (char *) salloc (str);
      if ((listctl->count % 64) == 0)
	listctl->list = (char **) XtRealloc ((char *) listctl->list, 
					     sizeof(char*) * 
					     (listctl->count + 64));
    }
}


/*
 * PollForFile(file, interval, attempts)
 *
 * procedure used for auto lyre -> polls the disc at regular
 * intervals for latest file (adc file)
 *
 * file    (in): name of input file
 * interval(in): interval of file polling
 * attemps (in): number of attempts before abort
 *
 */

PollForFile(char *file, int interval, int attempts)
{
    int fd;
    while (attempts--) {
      if (0 < (fd = open (file, O_RDONLY))) {
	close (fd);
	return (0);
      }
      if(attempts)
	{
	  DispatchPendingEvents();
	  sleep (interval);
	}
    }
    return (-1);
}


/*
 * static void move_popup (button, client, call)
 *
 * This routine positions moves the pop-up window
 * to appear under the mouse
 *
 */

static void move_popup (Widget button, caddr_t client, caddr_t call)
{
  int x, y, x_win, y_win;
  unsigned int keys;
  Window root, win;
  
  Display *dpy = XtDisplay((Widget)client);
  XQueryPointer(dpy, RootWindow(dpy,DefaultScreen(dpy)), &root, &win, &x, &y,
		&x_win, &y_win, &keys);
  XtMoveWidget((Widget) client, x - 20, y - 45);
}




