/* MarkP.h - Private Mark Widget Defs
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 */

#ifndef _XtMarkP_h
#define _XtMarkP_h

#include <Mark.h>
#include <LyreDispP.h>

#include <sys/types.h>
#include <vdata.h>

/* need a structure like XSegment which has ints instead of shorts 
 * this is a quick patch; I will ignore the x values in segments and 
 * use the parallel BigSegment structure.  I am keeping the XSegment 
 * structure too because it is what XDrawSegments wants -- the correct
 * relative values will be filled in when needed -- maf
 */

typedef struct {
  int x1,x2;
} BigSegment;

/*
 * New fields for the Mark widget instance record
 */
typedef struct {
    Pixel               foreground_pixel;  /* Foreground Pixel */
    GC                  myGC;		   /* Pointer to Graphics Context */
    Boolean             reverse_video;	   /* Reverse Video Flag */
    int                 nsegments;	   /* Number of segments */
    XSegment           *segments;	   /* Mark segments */
    BigSegment         *bigsegments;	   /* int Mark segments */
    int			mark_length;	   /* Mark length */
    vdata_t            *input_data;	   /* New data is placed here */
    vdata_t            *store_data;	   /* Data object */
    vdata_t            *input_highlight;   /* Highlight data is placed here */
    vdata_t            *store_highlight;   /* Highlight Data object */

    Widget	        hscale_widget;	   /* Hscale widget (if there is one) */
    Widget	        vscale_widget;	   /* Vscale widget (if there is one) */
}                   MarkPart;

/*
 * Full instance record declaration
 */
typedef struct _MarkRec {
    CorePart core;
    LyreDispPart lyreDisp;
    MarkPart mark;
}   MarkRec;

/*
 * New fields for the Mark widget class record
 */
typedef struct {int dummy;} MarkClassPart;

/*
 * Full class record declaration.
 */
typedef struct _MarkClassRec {
    CoreClassPart core_class;
    LyreDispClassPart lyreDisp_class;
    MarkClassPart mark_class;
}   MarkClassRec;

/*
 * Class pointer.
 */
extern MarkClassRec markClassRec;

#endif _XtMarkP_h
