/* Lspec.h - Public Lspec Widget Defs
 *------------------------------------------------------------*
 * HISTORY
 */

#ifndef _XtLspec_h
#define _XtLspec_h

/***********************************************************************
 *
 * Lspec Widget
 *
 ***********************************************************************/


/* Resource names used to the lspec widget
 */
#define XtNresolution	"resolution"	/* (u_int) Resolution */

#define XtNdata		"data"		/* (adata_t *) Data Object */
#define XtNasync	"async"		/* Data location */
#define XtNsync		"sync"		/* Data sync location */
#define XtNsynccnt	"synccnt"	/* Num entries in sync */
#define XtNsyncdelta	"syncdelta"	/* delta of entries in sync */

#define XtNminOffset    "minoffset"
#define XtCMinOffset    "minoffset"

#ifndef XtNmaxHeight
#define XtNmaxHeight	"maxheight"
#endif

#define XtNrightUp	"rightup"
#define XtCRightUp	"rightup"

#define XtNskew		"skew"
#define XtCSkew		"skew"

#define XtNallRows	"allrows"
#define XtNstartRow     "startrow"
#define XtNrowCount	"rowcount"

#define XtNhscaleWidget "hscalewidget"	/* The optional hscale widget */
#define XtNvscaleWidget "vscalewidget"	/* The optional vscale widget */
#define XtNfcand        "fcand"         /* Formant candidates */
#define XtNdispPeakExtent "disppeakextent"  /* Display peak extents */

typedef struct _LspecRec *LspecWidget;		 /* defined in LspecP.h */
typedef struct _LspecClassRec *LspecWidgetClass; /* defined in LspecP.h */

extern WidgetClass lspecWidgetClass;

#endif _XtLspec_h
