/* GspectoolP.h - Private definitions for Gspec tool widget
 * 
 */

#ifndef _XtGspectooltP_h
#define _XtGspectooltP_h

#include <Gspectool.h>
#include <X11/Xaw/FormP.h>

typedef struct _GspectoolClass 
{
    int makes_compiler_happy;	/* not used */
} GspectoolClassPart;

typedef struct _GspectoolClassRec {
    CoreClassPart       core_class;
    CompositeClassPart  composite_class;
    ConstraintClassPart constraint_class;
    FormClassPart       form_class;
    GspectoolClassPart    gspectool_class;
}                   GspectoolClassRec;

extern GspectoolClassRec gspectoolClassRec;

/***************************************
 *
 *  Instance (widget) structure 
 *
 **************************************/

/* New fields for the Gspectool widget record */
typedef struct {
    /* resources */
    XtCallbackList      callbacks;
    Widget              child;		/* Graphic part */
    Boolean		horiz_scale_on;	/* Horizontal scale on */
    Boolean		vert_scale_on;	/* Vertical scale on */
    ScaleWidget		hscale;
    ScaleWidget		vscale;
    Widget              rowReadout;     /* row label read out */
    char		*lyre_label;	/* the tool lable */
    String              rowlabel;       /* rowlabel readout */
    float               energy;         /* Energy readout */
}                   GspectoolPart;


/* Full widget declaration */
typedef struct _GspectoolRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    FormPart            form;
    GspectoolPart         gspectool;
}                   GspectoolRec;

typedef struct _GspectoolConstraintsPart
{
    int makes_compiler_happy;	/* not used */
} GspectoolConstraintsPart;

typedef struct _GspectoolConstraintsRec {
    FormConstraintsPart		form;    
    GspectoolConstraintsPart	gspectool;
} GspectoolConstraintsRec, *GspectoolConstraints;

#endif _XtGspectoolP_h
