static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/Gspectool.c,v 4.19 1993/09/17 01:29:32 johans Exp $";

/*
 * Gspectool.c - Gspectool widget
 *------------------------------------------------------------*
 * Copyright 1988, Fil Alleva and Carnegie Mellon University
 *------------------------------------------------------------*
 * HISTORY
 *
 * 09-Jan-91 Fil Alleva (faa@cs.cmu.edu)
 *	Converted controls to a pop-up menu.
 *
 * 25-March-1993 Johan Schalkwyk at Oregon Graduate Institute
 *      made stylistic changes, added lots and lots of comments
 *      and made the overall code more robust.
 *      changed file to ANSI style header declarations
 *
 */

/* standard C library include file directives */
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <syncstruct.h>
#include <LyreStringDefs.h>

/* Speech library include file directives */
#include <speech.h>
#include <dft.h>

/* X library include file directives */
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/Xmu/Misc.h>
#include <X11/Xaw/CommandP.h>
#include <X11/Xaw/DialogP.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>

/* Lure include file directives */
#include <ScaleP.h>
#include <Scale.h>
#include <GspecP.h>
#include <GspectoolP.h>
#include <ToolUtil.h>
#include <LyreStringDefs.h>

/* External procedure declarations */
Widget MakeButtonPopup (Widget GodParent, Widget Parent, Widget AboveWidget, 
			Widget LeftWidget, caddr_t CallData,
			char *ButtonName, char *Prompt, char *Default, 
			char *GoLabel, char *AbortLabel, caddr_t GoAction, 
			char *Resource);
void SetFloat (Widget w, WidgetList client_data);
void SetInt (Widget w, WidgetList client_data);


/* routines decalred within this module */
static char **CreateLabels (char **ar, int len);
static void GetDataS (Widget w, WidgetList client_data);
static void Destroy (Widget w, Widget target_widget, caddr_t call_data);
static void Initialize (GspectoolWidget request, GspectoolWidget new);
static int  ReadSpecFile (GspecWidget w, char *file);
static void DoGspecOptions (Widget w, caddr_t *data);
static void DoGspecRead(Widget w, caddr_t *data);
static Widget  BuildGspecOption (Widget w, GspecWidget gs, Widget new);
static Boolean SetValues (Widget gcurrent, Widget grequest, Widget gnew);

#define offset(field) XtOffset(GspectoolWidget, field)

static Boolean defTRUE  = TRUE;
static Boolean defFALSE = FALSE;

static XtResource resources[] = { 
   {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t), 
      offset(gspectool.callbacks), XtRCallback, (caddr_t)NULL},
   {XtNchild, XtCChild, XtRPointer, sizeof(caddr_t), 
      offset(gspectool.child), XtRPointer, (caddr_t)NULL},
   {XtNvertScaleOn, XtNvertScaleOn, XtRBoolean, sizeof(Boolean), 
      offset(gspectool.vert_scale_on), XtRBoolean, (caddr_t)&defTRUE},
   {XtNhorizScaleOn, XtNhorizScaleOn, XtRBoolean, sizeof(Boolean), 
      offset(gspectool.horiz_scale_on), XtRBoolean, (caddr_t)&defTRUE},
   {XtNlyreLabel, XtCParameter, XtRString, sizeof(String), 
      offset(gspectool.lyre_label), XtRString, "Tdat Tool"},
   {XtNrowlabel, XtNrowlabel, XtRString, sizeof(String),
      offset(gspectool.rowlabel), XtRString, "0000.00"},
   {XtNenergy, XtNenergy, XtRFloat, sizeof(float),
      offset(gspectool.energy), XtRString, "0.0"},
};
#undef offset

GspectoolClassRec gspectoolClassRec = {
  {
    (WidgetClass) &formClassRec,	/* superclass		  */	
    "Gspectool",			/* class_name		  */
    sizeof(GspectoolRec),		/* size			  */
    NULL,				/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    TRUE,				/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,                          /* set_values             */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL,				/* extension		  */
  },  /* CoreClass fields initialization */
  { /* composite_class fields */
    /* geometry_manager   */   XtInheritGeometryManager,
    /* change_managed     */   XtInheritChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
  },
  { /* constraint_class fields */
    /* subresourses       */   NULL,
    /* subresource_count  */   0,
    /* constraint_size    */   sizeof(GspectoolConstraintsRec),
    /* initialize         */   NULL,
    /* destroy            */   NULL,
    /* set_values         */   NULL
  },
  {
    0,
  }, /* FormClass fields */
  {
    0,                                     /* field not used    */
  },  /* GspectoolClass fields initialization */
};


WidgetClass gspectoolWidgetClass = (WidgetClass) &gspectoolClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

#define MyXtSetArg(args,i,arg,val) {XtSetArg (args[i],arg,(XtArgVal)val); i++;}

/*
 * Initialize (request, new)
 *
 * Initialize the Gspectool (Tdat) widget)
 *   GspecTool -> hscale
 *             -> vscale
 *             -> child (graphics)
 *             -> ControlWidget -> label
 *                              -> label
 *                              -> command -> popup window
 *             
 */

static void Initialize (GspectoolWidget request, GspectoolWidget new)
{
    Widget              child, command, menu, entry, ab,
                        ControlWidget, popup, 
		        vscale = NULL, hscale = NULL;
    Arg                 args[20];
    int                 arg_cnt;
    char		stmp[128];

    /*
     * Create Control widget for the Gspec Tool
     *  GspecTool -> ControlWidget
     *
     */

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
    ControlWidget = XtCreateManagedWidget ("controls", formWidgetClass,
					   new, args, arg_cnt);

    /*
     * Create the command button widget
     *  Gspectool -> ControlWidget -> command
     *
     */

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNborderWidth,   2);
    MyXtSetArg (args, arg_cnt, XtNhorizDistance, 4);
    MyXtSetArg (args, arg_cnt, XtNvertDistance,  4);
    MyXtSetArg (args, arg_cnt, XtNlabel, "Tdat" );
    command = XtCreateManagedWidget(new->gspectool.lyre_label, 
				    commandWidgetClass, ControlWidget, 
				    args, arg_cnt);

    /*
     * Create label widget below button
     *  Gspectool -> ControlWidget -> label
     *
     */

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNlabel, "           ");
    MyXtSetArg (args, arg_cnt, XtNfromVert, command);
    new->gspectool.rowReadout =
      XtCreateManagedWidget ("button", labelWidgetClass, ControlWidget, 
			     args, arg_cnt);

    /*
     * Create horizontal scale widget for graphics
     *  Gspectool -> hscale
     *
     */

    if (new->gspectool.horiz_scale_on) {
	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 130);
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainRight);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNresizable,  TRUE);
	MyXtSetArg (args, arg_cnt, XtNhorizontal, TRUE);
        MyXtSetArg (args, arg_cnt, XtNborderWidth, 1);
        MyXtSetArg (args, arg_cnt, XtNunitsLabel, "ms");
        MyXtSetArg (args, arg_cnt, XtNshowExtent, FALSE);
	hscale = XtCreateManagedWidget ("scale", scaleWidgetClass, new, 
					args, arg_cnt);
        new->gspectool.hscale = (ScaleWidget) hscale;
    }

    /*
     * Create vertical scale widget for graphics
     *  Gspectool -> vscale
     *
     */

#ifdef VERTSCALE
    if (new->gspectool.vert_scale_on) {
	arg_cnt = 0;
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 130);
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
	if (new->gspectool.horiz_scale_on)
	     MyXtSetArg (args, arg_cnt, XtNfromVert, hscale);
	MyXtSetArg (args, arg_cnt, XtNresizable,  TRUE);
	MyXtSetArg (args, arg_cnt, XtNhorizontal, FALSE);
        MyXtSetArg (args, arg_cnt, XtNborderWidth, 1);
        MyXtSetArg (args, arg_cnt, XtNunitsLabel, "kHz");
	vscale = XtCreateManagedWidget ("scale", scaleWidgetClass, new, args,
					arg_cnt);
        new->gspectool.vscale = vscale;
    }
#endif

    /*
     * Create the graphics widget
     *  Gspectool -> child (graphics)
     *
     */

    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNhorizDistance, 130);
    MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
    MyXtSetArg (args, arg_cnt, XtNright,  XtChainRight);
    MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
    MyXtSetArg (args, arg_cnt, XtNbottom, XtChainBottom);
    if (new->gspectool.horiz_scale_on)
        MyXtSetArg (args, arg_cnt, XtNfromVert, hscale);
    MyXtSetArg (args, arg_cnt, XtNresizable, TRUE);
    MyXtSetArg (args, arg_cnt, XtNvscaleWidget, vscale);
    MyXtSetArg (args, arg_cnt, XtNhscaleWidget, hscale);
    MyXtSetArg (args, arg_cnt, XtNtoolWidget, new);
    child = XtCreateManagedWidget ("gspec", gspecWidgetClass, new,
		args, arg_cnt);
    new->gspectool.child = child;

    /*
     * Build the option menu and its actions
     */

    popup = BuildGspecOption( command, (GspecWidget) child, (Widget) new );
    XtAddCallback( command, XtNcallback, XtCallbackNone, popup );
}


typedef struct _appdata {
  float exp;
  int poscolors;
  int negcolors;
  float secsppix;
} AppData,*AppDataPtr;

static XtResource someresources[] = {
    {XtNexp, XtNexp, XtRFloat, sizeof(float),
        XtOffset(AppDataPtr,exp), XtRString, "1.0"},
    {XtNposcolors, XtNposcolors, XtRInt, sizeof(int),
        XtOffset(AppDataPtr,poscolors), XtRString, "40"},
    {XtNnegcolors, XtNnegcolors, XtRInt, sizeof(int),
        XtOffset(AppDataPtr,negcolors), XtRString, "40"},
    {XtNsecsPpix, XtNsecsPpix, XtRFloat, sizeof(float),
       XtOffset(AppDataPtr,secsppix), XtRString, "0.001"},
  };


/*
 * Widget BuildGSpecOption(w, gs, new)
 *
 * Build the Spectrogram popup window form.
 *
 */

static Widget BuildGspecOption( Widget w, GspecWidget gs, Widget new )
{
	Widget form, lb, lb2, lb3, lb4, ab, shell;
	Widget posmin_tw, posmax_tw, poscol_tw, file_tw, file_aw;
	Widget negmin_tw, negmax_tw, negcol_tw, res_tw, expon_tw;
	XtPopdownIDRec *pdid;
	caddr_t *c_data;
	caddr_t *r_data;
	Arg args[20];
	int arg_cnt;
	char buf[64];
	AppData appdata;

	/* 
	 * retrieve the lyre applications resources available
	 *
	 */

	XtGetApplicationResources(gs, &appdata, someresources,
				  XtNumber(someresources),NULL,0);

	/*
	 * create a form widget for info handling
	 *   Gspectool -> ControlWidget -> command -> shell -> form
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNallowShellResize, TRUE );
	MyXtSetArg( args, arg_cnt, XtNgeometry, "400x220" );
	shell = XtCreatePopupShell("Tdat Options", 
				topLevelShellWidgetClass, w, args, arg_cnt );

	form = XtCreateManagedWidget( "SpecOptions", formWidgetClass, 
						shell, NULL, 0 );

	/*
	 * Create Cancel button
	 *  Gspectool -> ControlWidget -> command -> shell -> form -> Cancel
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Cancel" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 5 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance,  5 );
	MyXtSetArg (args, arg_cnt, XtNborderWidth,   1);
	ab = XtCreateManagedWidget( "CancelOptions", commandWidgetClass,
						form, args, arg_cnt );


 	pdid = (XtPopdownIDRec *) XtMalloc( sizeof(XtPopdownIDRec) );
	pdid->shell_widget  = shell;
	pdid->enable_widget = w;
	XtAddCallback( ab, XtNcallback, XtCallbackPopdown, pdid );

	/* 
	 * The file name cannot be set in auto_lyre; only have the
	 * option in lyre
	 *
	 */

#ifdef LYRE

	/*
	 * Create Apply (read) Widget for file name
	 *  .... -> form -> read Command
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Read" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 5 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance,  5 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz,  ab );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1);
	file_aw = XtCreateManagedWidget( "ReadFile", commandWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create File Name label
	 * ... -> form -> filenameLabel
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "File Name:" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
	MyXtSetArg (args, arg_cnt, XtNfromVert, ab );
	lb = XtCreateManagedWidget( "FileName", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Text Widget for file name
	 *  ... -> form -> file Input Text
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNstring, "" );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft );
/*	MyXtSetArg (args, arg_cnt, XtNright,  XtChainRight );*/
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1 );
	MyXtSetArg (args, arg_cnt, XtNeditType, XawtextEdit );
	MyXtSetArg (args, arg_cnt, XtNfromVert, ab );
	MyXtSetArg (args, arg_cnt, XtNvertDistance, 5 );
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 0 );
	file_tw = XtCreateManagedWidget( "FileText", asciiTextWidgetClass,
						form, args, arg_cnt );
#endif

	/*
	 * Create Resolution label
	 *  ... -> form -> resolution label
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Resolution:" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
#ifdef LYRE
	MyXtSetArg (args, arg_cnt, XtNfromVert, file_tw );
#else
	MyXtSetArg (args, arg_cnt, XtNfromVert, ab );
#endif
	lb = XtCreateManagedWidget( "Resolution", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Text Widget for resolution
	 *  ... -> form -> resolution Input Text
	 *
	 */

	arg_cnt = 0;
	sprintf(buf,"%f",appdata.secsppix);
	MyXtSetArg( args, arg_cnt, XtNstring, buf);
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1 );
	MyXtSetArg (args, arg_cnt, XtNeditType, XawtextEdit );
#ifdef LYRE
	MyXtSetArg (args, arg_cnt, XtNfromVert, file_tw );
#else
	MyXtSetArg (args, arg_cnt, XtNfromVert, ab );
#endif
	MyXtSetArg (args, arg_cnt, XtNvertDistance, 5 );
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 0 );
	res_tw = XtCreateManagedWidget( "ResText", asciiTextWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Positive Range label
	 *  ... -> form -> Positive Range label
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Positive Range" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth,  0);
	MyXtSetArg (args, arg_cnt, XtNvertDistance, 10 );
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 0 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, res_tw );
	lb2 = XtCreateManagedWidget( "PosRange", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Negative Range label
	 *  ... -> form -> Negative Range label
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Negative Range" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth,   0);
	MyXtSetArg (args, arg_cnt, XtNvertDistance,  10 );
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 70 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, res_tw );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb2 );
	lb = XtCreateManagedWidget( "NegRange", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Pos Min label
	 *  ... -> form -> Pos Min Label
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Min:" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 20 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance, 5 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, lb2 );
	lb3 = XtCreateManagedWidget( "PosMinLabel", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Text widget for Pos. Min
	 *  ... -> Text widget for Pos min label
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNstring, "0" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb3 );
	MyXtSetArg (args, arg_cnt, XtNfromVert,  lb2 );
	MyXtSetArg (args, arg_cnt, XtNeditType, XawtextEdit );
	posmin_tw = XtCreateManagedWidget( "PosMin", asciiTextWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Neg Min label
	 *  ... -> form -> Neg Min Text label
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Min:" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth,   0);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 90 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz,    lb2 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance, 5 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, lb );
	lb4 = XtCreateManagedWidget( "NegMinLabel", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Text widget for Neg. Min
	 *  ... -> form -> Neg Min Text Ascii Input
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNstring, "0" ); /* 0 = use data */
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb4 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, lb );
	MyXtSetArg (args, arg_cnt, XtNeditType, XawtextEdit );
	negmin_tw = XtCreateManagedWidget( "NegMin", asciiTextWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Pos Max label
	 *  ... -> form -> Pos Max Text label
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Max:" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 0);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 20 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance, 5 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, lb3 );
	lb3 = XtCreateManagedWidget( "PosMaxLabel", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Text widget for Pos. Max
	 *  ... -> form -> Pos max Text Ascii input
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNstring, "0" ); /* 0 = use data */
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb3 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, posmin_tw );
	MyXtSetArg (args, arg_cnt, XtNeditType, XawtextEdit );
	posmax_tw = XtCreateManagedWidget( "PosMax", asciiTextWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Neg Max label
	 *  ... -> form -> Neg Max Text label
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Max:" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth,   0);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 90 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance,  5 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb2 );
	MyXtSetArg (args, arg_cnt, XtNfromVert,  lb4 );
	lb4 = XtCreateManagedWidget( "NegMaxLabel", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Text widget for Neg. Max
	 *  ... -> form -> Neg Max Text Ascii input
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNstring, "0" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb4 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, negmin_tw );
	MyXtSetArg (args, arg_cnt, XtNeditType, XawtextEdit );
	negmax_tw = XtCreateManagedWidget( "NegMax", asciiTextWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Pos Colors label
	 *  ... -> form -> Pos Colors label widget
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Colors:" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth,   0);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 10 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance,  5 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, lb3 );
	lb3 = XtCreateManagedWidget( "Colors", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Text widget for Pos. Colors
	 *  ... -> form -> Pos Color Ascii input
	 *
	 */

	arg_cnt = 0;
	sprintf(buf,"%d",appdata.poscolors);
	MyXtSetArg( args, arg_cnt, XtNstring, buf );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb3 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, posmax_tw );
	MyXtSetArg (args, arg_cnt, XtNeditType, XawtextEdit );
	poscol_tw = XtCreateManagedWidget( "PosColors", asciiTextWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Neg Colors label
	 *  ... -> form -> Neg Color label widget
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Colors:" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth,   0);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 80 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance,  5 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb2 );
	MyXtSetArg (args, arg_cnt, XtNfromVert,  lb4 );
	lb4 = XtCreateManagedWidget( "Colors", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Text widget for Neg. Colors
	 *  ... -> form -> Neg Color Ascii text input
	 *
	 */

	arg_cnt = 0;
	sprintf(buf,"%d",appdata.negcolors);
	MyXtSetArg( args, arg_cnt, XtNstring, buf );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb4 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, negmax_tw );
	MyXtSetArg (args, arg_cnt, XtNeditType, XawtextEdit );
	negcol_tw = XtCreateManagedWidget( "NegColors", asciiTextWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Exponent label
	 *  ... -> form -> Exponent label widget
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Exponent:" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNborderWidth,   0);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 0 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance, 20 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, NULL );
	MyXtSetArg (args, arg_cnt, XtNfromVert, poscol_tw );
	lb4 = XtCreateManagedWidget( "Exponent", labelWidgetClass,
						form, args, arg_cnt );

	/*
	 * Create Text widget for Exponent
	 *  ... -> form -> Exponent Ascii Input
	 *
	 */

	arg_cnt = 0;
	sprintf(buf,"%f",appdata.exp);
	MyXtSetArg( args, arg_cnt, XtNstring, buf );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft );
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop );
	MyXtSetArg (args, arg_cnt, XtNborderWidth,  1 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance, 20 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, lb4 );
	MyXtSetArg (args, arg_cnt, XtNfromVert, poscol_tw );
	MyXtSetArg (args, arg_cnt, XtNeditType, XawtextEdit );
	expon_tw = XtCreateManagedWidget( "ExponentText", asciiTextWidgetClass,
						form, args, arg_cnt );


#ifdef LYRE
	/* 
	 * create callback for read button 
	 *
	 */
	r_data = (caddr_t *) XtMalloc( sizeof(caddr_t) * 2 );
	r_data[0] = (caddr_t)gs;
	r_data[1] = (caddr_t)file_tw;
	XtAddCallback( file_aw, XtNcallback, DoGspecRead, (caddr_t) r_data);
#endif

	/*
	 * Create Apply button
	 *  ... -> form -> ApplyButton
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Apply" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 5 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance,  5 );
#ifdef LYRE
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, file_aw );
#else
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, ab );
#endif
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1);
	ab = XtCreateManagedWidget( "ApplyOptions", commandWidgetClass,
						form, args, arg_cnt );

 	pdid = (XtPopdownIDRec *) XtMalloc( sizeof(XtPopdownIDRec) );
	pdid->shell_widget = shell;
	pdid->enable_widget = w;


	c_data = (caddr_t *) XtMalloc( sizeof(caddr_t) * 9 );
	c_data[0] = (caddr_t)gs;
	c_data[1] = (caddr_t)res_tw;
	c_data[2] = (caddr_t)expon_tw;
	c_data[3] = (caddr_t)posmin_tw;
	c_data[4] = (caddr_t)posmax_tw;
	c_data[5] = (caddr_t)poscol_tw;
	c_data[6] = (caddr_t)negmin_tw;
	c_data[7] = (caddr_t)negmax_tw;
	c_data[8] = (caddr_t)negcol_tw;

	/*
	 * ... -> form -> Apply -> DoGspecOption(data)
	 *
	 */

	XtAddCallback( ab, XtNcallback, DoGspecOptions, c_data );

	/*
	 * Create Delete button
	 *  ... -> fomr -> Delete Button -> Destroy ()
	 *
	 */

	arg_cnt = 0;
	MyXtSetArg( args, arg_cnt, XtNlabel, "Delete Tdat" );
	MyXtSetArg (args, arg_cnt, XtNleft,   XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNright,  XtChainLeft);
	MyXtSetArg (args, arg_cnt, XtNtop,    XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNbottom, XtChainTop);
	MyXtSetArg (args, arg_cnt, XtNhorizDistance, 5 );
	MyXtSetArg (args, arg_cnt, XtNvertDistance,  5 );
	MyXtSetArg (args, arg_cnt, XtNfromHoriz, ab );
	MyXtSetArg (args, arg_cnt, XtNborderWidth, 1);
	ab = XtCreateManagedWidget( "DeleteWindow", commandWidgetClass,
						form, args, arg_cnt );

	XtAddCallback( ab, XtNcallback, Destroy, new);


	/* give the min and max text widgets to the gscale widget
	   so they can be set on a read */
	
	arg_cnt = 0;
	MyXtSetArg(args, arg_cnt, XtNpminWidget, posmin_tw);
	MyXtSetArg(args, arg_cnt, XtNpmaxWidget, posmax_tw);
	MyXtSetArg(args, arg_cnt, XtNnminWidget, negmin_tw);
	MyXtSetArg(args, arg_cnt, XtNnmaxWidget, negmax_tw);
	XtSetValues(gs,args,arg_cnt);

	return( shell );
}


/*
 * DoGspecRead (w, data)
 *
 * Read Button in Spectrogram menu
 * Read spectrogram file, and apply parameters retrieved
 *
 * w    (in): widget where this procedure was called from (not used)
 * data (in): pointer to Tdat data structure
 *
 */

static void DoGspecRead( Widget w, caddr_t *data )
{
  GspecWidget child;
  Arg         args[10];
  int         arg_cnt;
  Arg         args2[10];
  int         arg2_cnt;
  Widget tw;
  char   *tmp;
  char   *c;
  union {
    float f;
    unsigned int i;
  } floatint;

  child = (GspecWidget) data[0];                   /* Spectrogram widget    */
  tw    = (Widget) data[1];                        /* file name text widget */

  arg_cnt = 0;
  MyXtSetArg( args, arg_cnt, XtNstring, &tmp );      /* dft file name */
  XtGetValues( tw, args, arg_cnt );
  ReadSpecFile( child, tmp );
}


/*
 * DoGspecOptions ( w, data)
*
 * Apply options in popup window to spectrogram
 *
 * data (in): pointer to Tdat data structure containing pertinet
 *            information for scaling the dft image
 *
 */

static void DoGspecOptions( Widget w, caddr_t *data )
{
  GspecWidget child;
  Arg    args[10];
  Arg    args2[10];
  int    arg_cnt;
  int    arg_cnt2;
  Widget tw;
  char   *tmp;
  char   *c;
  int    i;
  union {
    float f;
    unsigned int i;
  } ftoi;

  child = (GspecWidget) data[0];    /* graphics widget for spectrogram */
  arg_cnt2 = 0;

  /* 
   * Set Resolution
   */
  tw      = (Widget) data[1];     /* resolution text widget           */
  arg_cnt = 0;
  MyXtSetArg( args, arg_cnt, XtNstring, &tmp );
  XtGetValues( tw, args, arg_cnt );
  ftoi.f  = (float) atof( tmp );
  MyXtSetArg (args2, arg_cnt2, XtNsecsPpix, ftoi.i);

  /*
   * Set Exponent
   */
  tw      = (Widget) data[2];   /* Exponent text widget               */
  arg_cnt = 0;
  MyXtSetArg( args, arg_cnt, XtNstring, &tmp );
  XtGetValues( tw, args, arg_cnt );
  ftoi.f  = (float) atof( tmp );
  MyXtSetArg (args2, arg_cnt2, XtNexp, ftoi.i);

  /*
   * Set Positive range Max
   */
  tw      = (Widget) data[4];  /* Positive range Max text widget      */
  arg_cnt = 0;
  MyXtSetArg( args, arg_cnt, XtNstring, &tmp );
  XtGetValues( tw, args, arg_cnt );
  ftoi.f  = (float) atof( tmp );
  MyXtSetArg (args2, arg_cnt2, XtNposmax, ftoi.i);
	
  /*
   * Set Positive range Min
   */

  tw      = (Widget) data[3]; /* Positive range Min text widget      */
  arg_cnt = 0;
  MyXtSetArg( args, arg_cnt, XtNstring, &tmp );
  XtGetValues( tw, args, arg_cnt );
  ftoi.f  = (float) atof( tmp );
  MyXtSetArg (args2, arg_cnt2, XtNposmin, ftoi.i);

  /*
   * Set Positive colors
   */
  tw      = (Widget) data[5];   /* Positive colors text widget      */ 
  arg_cnt = 0;
  MyXtSetArg( args, arg_cnt, XtNstring, &tmp );
  XtGetValues( tw, args, arg_cnt );
  i       = atoi( tmp );
  MyXtSetArg (args2, arg_cnt2, XtNposcolors, i);

  /*
   * Set Negative range Min
   */
  tw      = (Widget) data[6];  /* Negative Range min text widget   */
  arg_cnt = 0;
  MyXtSetArg( args, arg_cnt, XtNstring, &tmp );
  XtGetValues( tw, args, arg_cnt );
  ftoi.f  = (float) atof( tmp );
  MyXtSetArg (args2, arg_cnt2, XtNnegmin, ftoi.i);
	
  /*
   * Set Negative range Max
   */
  tw      = (Widget) data[7];   /* Negative range max text widget */
  arg_cnt = 0;
  MyXtSetArg( args, arg_cnt, XtNstring, &tmp );
  XtGetValues( tw, args, arg_cnt );
  ftoi.f = (float) atof( tmp );
  MyXtSetArg (args2, arg_cnt2, XtNnegmax, ftoi.i);

  /*
   * Set Negative colors
   */
  tw      = (Widget) data[8];   /* Negative colors text widget   */
  arg_cnt = 0;
  MyXtSetArg( args, arg_cnt, XtNstring, &tmp );
  XtGetValues( tw, args, arg_cnt );
  i = atoi( tmp );
  MyXtSetArg (args2, arg_cnt2, XtNnegcolors, i);
  
  /* set spectogram graphics widget structure to new values      */
  XtSetValues( child, args2, arg_cnt2 ); 
}


/*
 * getDataS (w, client_data)
 *
 * (Unused)
 *
 */

static void GetDataS (Widget w, WidgetList client_data)
{
    GspecWidget child = (GspecWidget) client_data[0];
    DialogWidget dw = (DialogWidget) client_data[1];
    char *file = XawDialogGetValueString (dw);

    ReadSpecFile( child, file );
}


/*
 * int ReadSpecFile (w, file)
 *
 * Reads the spectrogram file, and sets the spectrogram graphics
 * pointer.
 *
 * file (in): name of spectrogram file to read in.
 *
 */

static int ReadSpecFile( GspecWidget w, char *file)
{
  Arg  args[10];
  int  arg_cnt;
  Arg  args2[10];
  int  arg2_cnt;
  adata_t *adata = (adata_t *) calloc (1, sizeof (adata_t));
  short   **data;
  char    **labels;
  char    buf[64];
  int     *dummy;
  AsciiHdr *hdr;
  Widget   pmintw,pmaxtw,nmintw,nmaxtw;
  char     **val;
  int      vlen;
  int      c;
  float    start, inc, win;
  char *tmp;
  union {
    float f;
    unsigned int i;
  } floatint;

  /* read in spectrogram file */
  if( TdatRead( file, (char ***)&data, &hdr ) < 0 ) {
    XtAlert ("Problems reading %s\n", file);
    return;
  }

  /* read header information and set spectrogram widget */
  xxx2adata( adata, &dummy, (char **)data, hdr );
  
  /* positive range minimum value */
  arg_cnt = 0;
  MyXtSetArg(args,arg_cnt,XtNpminWidget,&pmintw);
  XtGetValues(w,args,arg_cnt);
  
  /* positive range maximum value */
  arg_cnt = 0;
  MyXtSetArg(args,arg_cnt,XtNpmaxWidget,&pmaxtw);
  XtGetValues(w,args,arg_cnt);

  /* negative range minimum value */
  arg_cnt = 0;
  MyXtSetArg(args,arg_cnt,XtNnminWidget,&nmintw);
  XtGetValues(w,args,arg_cnt);

  /* negative range maximum value */
  arg_cnt = 0;
  MyXtSetArg(args,arg_cnt,XtNnmaxWidget,&nmaxtw);
  XtGetValues(w,args,arg_cnt);

  /* set spectrogram widget positive range min */
  arg_cnt = 0;
  floatint.f = adata->pos_min_val;
  MyXtSetArg (args, arg_cnt, XtNposmin, floatint.i);
  sprintf(buf,"%f",floatint.f);
  arg2_cnt = 0;
  MyXtSetArg(args2,arg2_cnt,XtNstring,buf);
  XtSetValues(pmintw,args2,arg2_cnt);

  /* set spectrogram widget positive range max */
  floatint.f = adata->pos_max_val;
  MyXtSetArg (args, arg_cnt, XtNposmax, floatint.i);
  sprintf(buf,"%f",floatint.f);
  arg2_cnt = 0;
  MyXtSetArg(args2,arg2_cnt,XtNstring,buf);
  XtSetValues(pmaxtw,args2,arg2_cnt);

  /* set spectrogram widget negative range min */
  floatint.f = adata->neg_min_val;
  MyXtSetArg (args, arg_cnt, XtNnegmin, floatint.i);
  sprintf(buf,"%f",floatint.f);
  arg2_cnt = 0;
  MyXtSetArg(args2,arg2_cnt,XtNstring,buf);
  XtSetValues(nmintw,args2,arg2_cnt);

  /* set spectrogram widget negative range max */
  floatint.f = adata->neg_max_val;
  MyXtSetArg (args, arg_cnt, XtNnegmax, floatint.i);
  sprintf(buf,"%f",floatint.f);
  arg2_cnt = 0;
  MyXtSetArg(args2,arg2_cnt,XtNstring,buf);
  XtSetValues(nmaxtw,args2,arg2_cnt);

  XtSetValues (w, args, arg_cnt);

  tmp = FindHeaderVal( hdr, "Rows" );
  if( tmp == NULL ) {
    /* what to do */
  }

  c = atoi( tmp );
  if( ( val = GetValueArray( hdr, "RowLabels", &vlen ) ) != NULL ) {
    if( c != vlen ) {
  XtAlert ("Number of row labels != number of rows!\nrow labels not used\n" );
    } else {
      labels = CreateLabels( val, vlen );
      
      arg_cnt = 0;
      MyXtSetArg (args, arg_cnt, XtNrowlabel, labels);
      XtSetValues (w, args, arg_cnt);
    }
  }

  tmp = FindHeaderVal( hdr, "StartTime" );
  if( tmp == NULL ) {
    start = 0.0;
  } else {
    start = (float) atof( tmp );
  }

  floatint.f = start;
  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNstart_time, floatint.i);
  XtSetValues (w, args, arg_cnt);
  
  tmp = FindHeaderVal( hdr, "Increment" );
  if( tmp == NULL ) {
    inc = 3.0;	/* assume 3ms */
  } else {
    inc = (float) atof( tmp );
  }
    
  tmp = FindHeaderVal( hdr, "WindowWidth" );
  if( tmp == NULL ) {
    win = 10.0;	/* assume 10ms */
  } else {
    win = (float) atof( tmp );
  }
    
  floatint.f = ( win - inc ) / 2.0;
  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNaoffset, floatint.i);
  XtSetValues (w, args, arg_cnt);
  
  tmp = FindHeaderVal( hdr, "SamplesPerSecond" );
  if( tmp != NULL ) {
    floatint.f = (float) atof( tmp );
    arg_cnt = 0;
    MyXtSetArg (args, arg_cnt, XtNsampsPerSec, floatint.i);
    XtSetValues (w, args, arg_cnt);
  }

  Free2d( (char **)data );
  
  /*
   * memory leak
   * need to free hdr struct
   */

  arg_cnt = 0;
  MyXtSetArg (args, arg_cnt, XtNdata, adata);
  XtSetValues (w, args, arg_cnt);
}


/*
 * char **CreateLabels(ar, len)
 *
 */

static char **CreateLabels( char **ar, int len )
{
	char **tmp;
	char **tmp1;
	int i, j;

	tmp = (char **)malloc( sizeof( char *) * len );
	if( tmp == NULL ) {
		return( NULL );
	}

	tmp1 = ar;
	for( i = 0; i < len; i++ ) {

		*(tmp+i) = (char *)malloc( strlen( tmp1[i] ) + 1 );

		if( *(tmp+i) == NULL ) {
			return( NULL );		/* memory leak */
		}

		strcpy( *(tmp+i), tmp1[i] );
	}

	return( tmp );

}

/*
 * GspecUnmap(tool)
 *
 * make a spectogram display disappear; space appears blank, not remapped 
 *
 */

int GspecUnmap( GspectoolWidget tool)
{
  XtUnmapWidget(tool->gspectool.child);
}


/*
 * GspecMap (tool)
 *
 * make an spectogram display reappear 
 *
 */

int GspecMap(GspectoolWidget tool)
{
  XtMapWidget(tool->gspectool.child);
}


/*
 * GspecPollRead (tool, file)
 *
 * Used for auto_lyre -> poll disc for lates dft file
 * read in and display
 *
 */

int GspecPollRead (GspectoolWidget tool, char *file)
{
  GspecWidget         child = (GspecWidget) tool->gspectool.child;

  if(PollForFile (file, 1 /* Interval secs */, 1 /* Attempts */) == -1)
    return -1;
  
  
  return( ReadSpecFile( child, file ) );
}


/*
 * Destroy (w, target_widget, call_data)
 *
 */

static void Destroy (Widget w, Widget target_widget, caddr_t call_data)
{
    XtDestroyWidget (target_widget);
}


/*
 * Boolean SetValues (gcurrent, grequest, gnew)
 *
 *
 */

static Boolean  SetValues (Widget gcurrent, Widget grequest, Widget gnew)
{
    GspectoolWidget         current = (GspectoolWidget) gcurrent;
    GspectoolWidget         new = (GspectoolWidget) gnew;
    GspectoolWidget         req = (GspectoolWidget) grequest;
    int                     arg_cnt = 0;
    Arg                     args[20];

    if( strcmp(new->gspectool.rowlabel, current->gspectool.rowlabel ) != 0 ) {
      
      MyXtSetArg (args, arg_cnt, XtNlabel, new->gspectool.rowlabel );
      XtSetValues (new->gspectool.rowReadout, args, arg_cnt);

    }
}

