static char *rcsident = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/Form.c,v 4.2 1993/05/28 21:27:40 johans Exp $";
#ifndef lint
static char rcsid[] = "$Header: /projects/cslu/speech/work/src/bin/auto_lyre/RCS/Form.c,v 4.2 1993/05/28 21:27:40 johans Exp $";
#endif lint


/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/FormP.h>

/* Private Definitions */


static int def0 = 0;
static int def4 = 4;
static int DEFAULTVALUE = -99999;


#define Offset(field) XtOffset(FormWidget, form.field)
static XtResource resources[] = {
    {XtNdefaultDistance, XtCThickness, XtRInt, sizeof(int),
	Offset(default_spacing), XtRInt, (caddr_t)&def4}
};
#undef Offset

static XtEdgeType defEdge = XtRubber;

#define Offset(field) XtOffset(FormConstraints, form.field)
static XtResource formConstraintResources[] = {
    {XtNtop, XtCEdge, XtREdgeType, sizeof(XtEdgeType),
	Offset(top), XtREdgeType, (caddr_t)&defEdge},
    {XtNbottom, XtCEdge, XtREdgeType, sizeof(XtEdgeType),
	Offset(bottom), XtREdgeType, (caddr_t)&defEdge},
    {XtNleft, XtCEdge, XtREdgeType, sizeof(XtEdgeType),
	Offset(left), XtREdgeType, (caddr_t)&defEdge},
    {XtNright, XtCEdge, XtREdgeType, sizeof(XtEdgeType),
	Offset(right), XtREdgeType, (caddr_t)&defEdge},
    {XtNhorizDistance, XtCThickness, XtRInt, sizeof(int),
	Offset(dx), XtRInt, (caddr_t)&DEFAULTVALUE},
    {XtNfromHoriz, XtCParameter, XtRWidget, sizeof(Widget),
	Offset(horiz_base), XtRWidget, (caddr_t)NULL},
    {XtNvertDistance, XtCThickness, XtRInt, sizeof(int),
	Offset(dy), XtRInt, (caddr_t)&DEFAULTVALUE},
    {XtNfromVert, XtCParameter, XtRWidget, sizeof(Widget),
	Offset(vert_base), XtRWidget, (caddr_t)NULL},
    {XtNresizable, XtCBoolean, XtRBoolean, sizeof(Boolean),
	Offset(allow_resize), XtRInt, (caddr_t)&def0},
};
#undef Offset

/* Header declarations for procedures used in this module */
static void Initialize (Widget request, Widget new, ArgList arglist,
			Cardinal *num_args);
static void RefigureLocations(Widget w);
static Position TransformCoord(register Position loc, Dimension old, 
			       Dimension new, XtEdgeType type);
static void Resize (Widget w);
static XtGeometryResult GeometryManager(Widget w, XtWidgetGeometry *request,
                                                  XtWidgetGeometry *reply);
static Boolean SetValues (Widget current, Widget request, Widget new,
			  ArgList arglist, Cardinal *num_args);
static void ConstraintInitialize (Widget request, Widget new, ArgList arglist,
				  Cardinal *num_args);
static Boolean ConstraintSetValues (Widget current, Widget request, 
				    Widget new, ArgList arglist, 
				    Cardinal *num_args);
static void ChangeManaged (Widget w);
void XtFormDoLayout(Widget w, Boolean doit);


FormClassRec formClassRec = {
  { /* core_class fields */
    /* superclass         */    (WidgetClass) &constraintClassRec,
    /* class_name         */    "Form",
    /* widget_size        */    sizeof(FormRec),
    /* class_initialize   */    NULL,
    /* class_part_init    */    NULL,
    /* class_inited       */    FALSE,
    /* initialize         */    Initialize,
    /* initialize_hook    */    NULL,
    /* realize            */    XtInheritRealize,
    /* actions            */    NULL,
    /* num_actions        */    0,
    /* resources          */    resources,
    /* num_resources      */    XtNumber(resources),
    /* xrm_class          */    NULLQUARK,
    /* compress_motion    */    TRUE,
    /* compress_exposure  */    TRUE,
    /* compress_enterleave*/    TRUE,
    /* visible_interest   */    FALSE,
    /* destroy            */    NULL,
    /* resize             */    Resize,
    /* expose             */    XtInheritExpose,
    /* set_values         */    SetValues,
    /* set_values_hook    */    NULL,
    /* set_values_almost  */    XtInheritSetValuesAlmost,
    /* get_values_hook    */    NULL,
    /* accept_focus       */    NULL,
    /* version            */    XtVersion,
    /* callback_private   */    NULL,
    /* tm_table           */    NULL,
    /* query_geometry     */	NULL,		/* %%% fix this! */
     /* display_accelerator */	XtInheritDisplayAccelerator,	
     /* extension	    */	NULL,
  },
  { /* composite_class fields */
    /* geometry_manager   */   GeometryManager,
    /* change_managed     */   ChangeManaged,
    /* insert_child       */   XtInheritInsertChild,
    /* delete_child       */   XtInheritDeleteChild,
  },
  { /* constraint_class fields */
    /* subresourses       */   formConstraintResources,
    /* subresource_count  */   XtNumber(formConstraintResources),
    /* constraint_size    */   sizeof(FormConstraintsRec),
    /* initialize         */   ConstraintInitialize,
    /* destroy            */   NULL,
    /* set_values         */   ConstraintSetValues
  },
  { /* form_class fields */
    /* empty              */   0
  }
};

WidgetClass formWidgetClass = (WidgetClass)&formClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/


/* 
 * Initialize (request, new)
 *
 */

static void Initialize(Widget request, Widget new, ArgList arglist,
		       Cardinal *num_args)
{
    FormWidget fw = (FormWidget)new;

    fw->form.old_width = fw->core.width;
    fw->form.old_height = fw->core.height;
    fw->form.no_refigure = 0;
    fw->form.needs_relayout = FALSE;
}


/*
 * RefigureLocations (w)
 *
 */

static void RefigureLocations(Widget w)
{
    FormWidget fw = (FormWidget)w;
    int num_children = fw->composite.num_children;
    WidgetList children = fw->composite.children;
    Widget *childP;
    Position x, y, maxx, maxy;

    if (fw->form.no_refigure) {
	fw->form.needs_relayout = TRUE;
	return;
    }

    maxx = maxy = 1;
    for (childP = children; childP - children < num_children; childP++) {
	FormConstraints form = (FormConstraints)(*childP)->core.constraints;
	if (!XtIsManaged(*childP)) continue;
	x = form->form.dx;
	y = form->form.dy;
	if (form->form.horiz_base)
	    x += form->form.horiz_base->core.x
	         + form->form.horiz_base->core.width
	         + (form->form.horiz_base->core.border_width << 1);
	if (form->form.vert_base)
	    y += form->form.vert_base->core.y
	         + form->form.vert_base->core.height
	         + (form->form.vert_base->core.border_width << 1);
	XtMoveWidget( *childP, x, y );
	x += (*childP)->core.width  + ((*childP)->core.border_width << 1);
	y += (*childP)->core.height + ((*childP)->core.border_width << 1);
	if (maxx < x) maxx = x;
	if (maxy < y) maxy = y;
    }

    maxx += fw->form.default_spacing;
    maxy += fw->form.default_spacing;
    if (maxx != fw->core.width || maxy != fw->core.height) {
	XtGeometryResult result;
	result = XtMakeResizeRequest( w, (Dimension)maxx, (Dimension)maxy,
				      (Dimension*)&maxx, (Dimension*)&maxy );
	if (result == XtGeometryAlmost)
	    XtMakeResizeRequest( w, (Dimension)maxx, (Dimension)maxy,
				 NULL, NULL );
	fw->form.old_width  = fw->core.width;
	fw->form.old_height = fw->core.height;
	Resize (w);
    }

    fw->form.needs_relayout = FALSE;
}


/*
 * Position TransformCoord (loc, old, new, type)
 *
 */

static Position TransformCoord(register Position loc, Dimension old, 
			       Dimension new, XtEdgeType type)
{
    if (type == XtRubber) {
        if (old > 0)
	    loc = (loc * (Position)new) / (Position)old;
    }
    else if (type == XtChainBottom || type == XtChainRight)
	loc += (Position)new - (Position)old;

    return (loc > 0) ? loc : 0;
}


/*
 * Resize (w)
 *
 */

static void Resize(Widget w)
{
    FormWidget fw = (FormWidget)w;
    WidgetList children = fw->composite.children;
    int num_children = fw->composite.num_children;
    Widget *childP;
    Position x, y;
    int width, height;

    for (childP = children; childP - children < num_children; childP++) {
	FormConstraints form = (FormConstraints)(*childP)->core.constraints;
	if (!XtIsManaged(*childP)) continue;
	x = TransformCoord( (*childP)->core.x, fw->form.old_width,
			    fw->core.width, form->form.left );
	y = TransformCoord( (*childP)->core.y, fw->form.old_height,
			    fw->core.height, form->form.top );
	width =
	  TransformCoord((Position)((*childP)->core.x
				    + (*childP)->core.width
				    + (*childP)->core.border_width),
			 fw->form.old_width, fw->core.width,
			 form->form.right ) -x - (*childP)->core.border_width;
	height =
	  TransformCoord((Position)((*childP)->core.y
				    + (*childP)->core.height
				    + (*childP)->core.border_width),
			 fw->form.old_height, fw->core.height,
			 form->form.bottom ) -y - (*childP)->core.border_width;
	if (form->form.right == XtChainRight) {
	    int diff = (x + width + ((*childP)->core.border_width << 1) +
			fw->form.default_spacing) - fw->core.width;
	    if (diff > 0)
		width -= diff;
	}
	if (width < 1) width = 1;
	if (form->form.bottom == XtChainBottom) {
	    int diff = (y + height + ((*childP)->core.border_width << 1) +
			fw->form.default_spacing) - fw->core.height;
	    if (diff > 0)
		height -= diff;
	}
	if (height < 1) height = 1;

	XtMoveWidget( (*childP), x, y );
	XtResizeWidget( (*childP), (Dimension)width, (Dimension)height,
		        (*childP)->core.border_width );
    }

    fw->form.old_width = fw->core.width;
    fw->form.old_height = fw->core.height;
}


/*
 * XtGeometryResult GeometryManager(w, request, reply)
 *
 */

static XtGeometryResult GeometryManager(Widget w, XtWidgetGeometry *request, 
                                                  XtWidgetGeometry *reply)
{
    FormConstraints form = (FormConstraints)w->core.constraints;
    XtWidgetGeometry allowed;

    if ((request->request_mode & ~(CWWidth | CWHeight)) ||
	!form->form.allow_resize)
	return XtGeometryNo;

    if (request->request_mode & CWWidth)
	allowed.width = request->width;
    else
	allowed.width = w->core.width;

    if (request->request_mode & CWHeight)
	allowed.height = request->height;
    else
	allowed.height = w->core.height;

    if (allowed.width == w->core.width && allowed.height == w->core.height)
	return XtGeometryNo;

    w->core.width = allowed.width;
    w->core.height = allowed.height;
    RefigureLocations( w->core.parent );
    return XtGeometryYes;
}



/* 
 * Boolean SetValues (current, request, new)
 *
 */

static Boolean SetValues(Widget current, Widget request, Widget new,
			 ArgList arglist, Cardinal *num_args)
{
    return( FALSE );
}


/* 
 * ConstraintInitialize (request, new)
 *
 */

static void ConstraintInitialize(Widget request, Widget new, ArgList arglit,
				 Cardinal *num_args)
{
    FormConstraints form = (FormConstraints)new->core.constraints;
    FormWidget fw = (FormWidget)new->core.parent;

    if (form->form.dx == DEFAULTVALUE)
        form->form.dx = fw->form.default_spacing;

    if (form->form.dy == DEFAULTVALUE)
        form->form.dy = fw->form.default_spacing;
}


/*
 * Boolean ConstraintSetValues (current, request, new)
 *
 */

static Boolean ConstraintSetValues(Widget current, Widget request, Widget new,
				   ArgList arglist, Cardinal *num_args)
{
    return( FALSE );
}


/*
 * ChangeManaged (w)
 *
 */

static void ChangeManaged(Widget w)
{
#ifdef notdef
    FormWidget fw = (FormWidget)w;
    WidgetList children = fw->composite.children;
    int num_children = fw->composite.num_children;
    Widget child, *childP, *unmanagedP;

    unmanagedP = NULL;
    for (childP = children; childP - children < num_children; childP++) {
	if (XtIsManaged(*childP)) {
	    if (unmanagedP) {
		child = *unmanagedP;
		*unmanagedP = *childP;
		*childP = child;
		childP = unmanagedP;	/* simplest to just backtrack */
	    }
	}
	else {
	    if (!unmanagedP)
		unmanagedP = childP;
	}
    }
#endif
    RefigureLocations( w );
}
    


/**********************************************************************
 *
 * Public routines
 *
 **********************************************************************/


/* 
 * XtFormDoLayout (w, doit)
 *
 * Set or reset figuring (ignored if realized)
 *
 */

void XtFormDoLayout(Widget w, Boolean doit)
{
    register FormWidget fw = (FormWidget)w;

    if (doit && fw->form.no_refigure > 0)
	fw->form.no_refigure--;
    else
	if (!XtIsRealized(w))
	    fw->form.no_refigure++;

    if (fw->form.needs_relayout)
	RefigureLocations( w );
}
