/* file = rwin.c */
/* real-time window display of the match scores for each template,
   ie, the wordspotting results  */ 
/* Nigel Ward, University of Tokyo, April 1994 */

#include "cheap.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* !!!!! this calls routines which use the same global variables (eg win)
   as used by showmatch etc; could be dangerous if someday I want a program
   that uses two display windows at once !!!! */

static float min_dist;

#define CANVAS_HEIGHT  800
#define YSPACING 20
#define E_YGAIN 4000.0  /* this is approx 50 times a good score */
#define L_YGAIN .8      /* this is approx 50 times a good score from log templates */

#define YMARGIN 20 
#define XMARGIN 100 
#define CANVAS_WIDTH (2 * XMARGIN + (MAX_SAMPLES / SAMPLES_PER_PIXEL))
#define BOX_HEIGHT 16

/*-----------------------------------------------------------------------------*/
prepare_realtime_canvas(ntemplates, templates)
     int ntemplates; struct signature templates[];
{ int i;

  sg_create(CANVAS_WIDTH, CANVAS_HEIGHT, FALSE, "wordstart likelihoods"); 
  /* want to be sure window is up before drawing, let alone reading audio */
  sg_wait_for_mapping(); 

  /* sg_clear(); */
  /* mark the x axis by drawing vertical lines every one second */
  for (i = 0; i <= MAX_SECONDS; i++) {
    /* 100 frames per second */
    sg_line(xpos_for_frame(100 * i), 0, xpos_for_frame(100 * i), CANVAS_HEIGHT); } 
  draw_y_axis(2, ntemplates);
  draw_template_labels(2, ntemplates, templates);
  sg_flush();
}

draw_template_labels(x, ntemplates, templates)
     int x, ntemplates; struct signature templates[];
{ int i;
  for (i =0; i < ntemplates; i++) {
    sg_string(6 + x, YMARGIN + (1 + i) * YSPACING + (BOX_HEIGHT - 2) ,
	      templates[i].info_string); } }

clean_up_realtime_canvas()
{ sg_close();}

draw_right_y_axis(ntemplates, input_len)     int ntemplates, input_len;
{  draw_y_axis(10 + xpos_for_frame(input_len), ntemplates); }

draw_right_template_labels(ntemplates, templates, input_len)
     int ntemplates; struct signature templates[]; int input_len;
{  draw_template_labels(10 + xpos_for_frame(input_len), ntemplates, templates); }

draw_y_axis(x1, ntemplates)     int x1, ntemplates;
{
  int i;
  for (i = 0; i < ntemplates; i++)
    sg_outline_rect(x1, YMARGIN + (1 + i) * YSPACING, (XMARGIN - 2) - 2, BOX_HEIGHT); 
}

draw_likelihood(frame, tnum, yvalue, logp)      int frame, tnum; float yvalue; int logp;
{ int x, y0, y1;
  x = xpos_for_frame(frame);
  y0 = YMARGIN + (1 + tnum) * YSPACING + BOX_HEIGHT;
  if (logp)
    y1 = y0 - (int) (L_YGAIN / yvalue);
  else
    y1 = y0 - (int) (E_YGAIN / yvalue);
  sg_line(x, y0, x, y1);
  /* draw a white shadow on top of the bar,
     so it's still visible even if it's so tall that it runs into the next bar up */
  sg_preset(x, y1 - 1);   sg_preset(x, y1 - 2);   sg_preset(x, y1 - 3);
}

/* 2 pixel spacing between frames */
int xpos_for_frame(frame)    int frame;
{  return(XMARGIN + frame * 2);}


/* ============================================================================= */
