/* file = match.c */ 
/* matches some templates (.fe format) against an unknown input (also in .fe format),
   and writes the results to a .wh file */
/* Nigel Ward, University of Tokyo, April 1994 */

/* ----------------------------------------------------------------------------- */
#include "cheap.h"

int verbosep = FALSE;         
int normalizep = TRUE;
int realtime_winp = FALSE;
int prunep = TRUE;

static FILE *input_fp = NULL;
static FILE *output_fp = NULL;
static char out_path[MAX_PATH_LEN];

/* ----------------------------------------------------------------------------- */
read_input(input_sig_ptr)       struct signature *input_sig_ptr;
{ int result;
  fprintf(stderr, " match: reading input ...\n");
  result = read_fe_into_sig(input_fp, input_sig_ptr);
  if (result == FALSE) {fprintf(stderr, "\nmatch: read failed \n" ); exit(STRANGE);};
  if (strcmp(input_sig_ptr->feature_type, "melcepstrum") == 0 && normalizep)
    { printf("match: melcepstrum already normalized\n"); normalizep = FALSE;}
}

/* ----------------------------------------------------------------------------- */
int process_match_options(argc, argv)
     int argc; char *argv[];
{
  int i, last_arg_read;     

  last_arg_read = 0;
  for (i = 1; i < argc && argv[i][0] == '-'; i++) {
    switch(argv[i][1]) {
    case NULL:       /* pipe mode: use std input */
      input_fp = stdin;
      output_fp = stdout;
      break;
    case 'v':   verbosep = TRUE;      break;
    case 'u':   normalizep = FALSE;   break;
    case 's':   prunep = FALSE;       break;
    case 'h':   match_usage(); exit(NORMAL);    break;
    default:  
      fprintf(stderr, "   (%c is not a known option)\n", argv[i][0]);
      match_usage(); exit(STRANGE); break;
    } 
    last_arg_read++;  }
  return(last_arg_read);
}

/*-----------------------------------------------------------------------------*/
process_input_filename(filename)      char *filename;
{
  char new_path[MAX_PATH_LEN];
  make_new_path(new_path, filename, ".fe");
  input_fp = fopen_or_exit(new_path, "r");
  make_new_path(out_path, filename, ".wh");
  output_fp = fopen_or_exit(out_path, "w"); 
}

/*-----------------------------------------------------------------------------*/

match_usage()    
{
  fprintf(stderr, "usage: \n");
  fprintf(stderr, "   match [options] input_file [template_file]*\n");
  fprintf(stderr, "Options \n");
  fprintf(stderr, "  -    pipe mode (reads from standard input)\n");
  fprintf(stderr, "  -v   run verbosely \n");
  fprintf(stderr, "  -u   match unnormalized (w/o energy-based normalization) \n");
  fprintf(stderr, "  -s   go slow, no pruning \n");
  fprintf(stderr, " after the options should be the template files (any number). \n");
  exit(8);
}

/* ----------------------------------------------------------------------------- */
main(argc, argv)      int argc;      char *argv[];
{
  int start_arg;
  struct signature input_sig;

  start_arg = 1 + process_match_options(argc, argv);

  if (input_fp != stdin) {
    if(start_arg >= argc) {fprintf(stderr, "match: no input file\n"); exit(STRANGE);}
    process_input_filename(argv[start_arg]);
    start_arg++;}
  /* the remaining arguments are a list of templates to use */
  process_template_filenames(argc, argv, start_arg);

  read_input(&input_sig);
  check_compatibility(&input_sig);

  pre_match_initialization();
  match_by_templates(&input_sig);
  /* note that we could, alternatively, do 
     incremental_match(0, input_sig.nframes, &input_sig);
     but that is less effective at pruning (because of most_likely_offset) */

  sort_and_output_templates(&input_sig, output_fp);
  exit(NORMAL);
}

/* ----------------------------------------------------------------------------- */
