/* file = feat.c */
/* featurizes a speech sample: converts from .au to .fe format */
/* Nigel Ward, University of Tokyo, April 1994 */

/* ----------------------------------------------------------------------------- */
#include "cheap.h"  

static int windowp;
static struct signature sig;

/* ----------------------------------------------------------------------------- */
int process_featurize_args(argc, argv)
     int argc; char *argv[];
{
  int i;  int last_arg_read = 0;  

  sig.nbins = DEFAULT_NBINS;             /* default */
  sig.frame_period = FRAME_SPACING;
  strcpy(sig.feature_type, "filterbank");
  sig.logp = TRUE;

  for (i = 1; i < argc && argv[i][0] == '-'; i++) {
    switch(argv[i][1]) {
    case 'e':   sig.logp = FALSE;    break;
    case 'w':   windowp = TRUE;      break;
    case 'h':   featurize_usage(); exit(NORMAL);    break;
    default:      
      fprintf(stderr, "   (%c is not a known option)\n", argv[i][1]);
      featurize_usage(); exit(STRANGE); break;
    } 
    last_arg_read =  i;
  }
  sig.frame_shift = SAMPLING_RATE * sig.frame_period / 1000;
  return(last_arg_read);
}

/* ----------------------------------------------------------------------------- */
featurize_usage()    
{
  fprintf(stderr, "usage: \n");
  fprintf(stderr, "   feat [options] [input_file.au]*\n");
  fprintf(stderr, "Options \n");
  fprintf(stderr, "  -e   use energy, not log of energy (faster but worse) \n");
  fprintf(stderr, "  -w   show output in a window\n");
  exit(STRANGE); }

/* ----------------------------------------------------------------------------- */
main(argc,argv)        int argc; char *argv[]; 
{
  int i, start_arg;

  argv[argc] = NULL;
  start_arg = 1 + process_featurize_args(argc, argv);
  if (windowp) {
    prepare_features_canvas(); }

  if (start_arg >= argc) {
    fprintf(stderr,"feat: no .au files specified, exiting\n");
    exit(STRANGE);  } 
  for(i = start_arg; i < argc; i++) {
    printf( "  processing, path = %s \n", argv[i]);
    do_au_file(argv[i], &sig, windowp); 
  }
  exit(NORMAL);
}
/*-----------------------------------------------------------------------------*/
