/*	@(#)sfheader.h	1.2   7/12/91		*/
/*
  Copyright (C) 1994 Edmund Lai.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*  === Speech Recognition Research Program Library ===
 *
 *		=== SFHEADER.H ===
 *
 *  Description:
 *	This file defines structures of the headers of the
 *	various kinds of speech analysis and data files.
 *	All headers must be 128 bytes long.
 *
 *  Author:
 *	Edmund Lai
 *	Department of Electrical & Electronic Engineering
 *	The University of Western Australia.
 *
 *=======================================================*/

#define usr_int short			/* For 32-bit machines */

#define bin_data_id	"BIN"		/* Binary sample data file */
#define lpc_id		"LPC"		/* LPC coefficient files   */
#define fft_id		"FFT"		/* FFT coefficient files   */
#define cep_id		"CEP"		/* Cepstral coefficient files */
#define comb_id		"COM"		/* Combination of CEP and differenced CEP files */
#define vqcodebook_id	"VQC"		/* Vector quantizer codebook file */
#define hmm_id		"HMM"		/* Hidden Markov Model files */


struct Data_file_Header {
	char		type_of_file[4];
	char		speaker_id[30];
	char	 	sample_freq[6];		/* Sampling frequency in Hertz */
	char		speech[30];
	char		preemphasis;		/* Pre-emphasis flag -- 'Y' if pre-emphasized */
	char		sample_bits[3];		/* Sampling bits */
	char		signed_data;			/* Signed -- 'Y' if data is in two's complement signed */
	char		reserved[53];		/* Reserved for future use */
};


struct Analysis_file_Header {
	char		type_of_file[4];
	char		speaker_id[30];
	char		sample_freq[6];		/* Sampling frequency in Hertz */
	usr_int		order;			/* No. of coefficients per frame */
	usr_int		frame_length;		/* Frame length in number of samples */
	usr_int		adv;			/* Advancement in number of samples per frame */
	char		speech[30];
	char		preemphasis;		/* Pre-emphasis flag 'Y' or 'N' */
	char		sample_bits[3];		/* Sampling bits */
	char		signed_data;			/* Signed -- 'Y' if data is in two's complement signed */
	char		reserved[47];
};


struct Code_file_Header {
	char		type_of_file[4];
	usr_int		dimension;		/* Dimension of code vectors */
	usr_int		size;			/* Code Book size */
	usr_int		ntrain;			/* Number of training vectors */
	char		reserved[118];
};

struct Quantised_file_Header {
	char		type_of_file[4];
	char		speaker_id[30];
	char		sample_freq[6];		/* Sampling frequency in Hertz */
	usr_int		order;			/* No. of coefficients per frame */
	usr_int		frame_length;		/* Frame length in number of samples */
	usr_int		adv;			/* Advancement in number of samples per frame */
	char		speech[30];
	char		preemphasis;		/* Pre-emphasis flag 'Y' or 'N' */
	char		code_book[30];		/* Code book used to Quantise */
	char		sample_bits[3];		/* Sampling bits */
	char		signed_data;			/* Signed -- 'Y' if data is in two's complement signed */
	char		reserved[17];
};


struct HMM_file_Header {
	char		type_of_file[4];
	char		reserved[124];
};


typedef struct Data_file_Header 	DHeader;
typedef struct Analysis_file_Header 	AHeader;
typedef struct Code_file_Header		CHeader;
typedef struct HMM_file_Header		MHeader;
typedef struct Quantised_file_Header	QHeader;
