/*
  title:    colours.h
  purpose:  Allows 3D color set to be modified during operation by
    creating a separate sub-window for which RGB values may be
    controlled using sliders.  Intended for linking into fview.

  author:   Gareth Lee
  date:     06-12-93
  modified: 15-02-94

  Copyright (C) 1994 Gareth Lee.
     
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  changes:
  08-12-93: 3D colours menu completed.
  15-02-94: prototype for ColorHideWindow added.
*/

extern Xv_opaque  ColorFrame;
extern Xv_opaque  ColorPanel;
extern Xv_opaque  ColorSliderR;
extern Xv_opaque  ColorSliderG;
extern Xv_opaque  ColorSliderB;
extern Xv_opaque  ColSelector;
extern Xv_opaque  ColorCanvas;

/* function prototypes */
void CreateRGBSlider(Xv_opaque panel, int x, int y, int space);
void CreateColorWindow(Xv_opaque parent);
void ColorDismissCallback(void);
void ColorExposeWindow(void);
void ColorHideWindow(void);

/* end of colours.h */
