/*  ----------------------  DATA FILE READ ROUTINES  -----------------------  */
/*  -----------------------  Sun FORTRAN Interface  ------------------------  */
/*  -----------------  Interface Version 1.0   June 1988  ------------------  */
/*  ------------------------------------------------------------------------  */

#include "diskio.h"

/*  -------------------  OPEN VARIABLE CHANNEL ROUTINE  --------------------  */

open_var_channel_ ( filename, var_name, fn_leng, vn_leng )

char filename[], var_name[];
int fn_leng, vn_leng;

{
   char *add_null(), ts[MAX_VARNAME_LENG+1];
   strcpy(ts, add_null(var_name, vn_leng) );
   return( open_var_channel(add_null(filename, fn_leng), ts) );
}

/*  ---------------------  OPEN BLOCK CHANNEL ROUTINE  ---------------------  */

open_block_channel_ ( filename, fn_leng )

char filename[];
int fn_leng;

{
   char *add_null();
   return( open_block_channel( add_null(filename, fn_leng) ) );
}

/*  ------------------------  READ FORMAT ROUTINE  -------------------------  */

read_format_ ( filename, format, vname, fn_leng, vn_leng )

char filename[], *vname;
int format[], fn_leng, vn_leng;

{
   char *add_null(), *vnames[MAX_VARS_PER_BLK];
   int i;
   for(i=0; i<MAX_VARS_PER_BLK; i++) vnames[i] = vname + i*vn_leng;
   return( read_format(add_null(filename, fn_leng), format, vnames) );
}

/*  ------------------------  FILE LENGTH ROUTINE  -------------------------  */

file_length_ ( channel_p, bytes, samples, blocks )

int *channel_p, *bytes, *samples, *blocks;

{
   return( file_length(*channel_p, bytes, samples, blocks) );
}

/*  ------------------------  GOTO SAMPLE ROUTINE  -------------------------  */

goto_sample_ ( channel_p, sample_num_p, how_p )

int *channel_p, *sample_num_p, *how_p;

{
   return( goto_sample(*channel_p, *sample_num_p, *how_p) );
}

/*  -----------------------  READ VARIABLE ROUTINE  ------------------------  */

read_variable_ ( channel_p, values, n_p, n_read )

int *channel_p, *n_p, *n_read;
char values[];

{
   return( read_variable(*channel_p, values, *n_p, n_read) );
}

/*  ------------------------  GOTO BLOCK ROUTINE  --------------------------  */

goto_block_ ( channel_p, block_num_p, how_p )

int *channel_p, *block_num_p, *how_p;

{
   return( goto_block(*channel_p, *block_num_p, *how_p) );
}

/*  ------------------------  READ BLOCK ROUTINE  --------------------------  */

read_block_ ( channel_p, val_pntr )

char *val_pntr[];
int *channel_p;

{
   return( read_block(*channel_p, val_pntr) );
}

/*  -----------------------  CLOSE CHANNEL ROUTINE  ------------------------  */

close_channel_ ( channel_p )

int *channel_p;

{
   return( close_channel(*channel_p) );
}

/*  ----------------------  DISK READ ERROR ROUTINES  ----------------------  */

print_disk_read_error_ ( err_num_p )

int *err_num_p;

{
   print_disk_read_error(*err_num_p);
   return;
}

/* NO FORTRAN INTERFACE TO DISK_READ_ERROR YET */

/*  ------------------------------  add_null  ------------------------------  */

#define MAX_STRING_LENGTH   100

static char *add_null(string, length)

char string[];
int length;

{
   static char ts[MAX_STRING_LENGTH + 1];
   int i;

   if (length > MAX_STRING_LENGTH) length = MAX_STRING_LENGTH;
   for (i=0; i<length; i++) ts[i] = string[i]; /* copy input string */
   ts[length] = '\0';               /* and terminate it with a null */
   i = length - 1;      /* start at end of string */
   while (ts[i] == ' ') ts[i--] = '\0';  /* change trailing blanks to nulls */
   return(ts);
}
