/**************************************************************************
*
* ROUTINE
*               segsnr
*
* FUNCTION
*                
*               calculate average segmental SNR 
*
* SYNOPSIS
*               subroutine segsnr(s, ts, sumsnr, framesnr, snrflag)
*
*   formal 
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       s		float	i	"reference" speech input
*	ts		short	i	"test" speech input
*	l		int	i	number of samples
*	sumsnr		float	o	average snr
*	framesnr	int	o	number of calculations averaged
*	snrflag		int	o	flag for valid snr value
*
***************************************************************************
*
* DESCRIPTION
*
*
***************************************************************************
*
* CALLED BY
*
*       celp
*
* CALLS
*
*       
*
**************************************************************************/
#include <math.h>
#define TRUE	1
#define FALSE	0
segsnr(s, ts, l, sumsnr, framesnr, snrflag)
int l, *framesnr, *snrflag;
short ts[];
float s[], *sumsnr;
{
  int j;
  float seng = 0.0, neng = 0.0, snr;

  *snrflag = FALSE;
  for (j = 0; j < l; j++)
  {
    seng += s[j] * s[j];
    neng += (s[j] - ts[j]) * (s[j] - ts[j]);
  }
  if (neng > 0.0)
  {
    snr = seng / neng;
    if (snr > 0.0)
    {			
    /*  *only include segments whose snr is between -10 dB and 64 dB	*/

      if (10*log10(snr) > -10. && 10*log10(snr) < 64.)
      {
        *snrflag = TRUE;
        *sumsnr += snr;
        (*framesnr)++;
      }
    }
  }
}
