/**************************************************************************
*
* NAME
*	rctopc
*
* FUNCTION
*
*	convert reflection coefficients into lpc coefficients
*
*	BEWARE:  This code does not use memory efficiently.
*
* SYNOPSIS
*
*	subroutine rctopc(k, pc, p)
*
*   formal 
*                       data	I/O
*	name		type	type	function
*	-------------------------------------------------------------------
*	k		float	i	reflection coefficients (m)
*	pc		float	o	predictor parameters (m+1: a(1)=1.0)
*	p		int	i	predictor order
*
***************************************************************************
*	
* DESCRIPTION
*
*	Converts reflection coefficients into lpc coefficients.
*
*	CELP's LPC predictor coefficient convention is:
*              p+1         -(i-1)
*       A(z) = SUM   a   z          where a  = +1.0
*              i=1    i                    1
*
*
***************************************************************************
*
* CALLED BY
*
*	autohf   celp
*
* CALLS
*
*
***************************************************************************
*	
* REFERENCES
*
*	Rabiner & Schafer, Digital Processing of Speech Signals,
*	Prentice-Hall, 1978, p. 443, equations 8.131a&b&c.
*
**************************************************************************/
#include "ccsub.h"
rctopc(k, pc, p)
int p;
float k[], pc[];
{
  int i, j;
  float a[MAXNO+1][MAXNO+1];

  /* *intialize the array						 */

  for (i = 0; i <= p; i++)
  {
    for (j = 0; j <= p; j++)
    {
      a[j][i] = 0.0;
    }
  }

  /* *convert reflection coefficients					 */

  for (i = 1; i <= p; i++)
  {
    a[i][i] = k[i-1];
    for (j = 1; j <= i-1; j++)
      a[j][i] = a[j][i-1] - k[i-1] * a[i-j][i-1];
  }
  pc[0] = 1.0;
  for (j = 1; j <= p; j++)
    pc[j] = -a[j][p];
}
