/**************************************************************************
*
* NAME
*	rctoac
*
* FUNCTION
*
*	convert reflection coefficients to autocorrelation coefficients
*
* SYNOPSIS
*
*	subroutine rctoac(rc, r, m)
*
*   formal 
*                       data	I/O
*	name		type	type	function
*	-------------------------------------------------------------------
*	rc[m]		float	i	reflection coefficients
*	r[m+1]		float	o	normalized autocorrelation coeff.
*	m		int	i	filter order
*
***************************************************************************
*	
* DESCRIPTION
*
*	Convert reflection coefficients to autocorrelation coefficients.
*	Where the sign convention is:
*
*	first reflection coefficient = +(normalized autocorrelation coef)
*	
***************************************************************************
*
* CALLED BY
*
*	specdist
*
* CALLS
*
*
*
***************************************************************************
*	
* REFERENCES
*
*	Atal & Hanauer, "Speech Analysis and Synthesis by Linear
*	Prediction of the Speech Wave," JASA, Vol 50 (2), 1971.
*
**************************************************************************/
rctoac(rc, r, m)
int m;
float rc[], r[];
{
  float t[26], tj, tkj;
  int k, j;

/*	array r contains the autocorrelation coefficients		*/

  r[0] = 1.0;
  for (k = 0; k < m; k++)
    r[k+1] = rc[k];
    
/*	compute predictor poly of diff deg and store in t
	compute autocorrelation function and store into r		*/

  t[0] = 1.0;
  t[1] = -r[1];
  if (m > 1) 
  {
    for (k = 2; k <= m; k++)
    {
      for (j = 1; j <= k/2; j++)
      {
        tj  = t[j] - r[k] * t[k-j];
        tkj = t[k-j] - r[k] * t[j];
        t[j] = tj;
        t[k-j]  = tkj;
      }
      t[k] = -r[k];
      for (j = 1; j <= k-1; j++)
      {
        r[k] -= r[k-j]*t[j];
      }
    }
  }
}
