/**************************************************************************
*
* ROUTINE
*               noise2
*
* FUNCTION
*
*               generates gaussian noise using the polar method
*
* SYNOPSIS
*               noise2(x1,x2)
*   formal 
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       x1              float     o       a sample of noise source
*       x2              float     o       another sample of noise source
*
***************************************************************************
*       
* USAGE
*
*	noise2 generates two samples of a Gaussian noise
*	source for each call using the polar method.
*
***************************************************************************
*
* CALLED FROM
*
*	codebook
*
* CALLS
*
*	random
*
***************************************************************************
*
* REFERENCES
*
*       Knuth, The Art of Programming, Volume 2
*
**************************************************************************/
#include <math.h>
noise2(x1,x2)
float *x1, *x2;
{
  float f1, f2, s, f[2];
  int i, j;
	
  /*	f(i) are samples from a uniform distribution
	in the range of 0.0 inclusive to 1.0 inclusive.    	*/
		
  do 
  {
    for (i=0; i < 2; i++)
    {
      for (j=1; j < 5; j++)
        f[i]=(float)(random2()+32768)/65535.;
    }
    f1=2.*f[0]-1.;
    f2=2.*f[1]-1.;
    s=f1*f1 + f2*f2;
  } while(s > 1.);

  s=sqrt(-2.*log(s)/s);
  *x1=f1*s;
  *x2=f2*s;
}
