/**************************************************************************
*
* ROUTINE
*               mark
*
* FUNCTION
*                
*               display prompts to indicate processing
*		(output to standard error)
*
* SYNOPSIS
*               subroutine mark (type)
*
*   formal 
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       type		int	i	0 - display a 'pump' (rotating bar)
*					1 - display a row of dots
*
***************************************************************************
*
* DESCRIPTION
*
*	This routine creates either a rotating bar or a row of dots, 
*	depending on what is specified, while code is executing.
*
***************************************************************************
*
* CALLED BY
*
*	celp
*
* CALLS
*
*
***************************************************************************
*
* REFERENCES
*
*
**************************************************************************/
#include <stdio.h>
mark(type)
int type;
{
  static int i;
  static char chr[] = "/-\\|";
  if (type)
  {
    fprintf(stderr,"%c",'.');
  }
  else
  {
    fprintf(stderr,"%c\b",chr[i++]);
    if (i > 3) i = 0;
  }
  fflush(stderr);
}
