/**************************************************************************
*
* ROUTINE
*               iodisk
*
* FUNCTION
*               16-bit disk i/o
* SYNOPSIS
*               function iodisk(mode, lun, fname, nrec, iar, size)
*
*   formal 
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*	mode		int	i	defines operation
*					-1 = close file
*					 1 = read
*					 2 = write
*					 3 = open for read
*					 4 = open for write
*	lun		int	i	logical unit number
*	fname		char	i	file name       
*	nrec		int	i/o	direct access record pointer
*					(auto increment)
*	iar		short	i/o	i/o data record
*	size		int	i	record size
*	iodisk		int	fun	status
*					 -1 => illegal input
*					  0 => open/close OK
*					size=> read/write OK
***************************************************************************
*	
* DESCRIPTION
*
*	Uses the UNIX System's Low Level I/O routines (open, 
*	close, read and write).	
*
***************************************************************************
*
* CALLED BY
*
*	celp
*
* CALLS
*
* 
**************************************************************************/
#include <stdio.h>
#include <sys/file.h>
iodisk(mode, lun, fname, nrec, iar, size)
int mode, *lun, *nrec, size;
short *iar;
char fname[];
{
  int i;

  if ((mode == 1 || mode == 2) && *nrec < 0)
  {
    printf("iodisk: Bad direct access record number %d\n", *nrec);
    return(-1);
  }
  switch (mode)
  {
    case 1: 					/* *read file		*/
      (*nrec)++;				/* *Warning, read errors*/
      if ((i = read(*lun, iar, size*2)) == EOF)	/* *aren't reported	*/
       	return(i);				/* *except no. of items	*/
      return(i/2);				/* *read is returned	*/
      
    case 2:					/* *write file		*/
      (*nrec)++;
      if ((i = write(*lun, iar, size*2)) == EOF)
      {
        printf("iodisk: Error writing output file %s\n", fname);
        return(i);
      }
      return(i/2);
    case 3:					/* *open file for read	*/
      if ((*lun = open(fname, O_RDONLY, 0644)) == NULL)
      {
        printf("iodisk: Error opening input file %s\n", fname);
        return(-1);
      }
      return(0);
    case 4:					/* *open file for write	*/
      if ((*lun = open(fname,O_WRONLY|O_CREAT|O_TRUNC, 0644)) == NULL)
      {
        printf("iodisk: Error opening output file %s\n", fname);
        return(-1);
      }
      return(0);
    case -1:					/* *close file		*/
      if (close(*lun) == EOF)
      {
        printf("iodisk: Error closing file %s\n", fname);
        return(-1);
      }
      return(0);
    default:					/* *illegal mode	*/
      printf("iodisk: Illegal mode %d\n", mode);
      return(-1);
  }
}
