/**************************************************************************
*
* ROUTINE
*               ham
*
* FUNCTION
*               creates hamming window
*
* SYNOPSIS
*               subroutine ham(win, n)
*   formal 
*
*                       data    I/O
*       name            type    type    function
*       -------------------------------------------------------------------
*       win(n)          float   i/o     hamming window
*       n               int     i       dim of win
*
***************************************************************************
*
* DESCRIPTION
*
*
*
***************************************************************************
*
* CALLED BY
*
*	celp  delay
*
* CALLS
*
*
*
**************************************************************************/
#include <math.h>
ham(win, n)
int n;
float win[];
{
  int i;
  float pi;

  pi = 4.0 * atan(1.0);
  for (i = 0; i < n; i++)
    win[i] = 0.54 - 0.46 * cos((2.0 * pi * (i)) / (n-1));
}
